/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Semaphore;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.TCPChannelCache;
import net.tomp2p.message.TomP2PDecoderTCP;
import net.tomp2p.message.TomP2PDecoderUDP;
import net.tomp2p.message.TomP2PEncoderStage1;
import net.tomp2p.message.TomP2PEncoderStage2;
import net.tomp2p.utils.Utils;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.traffic.GlobalTrafficShapingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCollector {
    private boolean disposeTCP = false;
    private boolean disposeUDP = false;
    private final ChannelGroup channelsTCP = new DefaultChannelGroup("TomP2P ConnectionPool TCP");
    private final ChannelGroup channelsUDP = new DefaultChannelGroup("TomP2P ConnectionPool UDP");
    private static final ChannelHandler encoder1 = new TomP2PEncoderStage1();
    private static final ChannelHandler encoder2 = new TomP2PEncoderStage2();
    private final Semaphore semaphoreUDPMessages;
    private final MySemaphoreTCP semaphoreTCPMessages;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionCollector.class);
    private final int maxMessageSize;
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final ExecutionHandler executionHandlerSender;
    private final GlobalTrafficShapingHandler globalTrafficShapingHandler;

    public ConnectionCollector(ChannelFactory tcpClientChannelFactory, ChannelFactory udpChannelFactory, ConnectionConfiguration configuration, ExecutionHandler executionHandlerSender, GlobalTrafficShapingHandler globalTrafficShapingHandler) {
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpChannelFactory;
        this.semaphoreUDPMessages = new Semaphore(configuration.getMaxOutgoingUDP(), true);
        this.semaphoreTCPMessages = new MySemaphoreTCP(configuration.getMaxOutgoingTCP());
        this.maxMessageSize = configuration.getMaxMessageSize();
        this.executionHandlerSender = executionHandlerSender;
        this.globalTrafficShapingHandler = globalTrafficShapingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture channelTCP(ChannelHandler timeoutHandler, ChannelHandler dispatcherReply, SocketAddress remoteAddress, int connectTimeoutMillis, TCPChannelCache channelChache) throws ChannelException, InterruptedException {
        boolean acquired = false;
        long start = System.currentTimeMillis();
        long waitTime = 0L;
        MySemaphoreTCP mySemaphoreTCP = this.semaphoreTCPMessages;
        synchronized (mySemaphoreTCP) {
            while (!acquired && waitTime < (long)connectTimeoutMillis) {
                acquired = this.semaphoreTCPMessages.tryAcquire();
                if (acquired) continue;
                channelChache.expireCache();
                waitTime = System.currentTimeMillis() - start;
                this.semaphoreTCPMessages.wait(connectTimeoutMillis / 2);
            }
            if (!acquired) {
                return null;
            }
        }
        int failCounter = 0;
        while (true) {
            ChannelGroup channelGroup = this.channelsTCP;
            synchronized (channelGroup) {
                if (this.disposeTCP) {
                    logger.warn("tpc disposed, not returning a channel");
                    MySemaphoreTCP mySemaphoreTCP2 = this.semaphoreTCPMessages;
                    synchronized (mySemaphoreTCP2) {
                        this.semaphoreTCPMessages.release();
                        this.semaphoreTCPMessages.notifyAll();
                    }
                    throw new ChannelException("tpc disposed, not returning a channel");
                }
                try {
                    ChannelFuture channelFuture = this.createChannelTCP(timeoutHandler, dispatcherReply, remoteAddress, new InetSocketAddress(0), connectTimeoutMillis);
                    Channel channel = channelFuture.getChannel();
                    this.channelsTCP.add((Object)channel);
                    channel.getCloseFuture().addListener(new ChannelFutureListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            MySemaphoreTCP mySemaphoreTCP = ConnectionCollector.this.semaphoreTCPMessages;
                            synchronized (mySemaphoreTCP) {
                                ConnectionCollector.this.semaphoreTCPMessages.release();
                                ConnectionCollector.this.semaphoreTCPMessages.notifyAll();
                            }
                        }
                    });
                    return channelFuture;
                }
                catch (ChannelException ce) {
                    logger.warn("tried " + failCounter + " times " + ce.toString());
                    Utils.sleep(100L);
                    if (++failCounter > 5) {
                        logger.error("tried 5 times " + ce.toString());
                        ce.printStackTrace();
                        MySemaphoreTCP mySemaphoreTCP3 = this.semaphoreTCPMessages;
                        synchronized (mySemaphoreTCP3) {
                            this.semaphoreTCPMessages.release();
                            this.semaphoreTCPMessages.notifyAll();
                        }
                        throw ce;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel channelUDP(ChannelHandler timeoutHandler, ChannelHandler replyHandler, boolean allowBroadcast) throws ChannelException {
        this.semaphoreUDPMessages.acquireUninterruptibly();
        int failCounter = 0;
        while (true) {
            ChannelGroup channelGroup = this.channelsUDP;
            synchronized (channelGroup) {
                if (this.disposeUDP) {
                    logger.warn("upd disposed, not returning a channel");
                    this.semaphoreUDPMessages.release();
                    throw new ChannelException("upd disposed, not returning a channel");
                }
                try {
                    Channel channel = this.createChannelUDP(timeoutHandler, replyHandler, allowBroadcast);
                    this.channelsUDP.add((Object)channel);
                    channel.getCloseFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ConnectionCollector.this.semaphoreUDPMessages.release();
                        }
                    });
                    return channel;
                }
                catch (ChannelException ce) {
                    logger.warn("tried " + failCounter + " times " + ce.toString());
                    Utils.sleep(100L);
                    if (++failCounter > 5) {
                        logger.error("tried 5 times " + ce.toString());
                        ce.printStackTrace();
                        this.semaphoreUDPMessages.release();
                        throw ce;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ChannelGroup channelGroup = this.channelsTCP;
        synchronized (channelGroup) {
            this.disposeTCP = true;
            this.channelsTCP.close().awaitUninterruptibly();
        }
        channelGroup = this.channelsUDP;
        synchronized (channelGroup) {
            this.disposeUDP = true;
            this.channelsUDP.close().awaitUninterruptibly();
        }
    }

    private ChannelFuture createChannelTCP(ChannelHandler timeoutHandler, ChannelHandler dispatcherReply, SocketAddress remoteAddress, SocketAddress localAddress, int connectionTimoutMillis) {
        ClientBootstrap bootstrap = new ClientBootstrap(this.tcpClientChannelFactory);
        bootstrap.setOption("connectTimeoutMillis", (Object)connectionTimoutMillis);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("soLinger", (Object)0);
        this.setupBootstrap((Bootstrap)bootstrap, timeoutHandler, dispatcherReply, (ChannelUpstreamHandler)new TomP2PDecoderTCP(this.maxMessageSize));
        return bootstrap.connect(remoteAddress);
    }

    private Channel createChannelUDP(ChannelHandler timeoutHandler, ChannelHandler replyHandler, boolean allowBroadcast) {
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap(this.udpChannelFactory);
        this.setupBootstrap((Bootstrap)bootstrap, timeoutHandler, replyHandler, new TomP2PDecoderUDP());
        bootstrap.setOption("broadcast", (Object)(allowBroadcast ? 1 : 0));
        bootstrap.setOption("receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1400));
        Channel c = bootstrap.bind((SocketAddress)new InetSocketAddress(0));
        return c;
    }

    private void setupBootstrap(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler dispatcherReply, ChannelUpstreamHandler decoder) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("encoder2", encoder2);
        pipe.addLast("encoder1", encoder1);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (dispatcherReply != null) {
            if (this.globalTrafficShapingHandler.hasLimit()) {
                pipe.addLast("trafficShaping", (ChannelHandler)this.globalTrafficShapingHandler);
            }
            pipe.addLast("executor", (ChannelHandler)this.executionHandlerSender);
            pipe.addLast("reply", dispatcherReply);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("collector enabled = tcp:");
        sb.append(!this.disposeTCP).append(", upd:").append(!this.disposeUDP);
        sb.append("; available permits = tcp:").append(this.semaphoreTCPMessages.availablePermits());
        sb.append(", udp:").append(this.semaphoreUDPMessages.availablePermits());
        return sb.toString();
    }

    private static class MySemaphoreTCP {
        private final int maxPermits;
        private int currentPermits;

        public MySemaphoreTCP(int maxPermits) {
            this.maxPermits = maxPermits;
            this.currentPermits = 0;
        }

        public Object availablePermits() {
            return this.maxPermits - this.currentPermits;
        }

        public void release() {
            --this.currentPermits;
        }

        public boolean tryAcquire() {
            if (this.currentPermits < this.maxPermits) {
                ++this.currentPermits;
                return true;
            }
            return false;
        }
    }
}

