/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ConnectionCollector;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.IdleStateHandler;
import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.connection.TCPChannelCache;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger logger = LoggerFactory.getLogger(Sender.class);
    private final Timer timer;
    private final ConnectionCollector connectionCollector;
    private final ConnectionConfiguration configuration;
    private final BlockingQueue<Runnable> sendTaskQueue = new LinkedBlockingQueue<Runnable>();
    private final Thread senderThread;
    private final TCPChannelCache channelChache;
    private volatile boolean running = true;

    public Sender(ConnectionCollector connectionCollector, ConnectionConfiguration configuration, TCPChannelCache channelChache, Timer timer) {
        this.channelChache = channelChache;
        this.connectionCollector = connectionCollector;
        this.configuration = configuration;
        this.timer = timer;
        this.senderThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (Sender.this.running) {
                    try {
                        block8: {
                            Runnable runner = (Runnable)Sender.this.sendTaskQueue.take();
                            try {
                                runner.run();
                            }
                            catch (Exception e) {
                                logger.error("Error while sending " + e.toString());
                                if (!logger.isDebugEnabled()) break block8;
                                e.printStackTrace();
                            }
                        }
                        BlockingQueue blockingQueue = Sender.this.sendTaskQueue;
                        synchronized (blockingQueue) {
                            Sender.this.sendTaskQueue.notifyAll();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        this.senderThread.start();
    }

    public void sendTCP(Message message, RequestHandlerTCP handler) {
        this.sendTCP("any", message, handler);
    }

    public void sendTCP(String channelName, Message message, RequestHandlerTCP handler) {
        this.sendTCP(channelName, message.getRecipient(), handler, message);
    }

    public void sendUDP(Message message, RequestHandlerUDP handler) {
        this.sendUDP(message.getRecipient(), handler, message, false);
    }

    public void sendBroadcastUDP(Message message, RequestHandlerUDP handler) {
        this.sendUDP(message.getRecipient(), handler, message, true);
    }

    public void shutdown() {
        this.running = false;
        this.senderThread.interrupt();
        this.connectionCollector.shutdown();
    }

    public ConnectionCollector getConnectionCollector() {
        return this.connectionCollector;
    }

    private void sendTCP(final String channelName, PeerAddress remoteNode, final RequestHandlerTCP requestHandler, final Message message) {
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
            logger.debug("we are TCP from " + Thread.currentThread().getName() + ", do not block! ");
            this.sendTaskQueue.offer(new Runnable(){

                @Override
                public void run() {
                    Sender.this.sendTCP0(channelName, requestHandler, message);
                }
            });
        } else {
            FutureResponse futureResponse;
            logger.debug("here TCP we can block! " + Thread.currentThread().getName());
            FutureResponse futureResponse2 = futureResponse = requestHandler == null ? null : requestHandler.getFutureResponse();
            if (this.waitForConnection(futureResponse)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("send TCP " + Thread.currentThread().getName());
                }
                this.sendTCP0(channelName, requestHandler, message);
            }
        }
    }

    private void sendUDP(final PeerAddress remoteNode, final RequestHandlerUDP requestHandler, final Message message, final boolean broadcast) {
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
            logger.debug("we are UDP from " + Thread.currentThread().getName() + ", do not block! ");
            this.sendTaskQueue.offer(new Runnable(){

                @Override
                public void run() {
                    Sender.this.sendUDP0(remoteNode, requestHandler, message, broadcast);
                }
            });
        } else {
            FutureResponse futureResponse;
            logger.debug("here UDP we can block! " + Thread.currentThread().getName());
            FutureResponse futureResponse2 = futureResponse = requestHandler == null ? null : requestHandler.getFutureResponse();
            if (this.waitForConnection(futureResponse)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("send UDP " + Thread.currentThread().getName());
                }
                this.sendUDP0(remoteNode, requestHandler, message, broadcast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForConnection(FutureResponse futureResponse) {
        while (this.sendTaskQueue.size() > 100) {
            BlockingQueue<Runnable> blockingQueue = this.sendTaskQueue;
            synchronized (blockingQueue) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("slow down, the queue size is " + this.sendTaskQueue.size());
                    }
                    this.sendTaskQueue.wait();
                }
                catch (InterruptedException e) {
                    logger.error("error in waitforconn");
                    e.printStackTrace();
                    if (futureResponse != null) {
                        futureResponse.setFailed("Interrupted");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private void sendTCP0(String channelName, RequestHandlerTCP requestHandler, final Message message) {
        final FutureResponse futureResponse = requestHandler.getFutureResponse();
        if (futureResponse.isCompleted()) {
            return;
        }
        try {
            IdleStateHandler timeoutHandler = new IdleStateHandler(this.timer, this.configuration.getIdleTCPMillis(), TimeUnit.MILLISECONDS);
            final ChannelFuture channelFuture = this.channelChache.getChannel(channelName, (ChannelHandler)timeoutHandler, futureResponse, this.configuration.getConnectTimeoutMillis(), this.configuration.getIdleTCPMillis(), message, requestHandler);
            if (channelFuture == null) {
                futureResponse.setFailed("could not get channel in " + this.configuration.getConnectTimeoutMillis() + "ms");
                return;
            }
            final Cancellable cancel1 = new Cancellable(){

                @Override
                public void cancel() {
                    channelFuture.cancel();
                }
            };
            futureResponse.addCancellation(cancel1);
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    futureResponse.removeCancellation(cancel1);
                    if (future.isSuccess() && !channelFuture.isCancelled()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("send TCP message " + message);
                        }
                        ChannelFuture writeFuture = future.getChannel().write((Object)message);
                        Sender.this.afterSend(writeFuture, futureResponse, true, message);
                    } else {
                        future.getChannel().close();
                        if (channelFuture.isCancelled()) {
                            futureResponse.cancel();
                        } else {
                            logger.warn("Failed to connect channel " + Sender.this.connectionCollector + "/" + future.getChannel().isBound() + "/" + future.getChannel().isConnected() + "/" + future.getChannel().isOpen() + " / " + future.isCancelled() + " /ch:" + channelFuture.getChannel());
                            if (future.getCause() != null) {
                                future.getCause().printStackTrace();
                            }
                            futureResponse.setFailed("Connect failed " + future);
                        }
                    }
                }
            });
        }
        catch (Exception ce) {
            futureResponse.setFailed("Could not get channel " + ce.toString());
            if (logger.isWarnEnabled()) {
                logger.warn(ce.toString());
            }
            if (logger.isDebugEnabled()) {
                ce.printStackTrace();
            }
            return;
        }
    }

    private void sendUDP0(PeerAddress remoteNode, RequestHandlerUDP replyHandler, Message message, boolean broadcast) {
        FutureResponse futureResponse = replyHandler.getFutureResponse();
        if (futureResponse.isCompleted()) {
            return;
        }
        ReplyTimeoutHandler replyTimeoutHandler = null;
        if (replyHandler != null) {
            replyTimeoutHandler = new ReplyTimeoutHandler(this.timer, this.configuration.getIdleUDPMillis(), remoteNode);
            futureResponse.setReplyTimeoutHandler(replyTimeoutHandler);
        }
        try {
            Channel channel = this.connectionCollector.channelUDP((ChannelHandler)replyTimeoutHandler, (ChannelHandler)replyHandler, broadcast);
            ChannelFuture writeFuture = channel.write((Object)message, (SocketAddress)remoteNode.createSocketUDP());
            this.afterSend(writeFuture, futureResponse, false, message);
        }
        catch (Exception ce) {
            futureResponse.setFailed("Could not get channel " + ce.toString());
            logger.warn(ce.toString());
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send UDP message " + message);
        }
    }

    private void afterSend(final ChannelFuture writeFuture, final FutureResponse futureResponse, final boolean tcp, final Message message) {
        final Cancellable cancel2 = new Cancellable(){

            @Override
            public void cancel() {
                writeFuture.cancel();
            }
        };
        futureResponse.addCancellation(cancel2);
        writeFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture writeFuture) {
                futureResponse.removeCancellation(cancel2);
                if (!writeFuture.isSuccess()) {
                    writeFuture.getChannel().close();
                    if (writeFuture.isCancelled()) {
                        futureResponse.cancel();
                    } else {
                        futureResponse.setFailed("Write failed");
                        logger.warn("Failed to write channel the request " + futureResponse.getRequest());
                    }
                } else if (tcp && !message.isFireAndForget()) {
                    futureResponse.setReplyTimeout(System.currentTimeMillis() + (long)Sender.this.configuration.getTimeoutTCPMillis());
                }
                if (message.isFireAndForget()) {
                    futureResponse.setResponse(null);
                }
            }
        });
    }

    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }
}

