/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageCodec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomP2PDecoderTCP
extends FrameDecoder {
    private static final Logger logger = LoggerFactory.getLogger(TomP2PDecoderTCP.class);
    private final int maxMessageSize;
    private volatile Message message = null;

    public TomP2PDecoderTCP() {
        this(Integer.MAX_VALUE);
    }

    public TomP2PDecoderTCP(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.message == null && buffer.readableBytes() >= 64) {
            SocketAddress sa = channel.getRemoteAddress();
            this.message = MessageCodec.decodeHeader(buffer, ((InetSocketAddress)sa).getAddress());
            if (this.message.getContentLength() + 64 > this.maxMessageSize) {
                throw new DecoderException("Messag too large :" + (this.message.getContentLength() + 64) + " allowed are: " + this.maxMessageSize);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("got header in decoder " + this.message);
            }
        }
        if (this.message != null && this.message.getContentLength() == 0) {
            return this.cleanupAndReturnMessage();
        }
        if (this.message != null && buffer.readableBytes() >= this.message.getContentLength()) {
            MessageCodec.decodePayload(this.message.getContentType1(), buffer, this.message);
            MessageCodec.decodePayload(this.message.getContentType2(), buffer, this.message);
            MessageCodec.decodePayload(this.message.getContentType3(), buffer, this.message);
            MessageCodec.decodePayload(this.message.getContentType4(), buffer, this.message);
            return this.cleanupAndReturnMessage();
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (logger.isDebugEnabled()) {
            e.getCause().printStackTrace();
        }
        if (e.getCause().getMessage() == null) {
            ctx.sendUpstream((ChannelEvent)e);
            return;
        }
        if (e.getCause().getMessage().equals("Connection reset by peer")) {
            ctx.sendUpstream((ChannelEvent)e);
            return;
        }
    }

    private Message cleanupAndReturnMessage() {
        Message tmp = this.message;
        this.message = null;
        if (logger.isDebugEnabled()) {
            logger.debug("cleanupAndReturnMessage " + tmp);
        }
        tmp.setTCP();
        tmp.finished();
        return tmp;
    }
}

