/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageCodec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

@ChannelHandler.Sharable
public class TomP2PDecoderUDP
implements ChannelUpstreamHandler {
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Object decodedMessage;
        if (!(evt instanceof MessageEvent)) {
            ctx.sendUpstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (originalMessage == (decodedMessage = this.decode(ctx, e.getChannel(), originalMessage, e.getRemoteAddress()))) {
            ctx.sendUpstream(evt);
        } else {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)decodedMessage, (SocketAddress)e.getRemoteAddress());
        }
    }

    private Object decode(ChannelHandlerContext ctx, Channel channel, Object obj, SocketAddress socketAddress) throws Exception {
        if (!(obj instanceof ChannelBuffer)) {
            return obj;
        }
        ChannelBuffer buffer = (ChannelBuffer)obj;
        if (buffer.readableBytes() >= 64) {
            Message message = MessageCodec.decodeHeader(buffer, ((InetSocketAddress)socketAddress).getAddress());
            message.setUDP();
            message.finished();
            if (message.getContentLength() > 0) {
                if (buffer.readableBytes() >= message.getContentLength()) {
                    MessageCodec.decodePayload(message.getContentType1(), buffer, message);
                    MessageCodec.decodePayload(message.getContentType2(), buffer, message);
                    MessageCodec.decodePayload(message.getContentType3(), buffer, message);
                    MessageCodec.decodePayload(message.getContentType4(), buffer, message);
                } else {
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected " + message.getContentLength() + " got " + buffer.readableBytes()));
                }
            }
            return message;
        }
        return obj;
    }
}

