/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.nio.ByteOrder;
import net.tomp2p.message.IntermediateMessage;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TomP2PEncoderStage2
extends OneToOneEncoder {
    private static final Logger logger = LoggerFactory.getLogger(TomP2PEncoderStage2.class);

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof IntermediateMessage)) {
            return msg;
        }
        IntermediateMessage message = (IntermediateMessage)msg;
        ByteOrder order = message.getBuffers().get(0).order();
        if (logger.isDebugEnabled()) {
            logger.debug("sending message over the wire " + message.getMessage());
        }
        return new CompositeChannelBuffer(order, message.getBuffers());
    }
}

