/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.p2p.Routing;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.TrackerConfiguration;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTracker {
    private static final Logger logger = LoggerFactory.getLogger(DistributedTracker.class);
    private static final int MAX_FULL_TRACKERS = 4;
    private final Routing routing;
    private final PeerBean peerBean;
    private final TrackerRPC trackerRPC;

    public DistributedTracker(PeerBean peerBean, Routing routing, TrackerRPC trackerRPC) {
        this.routing = routing;
        this.trackerRPC = trackerRPC;
        this.peerBean = peerBean;
    }

    public FutureTracker getFromTracker(final Number160 locationKey, final Number160 domainKey, RoutingConfiguration routingConfiguration, final TrackerConfiguration trackerConfiguration, final boolean expectAttachement, EvaluatingSchemeTracker evaluatingScheme, final boolean signMessage) {
        final FutureTracker futureTracker = new FutureTracker(evaluatingScheme);
        final FutureRouting futureRouting = this.createRouting(locationKey, domainKey, null, routingConfiguration, trackerConfiguration, true);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting future) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("found direct hits for tracker get: " + futureRouting.getDirectHits());
                    }
                    DistributedTracker.this.loop(locationKey, domainKey, futureRouting.getDirectHits(), trackerConfiguration, futureTracker, true, new Operation(){

                        @Override
                        public FutureResponse create(PeerAddress remoteNode, boolean primary) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("tracker get: " + remoteNode + " location=" + locationKey);
                            }
                            return DistributedTracker.this.trackerRPC.getFromTracker(remoteNode, locationKey, domainKey, expectAttachement, signMessage);
                        }
                    });
                } else {
                    futureTracker.setFailed("routing failed");
                }
            }
        });
        return futureTracker;
    }

    public FutureTracker addToTracker(final Number160 locationKey, final Number160 domainKey, final Data attachement, RoutingConfiguration routingConfiguration, final TrackerConfiguration trackerConfiguration, final boolean signMessage, FutureCreate<FutureTracker> futureCreate) {
        final FutureTracker futureTracker = new FutureTracker();
        futureTracker.setFutureCreate(futureCreate);
        final FutureRouting futureRouting = this.createRouting(locationKey, domainKey, null, routingConfiguration, trackerConfiguration, false);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting future) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("found potential hits for tracker add: " + futureRouting.getPotentialHits());
                    }
                    DistributedTracker.this.loop(locationKey, domainKey, futureRouting.getPotentialHits(), trackerConfiguration, futureTracker, false, new Operation(){

                        @Override
                        public FutureResponse create(PeerAddress remoteNode, boolean primary) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("tracker add: " + remoteNode + " location=" + locationKey);
                            }
                            return DistributedTracker.this.trackerRPC.addToTracker(remoteNode, locationKey, domainKey, attachement, signMessage, primary);
                        }
                    });
                } else {
                    futureTracker.setFailed("routing failed");
                }
            }
        });
        return futureTracker;
    }

    private void loop(Number160 locationKey, Number160 domainKey, SortedSet<PeerAddress> queueToAsk, TrackerConfiguration trackerConfiguration, FutureTracker futureTracker, boolean cancelOnFinish, Operation operation) {
        FutureResponse[] futureResponses = new FutureResponse[trackerConfiguration.getParallel()];
        TreeSet<PeerAddress> secondaryQueue = new TreeSet<PeerAddress>(this.peerBean.getPeerMap().createPeerComparator());
        this.loopRec(queueToAsk, secondaryQueue, new HashSet<PeerAddress>(), new HashMap<PeerAddress, Map<PeerAddress, Data>>(), operation, trackerConfiguration.getParallel(), new AtomicInteger(0), trackerConfiguration.getMaxFailure(), new AtomicInteger(0), queueToAsk.size() + 4, new AtomicInteger(0), trackerConfiguration.getAtLeastSucessfulRequestes(), trackerConfiguration.getAtLeastTrackers(), futureResponses, futureTracker, cancelOnFinish);
    }

    private void loopRec(final SortedSet<PeerAddress> queueToAsk, final SortedSet<PeerAddress> secondaryQueue, final Set<PeerAddress> alreadyAsked, final Map<PeerAddress, Map<PeerAddress, Data>> peerOnTracker, final Operation operation, final int parallel, final AtomicInteger nrFailures, final int maxFailures, final AtomicInteger trackerFull, final int maxTrackerFull, final AtomicInteger successfulRequests, final int atLeastSuccessfullRequests, final int atLeastPeersOnTrackers, final FutureResponse[] futureResponses, final FutureTracker futureTracker, final boolean cancelOnFinish) {
        int active = 0;
        for (int i = 0; i < parallel; ++i) {
            if (futureResponses[i] == null) {
                boolean primary = true;
                PeerAddress next = Utils.pollFirst(queueToAsk);
                if (next == null) {
                    next = Utils.pollFirst(secondaryQueue);
                    primary = false;
                }
                if (next == null) continue;
                alreadyAsked.add(next);
                ++active;
                futureResponses[i] = operation.create(next, primary);
                continue;
            }
            if (futureResponses[i] == null) continue;
            ++active;
        }
        if (active == 0) {
            queueToAsk.addAll(secondaryQueue);
            futureTracker.setTrackers(queueToAsk, alreadyAsked, peerOnTracker);
            Routing.cancel(cancelOnFinish, parallel, futureResponses);
            return;
        }
        FutureForkJoin fp = new FutureForkJoin(1, false, (BaseFuture[])futureResponses);
        fp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean success;
                boolean finished = false;
                FutureResponse futureResponse = future.getLast();
                boolean bl = success = futureResponse != null && futureResponse.getResponse() != null && future.getLast().getResponse().isNotOk();
                if (future.isSuccess() || success) {
                    Map<Number160, Data> newDataMap = futureResponse.getResponse().getDataMap();
                    DistributedTracker.mergeC(secondaryQueue, newDataMap.values(), alreadyAsked);
                    DistributedTracker.merge(peerOnTracker, newDataMap, futureResponse.getRequest().getRecipient());
                    int successRequests = success ? successfulRequests.get() : successfulRequests.incrementAndGet();
                    finished = DistributedTracker.this.evaluate(peerOnTracker, successRequests, atLeastSuccessfullRequests, atLeastPeersOnTrackers);
                    if (!finished && success) {
                        logger.debug("this tracker was full");
                        finished = trackerFull.incrementAndGet() >= maxTrackerFull;
                    }
                } else {
                    logger.debug("no success " + future.getFailedReason());
                    boolean bl2 = finished = nrFailures.incrementAndGet() > maxFailures;
                }
                if (finished) {
                    queueToAsk.addAll(secondaryQueue);
                    futureTracker.setTrackers(queueToAsk, alreadyAsked, peerOnTracker);
                    Routing.cancel(cancelOnFinish, parallel, futureResponses);
                } else {
                    DistributedTracker.this.loopRec(queueToAsk, secondaryQueue, alreadyAsked, peerOnTracker, operation, parallel, nrFailures, maxFailures, trackerFull, maxTrackerFull, successfulRequests, atLeastSuccessfullRequests, atLeastPeersOnTrackers, futureResponses, futureTracker, cancelOnFinish);
                }
            }
        });
    }

    private boolean evaluate(Map<?, ?> peerOnTracker, int successfulRequests, int atLeastSuccessfulRequests, int atLeastTrackers) {
        return successfulRequests >= atLeastSuccessfulRequests && peerOnTracker.size() >= atLeastTrackers;
    }

    private FutureRouting createRouting(Number160 locationKey, Number160 domainKey, Set<Number160> contentKeys, RoutingConfiguration routingConfiguration, TrackerConfiguration trackerConfiguration, boolean isDigest) {
        return this.routing.route(locationKey, domainKey, contentKeys, Message.Command.NEIGHBORS_TRACKER, routingConfiguration.getDirectHits(), routingConfiguration.getMaxNoNewInfo(trackerConfiguration.getAtLeastSucessfulRequestes()), routingConfiguration.getMaxFailures(), routingConfiguration.getParallel(), isDigest);
    }

    static boolean evaluateInformation(Collection<PeerAddress> newNeighbors, SortedSet<PeerAddress> queueToAsk, Set<PeerAddress> alreadyAsked, AtomicInteger noNewInfo, int maxNoNewInfo) {
        boolean newInformation = DistributedTracker.merge(queueToAsk, newNeighbors, alreadyAsked);
        if (newInformation) {
            noNewInfo.set(0);
            return false;
        }
        return noNewInfo.incrementAndGet() >= maxNoNewInfo;
    }

    static void merge(Map<PeerAddress, Map<PeerAddress, Data>> peerOnTracker, Map<Number160, Data> newDataMap, PeerAddress reporter) {
        for (Data data : newDataMap.values()) {
            PeerAddress peer = data.getPeerAddress();
            Map<PeerAddress, Data> peerOnTrackerEntry = peerOnTracker.get(peer);
            if (peerOnTrackerEntry == null) {
                peerOnTrackerEntry = new HashMap<PeerAddress, Data>();
                peerOnTracker.put(peer, peerOnTrackerEntry);
            }
            peerOnTrackerEntry.put(reporter, data);
        }
    }

    static boolean mergeC(Collection<PeerAddress> queueToAsk, Collection<Data> newData, Set<PeerAddress> alreadyAsked) {
        HashSet<PeerAddress> newNeighbors = new HashSet<PeerAddress>();
        for (Data data : newData) {
            newNeighbors.add(data.getPeerAddress());
        }
        return DistributedTracker.merge(queueToAsk, newNeighbors, alreadyAsked);
    }

    static boolean merge(Collection<PeerAddress> queueToAsk, Collection<PeerAddress> newNeighbors, Set<PeerAddress> alreadyAsked) {
        HashSet<PeerAddress> result = new HashSet<PeerAddress>();
        Utils.difference(newNeighbors, alreadyAsked, result);
        if (result.size() == 0) {
            return false;
        }
        int size1 = queueToAsk.size();
        queueToAsk.addAll(result);
        int size2 = queueToAsk.size();
        return size1 < size2;
    }

    public static interface Operation {
        public FutureResponse create(PeerAddress var1, boolean var2);
    }
}

