/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(HandshakeRPC.class);
    private final boolean enable;
    private final boolean wait;

    public HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true, true, false);
    }

    HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean enable, boolean register, boolean wait) {
        super(peerBean, connectionBean);
        this.enable = enable;
        this.wait = wait;
        if (register) {
            this.registerIoHandler(Message.Command.PING);
        }
    }

    public FutureResponse pingBroadcastUDP(PeerAddress remoteNode) {
        return this.createHandlerUDP(remoteNode).sendBroadcastUDP();
    }

    public FutureResponse pingUDP(PeerAddress remoteNode) {
        return this.createHandlerUDP(remoteNode).sendUDP();
    }

    public FutureResponse pingTCP(PeerAddress remoteNode) {
        return this.createHandlerTCP(remoteNode).sendTCP();
    }

    public FutureResponse fireUDP(PeerAddress remoteNode) {
        return this.createHandlerUDP(remoteNode).fireAndForgetUDP();
    }

    public FutureResponse fireTCP(PeerAddress remoteNode) {
        return this.createHandlerTCP(remoteNode).fireAndForgetTCP();
    }

    private RequestHandlerUDP createHandlerUDP(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_1);
        return new RequestHandlerUDP(this.peerBean, this.connectionBean, message);
    }

    private RequestHandlerTCP createHandlerTCP(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_1);
        return new RequestHandlerTCP(this.peerBean, this.connectionBean, message);
    }

    public FutureResponse pingUDPDiscover(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_2);
        ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
        self.add(this.peerBean.getServerPeerAddress());
        message.setNeighbors(self);
        return new RequestHandlerUDP(this.peerBean, this.connectionBean, message).sendUDP();
    }

    public FutureResponse pingTCPDiscover(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_2);
        ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
        self.add(this.peerBean.getServerPeerAddress());
        message.setNeighbors(self);
        return new RequestHandlerTCP(this.peerBean, this.connectionBean, message).sendTCP();
    }

    public FutureResponse pingUDPProbe(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_3);
        return new RequestHandlerUDP(this.peerBean, this.connectionBean, message).sendUDP();
    }

    public FutureResponse pingTCPProbe(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_3);
        return new RequestHandlerTCP(this.peerBean, this.connectionBean, message).sendTCP();
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_3) && message.getCommand() == Message.Command.PING;
    }

    @Override
    public Message handleResponse(Message message) throws Exception {
        if (message.getType() == Message.Type.REQUEST_3) {
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            responseMessage.setMessageId(message.getMessageId());
            if (message.isUDP()) {
                this.fireUDP(message.getSender());
            } else {
                this.fireTCP(message.getSender());
            }
            return responseMessage;
        }
        if (message.getType() == Message.Type.REQUEST_2) {
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            responseMessage.setMessageId(message.getMessageId());
            ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
            self.add(message.getRealSender());
            message.setNeighbors(self);
            return responseMessage;
        }
        if (this.enable) {
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            responseMessage.setMessageId(message.getMessageId());
            if (this.wait) {
                Utils.sleep(10000L);
            }
            return responseMessage;
        }
        logger.debug("do not reply");
        if (this.wait) {
            Utils.sleep(10000L);
        }
        return null;
    }
}

