/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;

public class Data
implements Serializable {
    private static final long serialVersionUID = -5023493840082652284L;
    public static final PublicKey FROM_MESSAGE = new EmptyPublicKey();
    private final byte[] data;
    private final int offset;
    private final int length;
    private final long validFromMillis;
    private int ttlSeconds;
    private Number160 hash;
    private boolean protectedEntry;
    private boolean directReplication;
    private PublicKey dataPublicKey;
    private byte[] signature;
    private PeerAddress originator;

    public Data(Object object) throws IOException {
        this(object, null);
    }

    public Data(Object object, PeerAddress originator) throws IOException {
        this(Utils.encodeJavaObject(object), originator);
    }

    public Data(byte[] data) {
        this(data, (PeerAddress)null);
    }

    public Data(byte[] data, PeerAddress originator) {
        this(data, 0, data.length, originator);
    }

    public Data(byte[] data, int offset, int length, PeerAddress originator) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.validFromMillis = System.currentTimeMillis();
        this.originator = originator;
    }

    public byte[] getData() {
        return this.data;
    }

    public Object getObject() throws ClassNotFoundException, IOException {
        return Utils.decodeJavaObject(this.data, this.offset, this.length);
    }

    public long getCreated() {
        return this.validFromMillis;
    }

    public int getTTLSeconds() {
        return this.ttlSeconds;
    }

    public void setTTLSeconds(int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
    }

    public Number160 getHash() {
        if (this.hash == null) {
            this.hash = Utils.makeSHAHash(this.data, this.offset, this.length);
        }
        return this.hash;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public long getExpirationMillis() {
        return this.ttlSeconds <= 0 ? Long.MAX_VALUE : this.validFromMillis + (long)this.ttlSeconds * 1000L;
    }

    public PublicKey getDataPublicKey() {
        return this.dataPublicKey;
    }

    public void setDataPublicKey(PublicKey dataPublicKey) {
        this.dataPublicKey = dataPublicKey;
    }

    public void signAndSetPublicKey(KeyPair keyPair) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PrivateKey privateKey = keyPair.getPrivate();
        Signature signatureAlgorithm = Signature.getInstance("SHA1withDSA");
        signatureAlgorithm.initSign(privateKey);
        signatureAlgorithm.update(this.data, this.offset, this.length);
        byte[] ttl = Utils.intToByteArray(this.ttlSeconds);
        signatureAlgorithm.update(ttl);
        this.setSignature(signatureAlgorithm.sign());
        this.setDataPublicKey(keyPair.getPublic());
    }

    public boolean verify(PublicKey public1) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signatureAlgorithm = Signature.getInstance("SHA1withDSA");
        signatureAlgorithm.initVerify(public1);
        signatureAlgorithm.update(this.data, this.offset, this.length);
        byte[] ttl = Utils.intToByteArray(this.ttlSeconds);
        signatureAlgorithm.update(ttl);
        return signatureAlgorithm.verify(this.signature);
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean isProtectedEntry() {
        return this.protectedEntry;
    }

    public void setProtectedEntry(boolean protectedEntry) {
        this.protectedEntry = protectedEntry;
    }

    public void setDirectReplication(boolean directReplication) {
        this.directReplication = directReplication;
    }

    public boolean isDirectReplication() {
        return this.directReplication;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data l:");
        sb.append(this.length);
        sb.append(",dpk:");
        sb.append(this.getDataPublicKey() != null);
        sb.append(",ttl:");
        sb.append(this.getTTLSeconds());
        return sb.toString();
    }

    public PeerAddress getPeerAddress() {
        return this.originator;
    }

    public void setPeerAddress(PeerAddress originator) {
        this.originator = originator;
    }

    private static class EmptyPublicKey
    implements PublicKey {
        private static final long serialVersionUID = -9106407808391259340L;

        private EmptyPublicKey() {
        }

        @Override
        public String getAlgorithm() {
            return "";
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public String getFormat() {
            return "";
        }
    }
}

