/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.DispatcherRequest;
import net.tomp2p.connection.PeerException;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.rpc.RequestHandlerTCP;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DispatcherReply
extends IdleStateAwareChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(DispatcherReply.class);
    private final Map<MessageID, RequestHandlerTCP> waitingForAnswer = new LinkedHashMap<MessageID, RequestHandlerTCP>();
    private final int tcpIdleTimeoutMillis;
    private final DispatcherRequest dispatcherRequest;
    private final ChannelGroup channelGroup;
    final Timer timer;
    private volatile Timeout idleTimeout;
    private Channel channel;

    public DispatcherReply(Timer timer, int tcpIdleTimeoutMillis, DispatcherRequest dispatcherRequest, ChannelGroup channelGroup) {
        this.timer = timer;
        this.tcpIdleTimeoutMillis = tcpIdleTimeoutMillis;
        this.dispatcherRequest = dispatcherRequest;
        this.channelGroup = channelGroup;
        this.idleTimeout = timer.newTimeout((TimerTask)new TimeoutTask(), (long)tcpIdleTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void shutdown(String message) {
        this.timeoutAll(message);
        if (this.idleTimeout != null) {
            this.idleTimeout.cancel();
        }
        this.idleTimeout = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Message message, RequestHandlerTCP requestHandler) {
        Map<MessageID, RequestHandlerTCP> map = this.waitingForAnswer;
        synchronized (map) {
            if (logger.isDebugEnabled()) {
                logger.debug("adding message " + message);
            }
            this.waitingForAnswer.put(new MessageID(message), requestHandler);
        }
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("closing channel (idle) udp=" + (ctx.getChannel() instanceof DatagramChannel) + " channel " + ctx.getChannel());
        }
        if (ctx.getChannel().isOpen()) {
            ctx.getChannel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        RequestHandlerTCP requestHandler;
        if (!(e.getMessage() instanceof Message)) {
            logger.error("Message received, but not of type Message: " + e.getMessage());
            DispatcherReply.close(ctx);
            return;
        }
        Message message = (Message)e.getMessage();
        if (message.isRequest()) {
            this.dispatcherRequest.messageReceived(ctx, e);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("received reply " + message);
        }
        MessageID messageID = new MessageID(message);
        Map<MessageID, RequestHandlerTCP> map = this.waitingForAnswer;
        synchronized (map) {
            requestHandler = this.waitingForAnswer.remove(messageID);
        }
        if (requestHandler == null) {
            logger.warn("Message received, but too late (ignoring): " + e.getMessage());
            return;
        }
        try {
            requestHandler.messageReceived(message);
        }
        catch (PeerException pe) {
            logger.error("Error in RequestHandler TCP: " + pe.getMessage());
            DispatcherReply.close(ctx);
            return;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        String cause;
        String string = cause = e.getCause().getMessage() == null ? null : e.getCause().getMessage().toString();
        if (!"Connection reset by peer".equals(cause)) {
            logger.warn("error in dispatcher reply" + e.toString());
            if (logger.isDebugEnabled()) {
                e.getCause().printStackTrace();
            }
        }
        this.shutdown(e.toString());
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = ctx.getChannel();
        this.channelGroup.add((Object)ctx.getChannel());
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.shutdown(e.toString());
        ctx.sendUpstream((ChannelEvent)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutAll(String reason) {
        Map<MessageID, RequestHandlerTCP> map = this.waitingForAnswer;
        synchronized (map) {
            Iterator<Map.Entry<MessageID, RequestHandlerTCP>> iterator = this.waitingForAnswer.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<MessageID, RequestHandlerTCP> entry = iterator.next();
                iterator.remove();
                entry.getValue().getFutureResponse().setFailed("Timeout all: " + reason + " / " + entry.getKey());
            }
        }
    }

    private static void close(ChannelHandlerContext ctx) {
        if (!(ctx.getChannel() instanceof DatagramChannel)) {
            ctx.getChannel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaiting() {
        Map<MessageID, RequestHandlerTCP> map = this.waitingForAnswer;
        synchronized (map) {
            boolean isWaiting;
            boolean bl = isWaiting = !this.waitingForAnswer.isEmpty();
            if (!isWaiting && logger.isDebugEnabled()) {
                logger.debug("I'm not waiting " + this.channel);
            }
            return isWaiting;
        }
    }

    private final class TimeoutTask
    implements TimerTask {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            Map map = DispatcherReply.this.waitingForAnswer;
            synchronized (map) {
                Iterator iterator = DispatcherReply.this.waitingForAnswer.entrySet().iterator();
                while (iterator.hasNext()) {
                    long requestTimeout;
                    Map.Entry entry = iterator.next();
                    long now = System.currentTimeMillis();
                    if (now > (requestTimeout = ((RequestHandlerTCP)entry.getValue()).getFutureResponse().getReplyTimeout())) {
                        ((RequestHandlerTCP)entry.getValue()).getFutureResponse().setFailed("Timeout by " + (now - requestTimeout) + " for " + ((RequestHandlerTCP)entry.getValue()).getFutureResponse().getRequest());
                        iterator.remove();
                        continue;
                    }
                    long nextDelay = requestTimeout - now;
                    DispatcherReply.this.idleTimeout = DispatcherReply.this.timer.newTimeout((TimerTask)this, nextDelay, TimeUnit.MILLISECONDS);
                    return;
                }
            }
            DispatcherReply.this.idleTimeout = DispatcherReply.this.timer.newTimeout((TimerTask)this, (long)DispatcherReply.this.tcpIdleTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }
}

