/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.DefaultIdleStateEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleStateHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler,
ExternalResourceReleasable {
    private static final Logger logger = LoggerFactory.getLogger(IdleStateHandler.class);
    final Timer timer;
    final long readerIdleTimeMillis;
    volatile long lastReadTime;
    final long writerIdleTimeMillis;
    volatile long lastWriteTime;
    final long allIdleTimeMillis;
    volatile Timeout allIdleTimeout;

    public IdleStateHandler(Timer timer, int allIdleTimeSeconds) {
        this(timer, allIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandler(Timer timer, long allIdleTime, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.readerIdleTimeMillis = 0L;
        this.writerIdleTimeMillis = 0L;
        this.allIdleTimeMillis = allIdleTime <= 0L ? 0L : Math.max(unit.toMillis(allIdleTime), 1L);
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        if (ctx.getPipeline().isAttached()) {
            this.initialize(ctx);
        }
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.initialize(ctx);
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.destroy();
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        logger.debug("set read " + ctx.getChannel());
        this.lastReadTime = System.currentTimeMillis();
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        if (e.getWrittenAmount() > 0L) {
            logger.debug("set write " + ctx.getChannel());
            this.lastWriteTime = System.currentTimeMillis();
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    private void initialize(ChannelHandlerContext ctx) {
        this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        if (this.allIdleTimeMillis > 0L) {
            this.allIdleTimeout = this.timer.newTimeout((TimerTask)new AllIdleTimeoutTask(ctx), this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void destroy() {
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel();
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleState state, long lastActivityTimeMillis) throws Exception {
        ctx.sendUpstream((ChannelEvent)new DefaultIdleStateEvent(ctx.getChannel(), state, lastActivityTimeMillis));
    }

    public void reset() {
        this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
    }

    private final class AllIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastIoTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.allIdleTimeMillis - (currentTime - (lastIoTime = Math.max(IdleStateHandler.this.lastReadTime, IdleStateHandler.this.lastWriteTime)));
            if (nextDelay <= 0L) {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.timer.newTimeout((TimerTask)this, IdleStateHandler.this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
                try {
                    logger.debug("timeout here " + this.ctx.getChannel());
                    IdleStateHandler.this.channelIdle(this.ctx, IdleState.ALL_IDLE, lastIoTime);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Channels.fireExceptionCaught((ChannelHandlerContext)this.ctx, (Throwable)t);
                }
            } else {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.timer.newTimeout((TimerTask)this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }
}

