/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.tomp2p.connection.ConnectionCollector;
import net.tomp2p.connection.DispatcherReply;
import net.tomp2p.connection.DispatcherRequest;
import net.tomp2p.connection.IdleStateHandler;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPChannelCache {
    public static final String DEFAULT_CHANNEL_NAME = "any";
    private static final Logger logger = LoggerFactory.getLogger(TCPChannelCache.class);
    private final ConcurrentMap<Identifier, ChannelFuture> cache = new ConcurrentHashMap<Identifier, ChannelFuture>();
    private final ConnectionCollector connectionCollector;
    private final Timer timer;
    private final ChannelGroup channelGroup;
    private DispatcherRequest dispatcherRequest;

    public TCPChannelCache(ConnectionCollector connectionCollector, Timer timer, ChannelGroup channelGroup) {
        this.connectionCollector = connectionCollector;
        this.timer = timer;
        this.channelGroup = channelGroup;
    }

    public void addChannel(Number160 recipientID, Number160 senderID, InetAddress inetAddress, Channel channel) {
        Identifier identifier = new Identifier(recipientID, senderID, inetAddress, DEFAULT_CHANNEL_NAME);
        DefaultChannelFuture future = new DefaultChannelFuture(channel, false);
        future.setSuccess();
        if (this.cache.putIfAbsent(identifier, (ChannelFuture)future) != null && logger.isDebugEnabled()) {
            logger.debug("add to TCP cache (add) " + identifier + "/" + channel);
        }
    }

    public ChannelFuture getChannel(ChannelHandler timeoutHandler, FutureResponse futureResponse, int connectTimeoutMillis, int tcpIdleTimeoutMillis, Message message, RequestHandlerTCP requestHandler) throws InterruptedException {
        return this.getChannel(DEFAULT_CHANNEL_NAME, timeoutHandler, futureResponse, connectTimeoutMillis, tcpIdleTimeoutMillis, message, requestHandler);
    }

    public ChannelFuture getChannel(String channelName, ChannelHandler timeoutHandler, FutureResponse futureResponse, int connectTimeoutMillis, int tcpIdleTimeoutMillis, Message message, RequestHandlerTCP requestHandler) throws InterruptedException {
        InetSocketAddress recipientAddress;
        Number160 senderID;
        PeerAddress remoteNode = message.getRecipient();
        Number160 recipientID = remoteNode.getID();
        Identifier identifier = new Identifier(recipientID, senderID = message.getSender().getID(), (recipientAddress = remoteNode.createSocketTCP()).getAddress(), channelName);
        ChannelFuture future = (ChannelFuture)this.cache.get(identifier);
        if (future != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("reuse connection " + future.getChannel());
            }
            IdleStateHandler timeoutHandlerOld = (IdleStateHandler)future.getChannel().getPipeline().get("timeout");
            timeoutHandlerOld.reset();
            DispatcherReply dispatcherReply = (DispatcherReply)future.getChannel().getPipeline().get("reply");
            dispatcherReply.add(message, requestHandler);
            if (!future.getChannel().isOpen()) {
                dispatcherReply = new DispatcherReply(this.timer, tcpIdleTimeoutMillis, this.getDispatcherRequest(), this.channelGroup);
                dispatcherReply.add(message, requestHandler);
                return this.createNewChannel(recipientID, recipientAddress, timeoutHandler, connectTimeoutMillis, tcpIdleTimeoutMillis, identifier, dispatcherReply);
            }
            return future;
        }
        DispatcherReply dispatcherReply = new DispatcherReply(this.timer, tcpIdleTimeoutMillis, this.getDispatcherRequest(), this.channelGroup);
        dispatcherReply.add(message, requestHandler);
        return this.createNewChannel(recipientID, recipientAddress, timeoutHandler, connectTimeoutMillis, tcpIdleTimeoutMillis, identifier, dispatcherReply);
    }

    private ChannelFuture createNewChannel(Number160 recipientID, InetSocketAddress recipientAddress, ChannelHandler timeoutHandler, int connectTimeoutMillis, int tcpIdleTimeoutMillis, final Identifier identifier, DispatcherReply dispatcherReply) throws InterruptedException {
        ChannelFuture future;
        if (logger.isDebugEnabled()) {
            logger.debug("no cached channel found, create one to " + recipientID + ", " + recipientAddress);
        }
        if ((future = this.connectionCollector.channelTCP(timeoutHandler, (ChannelHandler)dispatcherReply, recipientAddress, connectTimeoutMillis, this)) == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("created channel " + future.getChannel());
        }
        future.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelFuture future2;
                if (logger.isDebugEnabled()) {
                    logger.debug("connection was closed, so remove " + future.getChannel());
                }
                if ((future2 = (ChannelFuture)TCPChannelCache.this.cache.get(identifier)) != null && !future2.getChannel().isOpen()) {
                    TCPChannelCache.this.cache.remove(identifier);
                }
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("add to TCP cache (get) " + identifier);
        }
        this.cache.put(identifier, future);
        return future;
    }

    public boolean expireCache() {
        for (ChannelFuture future : this.cache.values()) {
            Channel channel = future.getChannel();
            DispatcherReply dispatcherReply = (DispatcherReply)channel.getPipeline().get("reply");
            if (dispatcherReply.isWaiting() || !channel.isOpen()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("expire channel " + channel);
            }
            channel.close();
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("could not expire any channel");
        }
        return false;
    }

    public void setDispatcherRequest(DispatcherRequest dispatcherRequest) {
        this.dispatcherRequest = dispatcherRequest;
    }

    public DispatcherRequest getDispatcherRequest() {
        return this.dispatcherRequest;
    }

    private static class Identifier {
        private final Number160 recipientId;
        private final Number160 senderId;
        private final Number160 both;
        private final InetAddress inetAddress;
        private final String channelName;

        public Identifier(Number160 recipientId, Number160 senderId, InetAddress inetAddress, String channelName) {
            this.recipientId = recipientId;
            this.senderId = senderId;
            this.both = senderId.xor(recipientId);
            this.inetAddress = inetAddress;
            this.channelName = channelName;
        }

        public int hashCode() {
            return this.both.hashCode() ^ this.inetAddress.hashCode() ^ this.channelName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Identifier)) {
                return false;
            }
            Identifier i = (Identifier)obj;
            return i.both.equals(this.both) && i.inetAddress.equals(this.inetAddress) && i.channelName.equals(this.channelName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("recipientID:");
            sb.append(this.recipientId).append(",senderID:").append(this.senderId).append(",inet:").append(this.inetAddress).append(",name:").append(this.channelName);
            return sb.toString();
        }
    }
}

