/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import org.jboss.netty.buffer.ChannelBuffer;

public class Message {
    private static final transient Random random = new Random();
    private int messageId;
    private int version;
    private Type type;
    private Command command;
    private PeerAddress sender;
    private PeerAddress realSender;
    private PeerAddress recipient;
    private int contentLength = 0;
    private Collection<PeerAddress> neighbors = null;
    private int useAtMostNeighbors = -1;
    private Map<Number160, Data> dataMap = null;
    private Map<Number480, Data> dataMapConvert = null;
    private Number160 key1 = null;
    private Number160 key2 = null;
    private Number160 key3 = null;
    private Map<Number160, Number160> keyMap = null;
    private Collection<Number160> keys = null;
    private Collection<Number480> keysConvert = null;
    private ChannelBuffer payload = null;
    private long long_number = 0L;
    private int int_number = 0;
    private Content contentType1 = Content.EMPTY;
    private Content contentType2 = Content.EMPTY;
    private Content contentType3 = Content.EMPTY;
    private Content contentType4 = Content.EMPTY;
    private PublicKey publicKey = null;
    private volatile transient long finished = 0L;
    private volatile transient boolean isUDP = true;
    private volatile transient PrivateKey privateKey;
    private volatile transient boolean hintDataPublickKey = false;
    private volatile transient boolean hintSign = false;
    private volatile transient boolean convertNumber480to160 = false;
    private volatile transient boolean fireAndForget = false;

    public Message() {
        this.setMessageId(random.nextInt());
    }

    public int getMessageId() {
        return this.messageId;
    }

    public Message setMessageId(int messageId) {
        this.messageId = messageId;
        return this;
    }

    public void setUDP() {
        this.isUDP = true;
    }

    public void setTCP() {
        this.isUDP = false;
    }

    public boolean isUDP() {
        return this.isUDP;
    }

    public void finished() {
        this.finished = System.currentTimeMillis();
    }

    public long getFinished() {
        if (this.finished == 0L) {
            throw new RuntimeException("Need to set finished before!");
        }
        return this.finished;
    }

    public int getVersion() {
        return this.version;
    }

    public Message setVersion(int version) {
        this.version = version;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Message setType(Type type) {
        this.type = type;
        return this;
    }

    public Command getCommand() {
        return this.command;
    }

    public Message setCommand(Command command) {
        this.command = command;
        return this;
    }

    public PeerAddress getRealSender() {
        return this.realSender;
    }

    public Message setRealSender(PeerAddress realSender) {
        this.realSender = realSender;
        return this;
    }

    public PeerAddress getSender() {
        return this.sender;
    }

    public Message setSender(PeerAddress sender) {
        this.sender = sender;
        return this;
    }

    public PeerAddress getRecipient() {
        return this.recipient;
    }

    public Message setRecipient(PeerAddress recipient) {
        this.recipient = recipient;
        return this;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Message setContentLength(int contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    void setContentType(Content contentType1, Content contentType2, Content contentType3, Content contentType4) {
        this.contentType1 = contentType1;
        this.contentType2 = contentType2;
        this.contentType3 = contentType3;
        this.contentType4 = contentType4;
    }

    public Content getContentType1() {
        return this.contentType1;
    }

    public Content getContentType2() {
        return this.contentType2;
    }

    public Content getContentType3() {
        return this.contentType3;
    }

    public Content getContentType4() {
        return this.contentType4;
    }

    public Message setContentType(Content contentType) {
        if (this.contentType1 == Content.EMPTY) {
            this.contentType1 = contentType;
        } else if (this.contentType2 == Content.EMPTY) {
            this.contentType2 = contentType;
        } else if (this.contentType3 == Content.EMPTY) {
            this.contentType3 = contentType;
        } else if (this.contentType4 == Content.EMPTY) {
            this.contentType4 = contentType;
        } else {
            throw new IllegalArgumentException("Both content types already set. Cannot set content type!");
        }
        return this;
    }

    public boolean isRequest() {
        return this.type == Type.REQUEST_1 || this.type == Type.REQUEST_2 || this.type == Type.REQUEST_3 || this.type == Type.REQUEST_4;
    }

    public boolean isOk() {
        return this.type == Type.OK || this.type == Type.PARTIALLY_OK;
    }

    public boolean isNotOk() {
        return this.type == Type.NOT_FOUND || this.type == Type.DENIED;
    }

    public boolean isError() {
        return this.type == Type.UNKNOWN_ID || this.type == Type.EXCEPTION || this.type == Type.CANCEL;
    }

    public Message setNeighbors(Collection<PeerAddress> neighbors) {
        return this.setNeighbors(neighbors, neighbors.size());
    }

    public Message setNeighbors(Collection<PeerAddress> neighbors, int useAtMostNeighbors) {
        if (neighbors == null) {
            throw new IllegalArgumentException("neighbors cannot add null");
        }
        if (useAtMostNeighbors < 0) {
            throw new IllegalArgumentException("neigbor size is negative");
        }
        this.neighbors = neighbors;
        this.useAtMostNeighbors = useAtMostNeighbors;
        this.setContentType(Content.SET_NEIGHBORS);
        return this;
    }

    void setNeighbors0(Collection<PeerAddress> neighbors) {
        this.neighbors = neighbors;
        this.useAtMostNeighbors = -1;
    }

    public Collection<PeerAddress> getNeighbors() {
        return this.neighbors;
    }

    int getUseAtMostNeighbors() {
        return this.useAtMostNeighbors;
    }

    public Message setKeysConvert(Collection<Number480> keysConvert) {
        if (keysConvert == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.setConvertNumber480to160(true);
        this.keysConvert = keysConvert;
        this.setContentType(Content.SET_KEYS);
        return this;
    }

    public Message setKeys(Collection<Number160> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.keys = keys;
        this.setContentType(Content.SET_KEYS);
        return this;
    }

    void setKeys0(Collection<Number160> keys) {
        this.keys = keys;
    }

    public Collection<Number160> getKeys() {
        return this.keys;
    }

    public Collection<Number480> getKeysConvert() {
        return this.keysConvert;
    }

    public Message setDataMapConvert(Map<Number480, Data> dataMap) {
        if (dataMap == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.setConvertNumber480to160(true);
        this.dataMapConvert = dataMap;
        this.setContentType(Content.MAP_KEY_DATA);
        return this;
    }

    public Message setDataMap(Map<Number160, Data> dataMap) {
        if (dataMap == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.dataMap = dataMap;
        this.setContentType(Content.MAP_KEY_DATA);
        return this;
    }

    void setDataMap0(Map<Number160, Data> dataMap) {
        this.dataMap = dataMap;
    }

    public Map<Number160, Data> getDataMap() {
        return this.dataMap;
    }

    public Map<Number480, Data> getDataMapConvert() {
        return this.dataMapConvert;
    }

    public Message setKey(Number160 key3) {
        if (key3 == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.key3 = key3;
        this.setContentType(Content.KEY);
        return this;
    }

    void setKey0(Number160 key3) {
        this.key3 = key3;
    }

    public Message setKeyKey(Number160 key1, Number160 key2) {
        if (key1 == null || key2 == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.key1 = key1;
        this.key2 = key2;
        this.setContentType(Content.KEY_KEY);
        return this;
    }

    void setKeyKey0(Number160 key1, Number160 key2) {
        this.key1 = key1;
        this.key2 = key2;
    }

    public Number160 getKey1() {
        return this.key1;
    }

    public Number160 getKey2() {
        return this.key2;
    }

    public Number160 getKey3() {
        return this.key3;
    }

    public Message setKeyMap(Map<Number160, Number160> keyMap) {
        if (keyMap == null) {
            throw new IllegalArgumentException("key cannot add null");
        }
        this.keyMap = keyMap;
        this.setContentType(Content.MAP_KEY_KEY);
        return this;
    }

    void setKeyMap0(Map<Number160, Number160> keyMap) {
        this.keyMap = keyMap;
    }

    public Map<Number160, Number160> getKeyMap() {
        return this.keyMap;
    }

    public Message setLong(long long_number) {
        this.long_number = long_number;
        this.setContentType(Content.LONG);
        return this;
    }

    void setLong0(long long_number) {
        this.long_number = long_number;
    }

    public long getLong() {
        return this.long_number;
    }

    public Message setPayload(ChannelBuffer payload) {
        if (payload == null) {
            throw new RuntimeException("payload cannot add null");
        }
        this.payload = payload;
        this.setContentType(Content.CHANNEL_BUFFER);
        return this;
    }

    void setPayload0(ChannelBuffer payload) {
        this.payload = payload;
    }

    public ChannelBuffer getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message: id=");
        sb.append(this.getMessageId());
        sb.append(",c=").append(this.getCommand().toString()).append(",t=").append(this.type.toString()).append(",l=").append(this.getContentLength() + 64).append(",s=").append(this.getSender()).append(",r=").append(this.getRecipient()).append(",k=").append(this.keys);
        return sb.toString();
    }

    public Message setInteger(int int_number) {
        this.int_number = int_number;
        this.setContentType(Content.INTEGER);
        return this;
    }

    void setInteger0(int int_number) {
        this.int_number = int_number;
    }

    public int getInteger() {
        return this.int_number;
    }

    void setPublicKey0(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Message setPublicKey(PublicKey publicKey) {
        this.setContentType(Content.PUBLIC_KEY_SIGNATURE);
        this.publicKey = publicKey;
        return this;
    }

    public Message setPublicKeyAndSign(KeyPair keyPair) {
        this.setContentType(Content.PUBLIC_KEY_SIGNATURE);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        return this;
    }

    boolean isHintDataPublickKey() {
        return this.hintDataPublickKey;
    }

    void setHintDataPublickKey(boolean hintDataPublickKey) {
        this.hintDataPublickKey = hintDataPublickKey;
    }

    public void setHintSign(boolean hintSign) {
        this.hintSign = hintSign;
    }

    public boolean isHintSign() {
        return this.hintSign;
    }

    public void setConvertNumber480to160(boolean convertNumber480to160) {
        this.convertNumber480to160 = convertNumber480to160;
    }

    public boolean isConvertNumber480to160() {
        return this.convertNumber480to160;
    }

    public void setFireAndForget(boolean fireAndForget) {
        this.fireAndForget = fireAndForget;
    }

    public boolean isFireAndForget() {
        return this.fireAndForget;
    }

    public static enum Command {
        PING,
        PUT,
        GET,
        ADD,
        REMOVE,
        SYNC,
        NEIGHBORS_STORAGE,
        NEIGHBORS_TRACKER,
        QUIT,
        DIRECT_DATA,
        TRACKER_ADD,
        TRACKER_GET,
        USER1,
        USER2,
        USER3,
        USER4;

    }

    public static enum Type {
        REQUEST_1,
        REQUEST_2,
        REQUEST_3,
        REQUEST_4,
        OK,
        PARTIALLY_OK,
        NOT_FOUND,
        DENIED,
        UNKNOWN_ID,
        EXCEPTION,
        CANCEL,
        USER1,
        USER2,
        USER3,
        USER4;

    }

    public static enum Content {
        EMPTY,
        KEY,
        KEY_KEY,
        MAP_KEY_DATA,
        MAP_KEY_KEY,
        SET_KEYS,
        SET_NEIGHBORS,
        CHANNEL_BUFFER,
        LONG,
        INTEGER,
        PUBLIC_KEY_SIGNATURE,
        PUBLIC_KEY,
        RESERVED1,
        RESERVED2,
        RESERVED3,
        RESERVED4;

    }
}

