/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class VotingSchemeTracker
implements EvaluatingSchemeTracker {
    @Override
    public Map<PeerAddress, Data> evaluateSingle(Map<PeerAddress, Map<PeerAddress, Data>> rawData) {
        if (rawData == null) {
            throw new IllegalArgumentException("cannot evaluate, as no result provided");
        }
        HashMap<Number160, Integer> counter = new HashMap<Number160, Integer>();
        HashMap<PeerAddress, Data> result = new HashMap<PeerAddress, Data>();
        for (Map.Entry<PeerAddress, Map<PeerAddress, Data>> entry1 : rawData.entrySet()) {
            for (Map.Entry<PeerAddress, Data> entry2 : entry1.getValue().entrySet()) {
                int majority = (entry1.getValue().size() + 1) / 2;
                Data dat = entry2.getValue();
                int c = 1;
                Integer count = (Integer)counter.get(dat.getHash());
                if (count != null) {
                    c = count + 1;
                }
                counter.put(dat.getHash(), c);
                if (c < majority) continue;
                result.put(entry1.getKey(), dat);
            }
        }
        return result;
    }

    @Override
    public Map<PeerAddress, Set<Data>> evaluate(Map<PeerAddress, Map<PeerAddress, Data>> rawData) {
        if (rawData == null) {
            throw new IllegalArgumentException("cannot evaluate, as no result provided");
        }
        HashMap<PeerAddress, Set<Data>> result = new HashMap<PeerAddress, Set<Data>>();
        for (Map.Entry<PeerAddress, Map<PeerAddress, Data>> tmp : rawData.entrySet()) {
            HashSet<Data> set = (HashSet<Data>)result.get(tmp.getKey());
            if (set == null) {
                set = new HashSet<Data>();
                result.put(tmp.getKey(), set);
            }
            set.addAll(tmp.getValue().values());
        }
        return result;
    }
}

