/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;

public class Number320
implements Comparable<Number320> {
    private final Number160 locationKey;
    private final Number160 domainKey;

    public Number320(Number160 locationKey, Number160 domainKey) {
        this.locationKey = locationKey;
        this.domainKey = domainKey;
    }

    public Number160 getLocationKey() {
        return this.locationKey;
    }

    public Number160 getDomainKey() {
        return this.domainKey;
    }

    public int hashCode() {
        return this.locationKey.hashCode() ^ this.domainKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Number320)) {
            return false;
        }
        Number320 cmp = (Number320)obj;
        return this.locationKey.equals(cmp.locationKey) && this.domainKey.equals(cmp.domainKey);
    }

    @Override
    public int compareTo(Number320 o) {
        int diff = this.locationKey.compareTo(o.locationKey);
        if (diff != 0) {
            return diff;
        }
        return this.domainKey.compareTo(o.domainKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.locationKey.toString()).append(",");
        sb.append(this.domainKey.toString()).append("]");
        return sb.toString();
    }

    public Number480 min() {
        return new Number480(this.locationKey, this.domainKey, Number160.ZERO);
    }

    public Number480 max() {
        return new Number480(this.locationKey, this.domainKey, Number160.MAX_VALUE);
    }
}

