/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.Utils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(NeighborRPC.class);
    public static final int NEIGHBOR_SIZE = 20;

    public NeighborRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.NEIGHBORS_STORAGE, Message.Command.NEIGHBORS_TRACKER);
    }

    public FutureResponse closeNeighbors(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, Message.Command command, boolean isDigest, boolean forceSocket) {
        this.nullCheck(remoteNode, locationKey);
        if (command != Message.Command.NEIGHBORS_TRACKER && command != Message.Command.NEIGHBORS_STORAGE) {
            throw new IllegalArgumentException("command not of type neighbor");
        }
        Message message = this.createMessage(remoteNode, command, isDigest ? Message.Type.REQUEST_1 : Message.Type.REQUEST_2);
        message.setKeyKey(locationKey, domainKey == null ? Number160.ZERO : domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        if (!forceSocket) {
            NeighborsRequestUDP request = new NeighborsRequestUDP(this.peerBean, this.connectionBean, message);
            return request.sendUDP();
        }
        NeighborsRequestTCP request = new NeighborsRequestTCP(this.peerBean, this.connectionBean, message);
        return request.sendTCP();
    }

    @Override
    public boolean checkMessage(Message message) {
        return !(message.getKey1() == null || message.getContentType1() != Message.Content.KEY_KEY || message.getContentType2() != Message.Content.EMPTY && message.getContentType2() != Message.Content.SET_KEYS || message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 || message.getCommand() != Message.Command.NEIGHBORS_STORAGE && message.getCommand() != Message.Command.NEIGHBORS_TRACKER);
    }

    @Override
    public Message handleResponse(Message message) throws IOException {
        boolean isDigest;
        if (logger.isDebugEnabled()) {
            logger.debug("handleResponse for " + message);
        }
        Number160 locationKey = message.getKey1();
        Number160 domainKey = message.getKey2();
        Message responseMessage = this.createMessage(message.getSender(), message.getCommand(), Message.Type.OK);
        responseMessage.setMessageId(message.getMessageId());
        SortedSet<PeerAddress> neighbors = this.peerBean.getPeerMap().closePeers(locationKey, 20);
        responseMessage.setNeighbors(neighbors, 20);
        Collection<Number160> contentKeys = message.getKeys();
        boolean bl = isDigest = message.getType() == Message.Type.REQUEST_1;
        if (isDigest) {
            if (message.getCommand() == Message.Command.NEIGHBORS_STORAGE) {
                DigestInfo digestInfo = Utils.digest(this.peerBean.getStorage(), locationKey, domainKey, contentKeys);
                responseMessage.setInteger(digestInfo.getSize());
                responseMessage.setKey(digestInfo.getKeyDigest());
            } else if (message.getCommand() == Message.Command.NEIGHBORS_TRACKER) {
                DigestInfo digest = this.peerBean.getTrackerStorage().digest(new Number320(locationKey, domainKey));
                int size = digest.getSize();
                if (logger.isDebugEnabled()) {
                    logger.debug("found trackre size " + size);
                }
                responseMessage.setInteger(size);
            } else {
                throw new RuntimeException("Implement new type");
            }
        }
        return responseMessage;
    }

    private void preHandleMessage(Message message, PeerMap peerMap, PeerAddress referrer) {
        if (message.getType() == Message.Type.OK && (message.getCommand() == Message.Command.NEIGHBORS_STORAGE || message.getCommand() == Message.Command.NEIGHBORS_TRACKER)) {
            Collection<PeerAddress> tmp = message.getNeighbors();
            if (tmp != null) {
                Iterator<PeerAddress> iterator = tmp.iterator();
                while (iterator.hasNext()) {
                    PeerAddress addr = iterator.next();
                    if (peerMap.isPeerRemovedTemporarly(addr)) {
                        iterator.remove();
                        continue;
                    }
                    peerMap.peerOnline(addr, referrer);
                }
            } else {
                logger.warn("Neighbor message received, but does not contain any neighbors.");
            }
        } else {
            logger.warn("Message not of type Neighbor, ignoring");
        }
    }

    private class NeighborsRequestUDP
    extends RequestHandlerUDP {
        private final Message message;

        public NeighborsRequestUDP(PeerBean peerBean, ConnectionBean connectionBean, Message message) {
            super(peerBean, connectionBean, message);
            this.message = message;
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Object object = e.getMessage();
            if (object instanceof Message) {
                NeighborRPC.this.preHandleMessage((Message)object, this.getPeerMap(), this.message.getRecipient());
            } else {
                logger.error("Response received, but not a message: " + object);
            }
            super.messageReceived(ctx, e);
        }
    }

    private class NeighborsRequestTCP
    extends RequestHandlerTCP {
        private final Message message;

        public NeighborsRequestTCP(PeerBean peerBean, ConnectionBean connectionBean, Message message) {
            super(peerBean, connectionBean, message);
            this.message = message;
        }

        @Override
        public void messageReceived(Message message) throws PeerException {
            NeighborRPC.this.preHandleMessage(message, this.getPeerMap(), this.message.getRecipient());
            super.messageReceived(message);
        }
    }
}

