/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Storage;

public class Utils {
    private static final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer loadFile(File file) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        for (int i = 0; i < 50 && !file.exists(); ++i) {
            Utils.sleep(100L);
        }
        FileInputStream fis = null;
        FileChannel channel = null;
        try {
            fis = new FileInputStream(file);
            channel = fis.getChannel();
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        catch (Throwable throwable) {
            Utils.bestEffortclose(channel, fis);
            throw throwable;
        }
        Utils.bestEffortclose(channel, fis);
        return mappedByteBuffer;
    }

    /*
     * Exception decompiling
     */
    public static Number160 makeSHAHash(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Number160 makeSHAHash(String strInput) {
        byte[] buffer = strInput.getBytes();
        return Utils.makeSHAHash(buffer);
    }

    public static Number160 makeSHAHash(ByteBuffer buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(buffer);
            byte[] digest = md.digest();
            return new Number160(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new Number160();
        }
    }

    public static Number160 makeSHAHash(byte[] buffer) {
        return Utils.makeSHAHash(ByteBuffer.wrap(buffer));
    }

    public static Number160 makeSHAHash(byte[] buffer, int offset, int length) {
        return Utils.makeSHAHash(ByteBuffer.wrap(buffer, offset, length));
    }

    public static Number160 createRandomNodeID() {
        byte[] me = new byte[20];
        random.nextBytes(me);
        Number160 id = new Number160(me);
        return id;
    }

    public static void sleep(long connectionTimeout) {
        try {
            Thread.sleep(connectionTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static byte[] compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] compressedData, int offset, int length) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData, offset, length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] compressedData) {
        return Utils.uncompress(compressedData, 0, compressedData.length);
    }

    public static byte[] encodeJavaObject(Object attachement) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(attachement);
        byte[] data = bos.toByteArray();
        return data;
    }

    public static Object decodeJavaObject(byte[] me, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(me, offset, length);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = ois.readObject();
        return obj;
    }

    public static void difference(Collection<PeerAddress> newNeighbors, Collection<PeerAddress> alreadyAsked, Collection<PeerAddress> result) {
        for (PeerAddress newPeerAddress : newNeighbors) {
            if (alreadyAsked.contains(newPeerAddress)) continue;
            result.add(newPeerAddress);
        }
    }

    public static void bestEffortclose(Closeable ... closables) {
        for (Closeable closable : closables) {
            if (closable == null) continue;
            try {
                closable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static PeerAddress pollFirst(SortedSet<PeerAddress> queue) {
        try {
            if (queue.size() > 0) {
                PeerAddress tmp = queue.first();
                queue.remove(tmp);
                return tmp;
            }
            return null;
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static DigestInfo digest(Storage storage, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys) {
        DigestInfo digestInfo;
        if (contentKeys != null) {
            HashSet<Number480> tmp = new HashSet<Number480>();
            for (Number160 contentKey : contentKeys) {
                tmp.add(new Number480(locationKey, domainKey, contentKey));
            }
            digestInfo = storage.digest(tmp);
        } else {
            digestInfo = storage.digest(new Number480(locationKey, domainKey, Number160.ZERO), new Number480(locationKey, domainKey, Number160.MAX_VALUE));
        }
        return digestInfo;
    }
}

