/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Bindings {
    private static final Random RND = new Random();
    private static final int RANGE = 16383;
    private final List<InetAddress> listenAddresses = new ArrayList<InetAddress>(1);
    private final List<InetAddress> broadcastAddresses = new ArrayList<InetAddress>(1);
    private final List<Inet4Address> listenAddresses4 = new ArrayList<Inet4Address>(1);
    private final List<Inet6Address> listenAddresses6 = new ArrayList<Inet6Address>(1);
    private final List<String> listenInterfaceHints = new ArrayList<String>(1);
    private final Protocol listenProtocolHint;
    private final InetAddress externalAddress;
    private final int externalTCPPort;
    private final int externalUDPPort;

    public Bindings() {
        this(Protocol.Any, null, 0, 0);
    }

    public Bindings(InetAddress bind) {
        this(Protocol.Any, null, 0, 0);
        this.addAddress(bind);
    }

    public Bindings(String iface) {
        this(Protocol.Any, null, 0, 0);
        this.addInterface(iface);
    }

    public Bindings(Protocol protocol) {
        this(protocol, null, 0, 0);
    }

    public Bindings(Protocol protocol, String iface) {
        this(protocol, null, 0, 0);
        this.addInterface(iface);
    }

    public Bindings(Protocol protocol, String iface, InetAddress bind) {
        this(protocol, null, 0, 0);
    }

    public Bindings(InetAddress externalAddress, int externalTCPPort, int externalUDPPort) {
        this(Protocol.Any, externalAddress, externalTCPPort, externalUDPPort);
    }

    public Bindings(Protocol protocol, InetAddress externalAddress, int externalTCPPort, int externalUDPPort) {
        if (externalTCPPort < 0 || externalUDPPort < 0) {
            throw new IllegalArgumentException("port needs to be >= 0");
        }
        this.externalAddress = externalAddress;
        this.externalTCPPort = externalTCPPort == 0 ? RND.nextInt(16383) + 49152 : externalTCPPort;
        this.externalUDPPort = externalUDPPort == 0 ? RND.nextInt(16383) + 49152 : externalUDPPort;
        this.listenProtocolHint = protocol;
    }

    Bindings addFoundAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        if (address instanceof Inet4Address) {
            this.listenAddresses4.add((Inet4Address)address);
        } else if (address instanceof Inet6Address) {
            this.listenAddresses6.add((Inet6Address)address);
        } else {
            throw new IllegalArgumentException("Unknown address family " + address.getClass());
        }
        return this;
    }

    public List<InetAddress> getFoundAddresses() {
        ArrayList<InetAddress> listenAddresses = new ArrayList<InetAddress>();
        listenAddresses.addAll(this.listenAddresses4);
        listenAddresses.addAll(this.listenAddresses6);
        return listenAddresses;
    }

    public Bindings addAddress(InetAddress address) {
        this.listenAddresses.add(address);
        return this;
    }

    public List<InetAddress> getAddresses() {
        return this.listenAddresses;
    }

    public Bindings addBroadcastAddress(InetAddress broadcastAddress) {
        if (broadcastAddress == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.broadcastAddresses.add(broadcastAddress);
        return this;
    }

    public List<InetAddress> getBroadcastAddresses() {
        return this.broadcastAddresses;
    }

    public void addInterface(String interfaceHint) {
        if (interfaceHint == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.listenInterfaceHints.add(interfaceHint);
    }

    public List<String> getInterfaces() {
        return this.listenInterfaceHints;
    }

    public Protocol getProtocol() {
        return this.listenProtocolHint;
    }

    public void clear() {
        this.listenInterfaceHints.clear();
        this.listenAddresses.clear();
        this.listenAddresses4.clear();
        this.listenAddresses6.clear();
        this.broadcastAddresses.clear();
    }

    public boolean isAllAddresses() {
        return this.listenAddresses.size() == 0;
    }

    public boolean isAllInterfaces() {
        return this.listenInterfaceHints.size() == 0;
    }

    public boolean isAllProtocols() {
        return this.listenProtocolHint == Protocol.Any;
    }

    public boolean isIPv4() {
        return this.isAllProtocols() || this.listenProtocolHint == Protocol.IPv4;
    }

    public boolean isIPv6() {
        return this.isAllProtocols() || this.listenProtocolHint == Protocol.IPv6;
    }

    public boolean isListenAll() {
        return this.isAllProtocols() && this.isAllInterfaces() && this.isAllAddresses();
    }

    public boolean containsInterface(String name) {
        return this.listenInterfaceHints.contains(name);
    }

    public boolean isExternalAddress() {
        return this.externalAddress != null && this.externalTCPPort != 0 && this.externalUDPPort != 0;
    }

    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    public int getOutsideTCPPort() {
        return this.externalTCPPort;
    }

    public int getOutsideUDPPort() {
        return this.externalUDPPort;
    }

    public Bindings add(Bindings other) {
        this.listenAddresses4.addAll(other.listenAddresses4);
        this.listenAddresses6.addAll(other.listenAddresses6);
        this.broadcastAddresses.addAll(other.broadcastAddresses);
        return this;
    }

    public static enum Protocol {
        IPv4,
        IPv6,
        Any;

    }
}

