/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import net.tomp2p.connection.Reservation;
import net.tomp2p.connection.Scheduler;
import net.tomp2p.futures.FutureRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReservation
implements Reservation {
    private static final Logger logger = LoggerFactory.getLogger(DefaultReservation.class);
    private final Map<Long, Boolean> threads = new ConcurrentHashMap<Long, Boolean>();
    private volatile boolean shutdown = false;

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(Semaphore semaphore, int permits) {
        boolean acquired = false;
        while (!acquired && !this.shutdown) {
            try {
                acquired = semaphore.tryAcquire(permits);
                if (!acquired) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("cannot acquire " + permits + ", now we have " + semaphore.availablePermits());
                    }
                    Semaphore semaphore2 = semaphore;
                    synchronized (semaphore2) {
                        semaphore.wait(250L);
                        continue;
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("acquired " + permits + ", now we have " + semaphore.availablePermits());
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return acquired;
    }

    @Override
    public void runDeadLockProof(Scheduler scheduler, FutureRunnable futureRunnable) {
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ") || this.threads.containsKey(Thread.currentThread().getId())) {
            scheduler.addQueue(futureRunnable);
        } else {
            futureRunnable.run();
        }
    }

    @Override
    public void prepareDeadLockCheck() {
        this.threads.put(Thread.currentThread().getId(), Boolean.TRUE);
    }

    @Override
    public void removeDeadLockCheck(long creatorThread) {
        this.threads.remove(creatorThread);
    }
}

