/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.NetworkInterface;
import java.util.Enumeration;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.DiscoverNetwork;

public class DiscoverNetworks {
    public static String discoverInterfaces(Bindings bindings) throws Exception {
        StringBuilder sb = new StringBuilder("Discover status: ");
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface networkInterface = e.nextElement();
            if (bindings.isAllInterfaces()) {
                sb.append(" ++").append(networkInterface.getName());
                sb.append(DiscoverNetworks.discoverNetwork(networkInterface, bindings)).append(",");
                continue;
            }
            if (bindings.containsInterface(networkInterface.getName())) {
                sb.append(" +").append(networkInterface.getName());
                sb.append(DiscoverNetworks.discoverNetwork(networkInterface, bindings)).append(",");
                continue;
            }
            sb.append(" -").append(networkInterface.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append(".").toString();
    }

    private static String discoverNetwork(NetworkInterface networkInterface, Bindings bindings) throws Exception {
        Class<?> dn = System.getProperty("java.vm.name").equals("Dalvik") || System.getProperty("java.version").startsWith("1.5") ? Class.forName("net.tomp2p.connection.DiscoverNetwork5") : Class.forName("net.tomp2p.connection.DiscoverNetwork6");
        DiscoverNetwork discoverNetwork = (DiscoverNetwork)dn.newInstance();
        return discoverNetwork.discoverNetwork(networkInterface, bindings);
    }
}

