/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.peers.PeerAddress;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class PeerConnection {
    private final PeerAddress destination;
    private final ChannelCreator channelCreator;
    private final ConnectionReservation connectionReservation;
    private final int idleTCPMillis;
    private final Semaphore oneConnection = new Semaphore(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public PeerConnection(PeerAddress destination, ConnectionReservation connectionReservation, ChannelCreator channelCreator, int idleTCPMillis) {
        this.destination = destination;
        this.channelCreator = channelCreator;
        this.connectionReservation = connectionReservation;
        this.idleTCPMillis = idleTCPMillis;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ChannelFuture cf = this.channelCreator.close(this.getDestination());
            if (cf != null) {
                cf.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        PeerConnection.this.connectionReservation.release(PeerConnection.this.channelCreator);
                    }
                });
            } else {
                this.connectionReservation.release(this.channelCreator);
            }
        }
    }

    public PeerAddress getDestination() {
        return this.destination;
    }

    public ChannelCreator getChannelCreator() {
        if (this.closed.get()) {
            throw new RuntimeException("cannot used a closed channel");
        }
        return this.channelCreator;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int getIdleTCPMillis() {
        return this.idleTCPMillis;
    }

    public void aquireSingleConnection() throws InterruptedException {
        this.oneConnection.acquire();
    }

    public void releaseSingleConnection() {
        this.oneConnection.release();
    }
}

