/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import net.tomp2p.peers.Number160;

public final class PeerAddress
implements Comparable<PeerAddress>,
Serializable {
    private static final int NET6 = 1;
    private static final int FIREWALL_UDP = 2;
    private static final int FIREWALL_TCP = 4;
    private static final long serialVersionUID = -1316622724169272306L;
    private final Number160 id;
    private final InetAddress address;
    private final int portUDP;
    private final int portTCP;
    private final boolean net6;
    private final boolean firewalledUDP;
    private final boolean firewalledTCP;
    private final int hashCode;
    private final int offset;
    private final int readBytes;
    public static final int SIZE_IP_SOCKv6 = 21;
    public static final int SIZE_IP_SOCKv4 = 9;
    public static final int SIZE_IPv6 = 41;
    public static final int SIZE_IPv4 = 29;
    public static final PeerAddress EMPTY_IPv4 = new PeerAddress(new byte[29]);

    public PeerAddress(byte[] me) {
        this(me, 0);
    }

    public PeerAddress(byte[] me, int offset) {
        int offsetOld = offset;
        byte[] tmp = new byte[20];
        System.arraycopy(me, offset, tmp, 0, 20);
        this.id = new Number160(tmp);
        int options = me[offset += 20] & 0xFF;
        this.net6 = (options & 1) > 0;
        this.firewalledUDP = (options & 2) > 0;
        this.firewalledTCP = (options & 4) > 0;
        this.portTCP = ((me[++offset] & 0xFF) << 8) + (me[offset + 1] & 0xFF);
        this.portUDP = ((me[offset + 2] & 0xFF) << 8) + (me[offset + 3] & 0xFF);
        offset += 4;
        if (this.isIPv4()) {
            byte[] tmp2 = new byte[4];
            System.arraycopy(me, offset, tmp2, 0, 4);
            InetAddresses.fromInteger((int)22);
            try {
                this.address = Inet4Address.getByAddress(tmp2);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(tmp2)), e);
            }
            offset += 4;
        } else {
            byte[] tmp2 = new byte[16];
            System.arraycopy(me, offset, tmp2, 0, 16);
            try {
                this.address = Inet6Address.getByAddress(tmp2);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(tmp2)), e);
            }
            offset += 16;
        }
        this.readBytes = offset - offsetOld;
        this.offset = offset;
        this.hashCode = this.id.hashCode();
    }

    public PeerAddress(Number160 id, byte[] me, int offset) {
        int offsetOld = offset;
        this.id = id;
        int options = me[offset] & 0xFF;
        this.net6 = (options & 1) > 0;
        this.firewalledUDP = (options & 2) > 0;
        this.firewalledTCP = (options & 4) > 0;
        this.portTCP = ((me[++offset] & 0xFF) << 8) + (me[offset + 1] & 0xFF);
        this.portUDP = ((me[offset + 2] & 0xFF) << 8) + (me[offset + 3] & 0xFF);
        offset += 4;
        if (this.isIPv4()) {
            byte[] tmp2 = new byte[4];
            System.arraycopy(me, offset, tmp2, 0, 4);
            try {
                this.address = Inet4Address.getByAddress(tmp2);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(tmp2)), e);
            }
            offset += 4;
        } else {
            byte[] tmp2 = new byte[16];
            System.arraycopy(me, offset, tmp2, 0, 16);
            try {
                this.address = Inet6Address.getByAddress(tmp2);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(tmp2)), e);
            }
            offset += 16;
        }
        this.readBytes = offset - offsetOld;
        this.offset = offset;
        this.hashCode = id.hashCode();
    }

    public PeerAddress(byte[] peerAddress, byte[] socketAddress) {
        this(new Number160(peerAddress), socketAddress, 0);
    }

    public PeerAddress(Number160 id) {
        this(id, (InetAddress)null, -1, -1);
    }

    public PeerAddress(Number160 id, InetAddress address) {
        this(id, address, -1, -1);
    }

    public PeerAddress(Number160 id, InetAddress address, int portTCP, int portUDP, boolean firewalledUDP, boolean firewalledTCP) {
        this.id = id;
        this.address = address;
        this.portTCP = portTCP;
        this.portUDP = portUDP;
        this.hashCode = id.hashCode();
        this.net6 = address instanceof Inet6Address;
        this.firewalledUDP = firewalledUDP;
        this.firewalledTCP = firewalledTCP;
        this.offset = -1;
        this.readBytes = -1;
    }

    public PeerAddress(Number160 id, InetAddress address, int portTCP, int portUDP) {
        this(id, address, portTCP, portUDP, false, false);
    }

    public PeerAddress(Number160 id, String address, int portTCP, int portUDP) throws UnknownHostException {
        this(id, InetAddress.getByName(address), portTCP, portUDP, false, false);
    }

    public PeerAddress(Number160 id, InetSocketAddress inetSocketAddress) {
        this(id, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), inetSocketAddress.getPort());
    }

    public PeerAddress(Number160 id, PeerAddress parent) {
        this(id, parent.address, parent.portTCP, parent.portUDP);
    }

    public PeerAddress(Number160 id, InetAddress address, int portTCP, int portUDP, int options) {
        this(id, address, portTCP, portUDP, PeerAddress.isFirewalledUDP(options), PeerAddress.isFirewalledTCP(options));
    }

    public int offset() {
        return this.offset;
    }

    public int readBytes() {
        return this.readBytes;
    }

    public byte[] toByteArray() {
        byte[] me = this.address instanceof Inet4Address ? new byte[29] : new byte[41];
        this.toByteArray(me, 0);
        return me;
    }

    public int toByteArray(byte[] me, int offset) {
        int newOffset = this.id.toByteArray(me, offset);
        return this.toByteArraySocketAddress(me, newOffset);
    }

    @Deprecated
    public byte[] getSocketAddress() {
        return this.toByteArraySocketAddress();
    }

    public byte[] toByteArraySocketAddress() {
        byte[] me = new byte[this.getSocketAddressSize()];
        this.toByteArraySocketAddress(me, 0);
        return me;
    }

    @Deprecated
    public int getSocketAddress(byte[] me, int offset) {
        return this.toByteArraySocketAddress(me, offset);
    }

    public int toByteArraySocketAddress(byte[] me, int offset) {
        me[offset] = this.getOptions();
        int delta = 1;
        int tmp = offset + delta;
        me[tmp + 0] = (byte)(this.portTCP >>> 8);
        me[tmp + 1] = (byte)this.portTCP;
        me[tmp + 2] = (byte)(this.portUDP >>> 8);
        me[tmp + 3] = (byte)this.portUDP;
        delta += 4;
        if (this.address instanceof Inet4Address) {
            System.arraycopy(this.address.getAddress(), 0, me, offset + delta, 4);
            delta += 4;
        } else {
            System.arraycopy(this.address.getAddress(), 0, me, offset + delta, 16);
            delta += 16;
        }
        return offset + delta;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public InetSocketAddress createSocketTCP() {
        return new InetSocketAddress(this.address, this.portTCP);
    }

    public InetSocketAddress createSocketUDP() {
        return new InetSocketAddress(this.address, this.portUDP);
    }

    public Number160 getID() {
        return this.id;
    }

    public byte getOptions() {
        byte result = 0;
        if (this.net6) {
            result = (byte)(result | 1);
        }
        if (this.firewalledUDP) {
            result = (byte)(result | 2);
        }
        if (this.firewalledTCP) {
            result = (byte)(result | 4);
        }
        return result;
    }

    public static boolean isNet6(int options) {
        return (options & 0xFF & 1) > 0;
    }

    public static boolean isFirewalledTCP(int options) {
        return (options & 0xFF & 4) > 0;
    }

    public static boolean isFirewalledUDP(int options) {
        return (options & 0xFF & 2) > 0;
    }

    public static int expectedLength(int options) {
        if (PeerAddress.isNet6(options)) {
            return 41;
        }
        return 29;
    }

    public static int expectedSocketLength(int options) {
        if (PeerAddress.isNet6(options)) {
            return 21;
        }
        return 9;
    }

    public int expectedLength() {
        return this.isIPv6() ? 41 : 29;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PeerAddr[");
        return sb.append(this.address).append(",udp:").append(this.portUDP).append(",tcp:").append(this.portTCP).append(",ID:").append(this.id.toString()).append("]").toString();
    }

    @Override
    public int compareTo(PeerAddress nodeAddress) {
        return this.id.compareTo(nodeAddress.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PeerAddress) {
            return this.id.equals(((PeerAddress)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int portTCP() {
        return this.portTCP;
    }

    public int portUDP() {
        return this.portUDP;
    }

    public boolean isFirewalledUDP() {
        return this.firewalledUDP;
    }

    public boolean isFirewalledTCP() {
        return this.firewalledTCP;
    }

    public boolean isIPv6() {
        return this.net6;
    }

    public boolean isIPv4() {
        return !this.net6;
    }

    public PeerAddress changeFirewalledUDP(boolean status) {
        return new PeerAddress(this.id, this.address, this.portTCP, this.portUDP, status, this.firewalledTCP);
    }

    public PeerAddress changeFirewalledTCP(boolean status) {
        return new PeerAddress(this.id, this.address, this.portTCP, this.portUDP, this.firewalledUDP, status);
    }

    public PeerAddress changePorts(int portUDP, int portTCP) {
        return new PeerAddress(this.id, this.address, portTCP, portUDP, this.firewalledUDP, this.firewalledTCP);
    }

    public PeerAddress changeAddress(InetAddress address) {
        return new PeerAddress(this.id, address, this.portTCP, this.portUDP, this.firewalledUDP, this.firewalledTCP);
    }

    public PeerAddress changePeerId(Number160 id2) {
        return new PeerAddress(id2, this.address, this.portTCP, this.portUDP, this.firewalledUDP, this.firewalledTCP);
    }

    public int getSocketAddressSize() {
        return this.address instanceof Inet4Address ? 9 : 21;
    }
}

