/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.tomp2p.upnp.Argument;
import net.tomp2p.upnp.Service;
import net.tomp2p.upnp.XMLUtil;
import org.w3c.dom.Node;

public class Action {
    public final String name;
    public final Service parent;
    public final Argument[] arguments;
    private Argument[] input;
    private Argument[] output;

    Action(Service parent, Node xml) throws XPathExpressionException {
        this.parent = parent;
        XPath xpath = XMLUtil.xpath;
        this.name = xpath.evaluate("name", xml);
        Node argList = (Node)xpath.evaluate("argumentList", xml, XPathConstants.NODE);
        int argCount = argList == null ? 0 : Integer.parseInt(xpath.evaluate("count( argument )", argList));
        this.arguments = new Argument[argCount];
        for (int i = 1; i <= argCount; ++i) {
            Node argXML = (Node)xpath.evaluate("argument[ " + i + " ]", argList, XPathConstants.NODE);
            this.arguments[i - 1] = new Argument(argXML);
        }
    }

    public Argument getActionArgument(String argumentName) {
        for (Argument arg : this.arguments) {
            if (!arg.name.equals(argumentName)) continue;
            return arg;
        }
        return null;
    }

    public Argument[] getInputActionArguments() {
        if (this.input == null) {
            ArrayList<Argument> l = new ArrayList<Argument>();
            for (Argument a : this.arguments) {
                if (a.direction != Argument.Direction.in) continue;
                l.add(a);
            }
            this.input = l.toArray(new Argument[l.size()]);
        }
        return this.input;
    }

    public Argument getInputActionArgument(String argumentName) {
        Argument[] saa = this.getInputActionArguments();
        for (int i = 0; i < saa.length; ++i) {
            if (!saa[i].name.equals(argumentName)) continue;
            return saa[i];
        }
        return null;
    }

    public Argument[] getOutputActionArguments() {
        if (this.output == null) {
            ArrayList<Argument> l = new ArrayList<Argument>();
            for (Argument a : this.arguments) {
                if (a.direction != Argument.Direction.out) continue;
                l.add(a);
            }
            this.output = l.toArray(new Argument[l.size()]);
        }
        return this.output;
    }

    public Argument getOutputActionArgument(String argumentName) {
        Argument[] saa = this.getOutputActionArguments();
        for (int i = 0; i < saa.length; ++i) {
            if (!saa[i].name.equals(argumentName)) continue;
            return saa[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + Arrays.toString(this.arguments);
    }
}

