/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.VLSN;
import java.util.Timer;
import java.util.TimerTask;

class LogFlusher {
    private final RepNode repNode;
    private final Timer timer;
    private int flushInterval;
    private LogFlushTask flushTask;

    public LogFlusher(RepNode repNode, Timer timer) {
        this.repNode = repNode;
        this.timer = timer;
    }

    public void configFlushTask(int interval) {
        if (this.flushInterval == interval && this.flushTask != null) {
            return;
        }
        this.flushInterval = interval;
        this.cancelTask();
        this.flushTask = new LogFlushTask(this.repNode);
        this.timer.schedule((TimerTask)this.flushTask, 0L, (long)this.flushInterval);
    }

    public void cancelTask() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
            this.flushTask = null;
        }
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public LogFlushTask getFlushTask() {
        return this.flushTask;
    }

    static class LogFlushTask
    extends TimerTask {
        private final RepNode repNode;
        private VLSN lastCommitVLSN;

        public LogFlushTask(RepNode repNode) {
            this.repNode = repNode;
            this.lastCommitVLSN = repNode.getCurrentCommitVLSN();
        }

        public void run() {
            VLSN newCommitVLSN = this.repNode.getCurrentCommitVLSN();
            if (newCommitVLSN == null) {
                return;
            }
            if (this.lastCommitVLSN == null || newCommitVLSN.compareTo(this.lastCommitVLSN) == 1) {
                this.lastCommitVLSN = newCommitVLSN;
                this.repNode.getRepImpl().getLogManager().flush();
            }
        }
    }
}

