/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

public class TaskConfiguration {
    private final int minimumResults;
    private final int maxFailure;
    private final int parallelDiff;
    private final boolean forceUPD;
    private final boolean forceTCP;
    private final boolean sign;

    public TaskConfiguration(int minimumResults, int maxFailure, int parallelDiff) {
        this(minimumResults, maxFailure, parallelDiff, false, false, false);
    }

    public TaskConfiguration(int minimumResults, int maxFailure, int parallelDiff, boolean forceUPD, boolean forceTCP, boolean sign) {
        if (minimumResults < 0 || maxFailure < 0 || parallelDiff < 0) {
            throw new IllegalArgumentException("need to be larger or equals zero");
        }
        this.minimumResults = minimumResults;
        this.maxFailure = maxFailure;
        this.parallelDiff = parallelDiff;
        this.forceUPD = forceUPD;
        this.forceTCP = forceTCP;
        this.sign = sign;
    }

    public int getMinimumResults() {
        return this.minimumResults;
    }

    public int getMaxFailure() {
        return this.maxFailure;
    }

    public int getParallelDiff() {
        return this.parallelDiff;
    }

    public int getParallel() {
        return this.minimumResults + this.parallelDiff;
    }

    public boolean isForceUPD() {
        return this.forceUPD;
    }

    public boolean isForceTCP() {
        return this.forceTCP;
    }

    public boolean isSign() {
        return this.sign;
    }
}

