/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.config.ConfigurationStore;
import net.tomp2p.p2p.config.Configurations;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.ResponsibilityListener;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageGeneric;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageReplication
implements ResponsibilityListener,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStorageReplication.class);
    private final StorageGeneric storage;
    private final StorageRPC storageRPC;
    private final Peer peer;
    private final Map<BaseFuture, Long> pendingFutures;
    private final boolean forceUDP;

    public DefaultStorageReplication(Peer peer, StorageGeneric storage, StorageRPC storageRPC, Map<BaseFuture, Long> pendingFutures, boolean forceUDP) {
        this.peer = peer;
        this.storage = storage;
        this.storageRPC = storageRPC;
        this.pendingFutures = pendingFutures;
        this.forceUDP = forceUDP;
    }

    @Override
    public void otherResponsible(Number160 locationKey, PeerAddress other) {
        if (logger.isDebugEnabled()) {
            logger.debug("[storage] Other peer " + other + " is responsible for " + locationKey + " I'm " + this.storageRPC.getPeerAddress());
        }
        Map<Number480, Data> dataMap = this.storage.subMap(locationKey);
        Number160 domainKeyOld = null;
        HashMap<Number160, Data> dataMapConverted = new HashMap<Number160, Data>();
        for (Map.Entry<Number480, Data> entry : dataMap.entrySet()) {
            Number160 domainKey = entry.getKey().getDomainKey();
            Number160 contentKey = entry.getKey().getContentKey();
            Data data = entry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("transfer from " + this.storageRPC.getPeerAddress() + " to " + other + " for key " + locationKey);
            }
            if (domainKeyOld == null || domainKeyOld.equals(domainKey)) {
                dataMapConverted.put(contentKey, data);
            } else {
                HashMap<Number160, Data> dataMapConverted1 = new HashMap<Number160, Data>(dataMapConverted);
                this.send(other, locationKey, domainKey, dataMapConverted1);
                dataMapConverted.clear();
            }
            domainKeyOld = domainKey;
        }
        if (!dataMapConverted.isEmpty()) {
            this.send(other, locationKey, domainKeyOld, dataMapConverted);
        }
    }

    private void send(final PeerAddress other, final Number160 locationKey, final Number160 domainKey, final Map<Number160, Data> dataMapConverted) {
        this.peer.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse = DefaultStorageReplication.this.storageRPC.put(other, locationKey, domainKey, dataMapConverted, false, false, false, future.getChannelCreator(), DefaultStorageReplication.this.forceUDP);
                    Utils.addReleaseListener(futureResponse, DefaultStorageReplication.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                    DefaultStorageReplication.this.pendingFutures.put(futureResponse, Timings.currentTimeMillis());
                } else if (logger.isErrorEnabled()) {
                    logger.error("otherResponsible failed " + future.getFailedReason());
                }
            }
        });
    }

    @Override
    public void meResponsible(Number160 locationKey) {
        if (logger.isDebugEnabled()) {
            logger.debug("[storage] I (" + this.storageRPC.getPeerAddress() + ") now responsible for " + locationKey);
        }
    }

    @Override
    public void run() {
        Collection<Number160> locationKeys = this.storage.findContentForResponsiblePeerID(this.peer.getPeerID());
        if (locationKeys == null) {
            return;
        }
        for (Number160 locationKey : locationKeys) {
            Map<Number480, Data> dataMap = this.storage.subMap(locationKey);
            Number160 domainKeyOld = null;
            HashMap<Number160, Data> dataMapConverted = new HashMap<Number160, Data>();
            for (Map.Entry<Number480, Data> entry : dataMap.entrySet()) {
                Number160 domainKey = entry.getKey().getDomainKey();
                Number160 contentKey = entry.getKey().getContentKey();
                Data data = entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("[storage refresh] I (" + this.storageRPC.getPeerAddress() + ") restore " + locationKey);
                }
                if (domainKeyOld == null || domainKeyOld.equals(domainKey)) {
                    dataMapConverted.put(contentKey, data);
                } else {
                    HashMap<Number160, Data> dataMapConverted1 = new HashMap<Number160, Data>(dataMapConverted);
                    dataMapConverted.clear();
                    ConfigurationStore config = Configurations.defaultStoreConfiguration();
                    config.setDomain(domainKey);
                    config.setContentKey(contentKey);
                    config.setStoreIfAbsent(true);
                    this.pendingFutures.put(this.peer.put(locationKey, dataMapConverted1, config), System.currentTimeMillis());
                }
                domainKeyOld = domainKey;
            }
        }
    }
}

