/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.HashData;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(StorageRPC.class);

    public StorageRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.COMPARE_PUT, Message.Command.PUT, Message.Command.GET, Message.Command.ADD, Message.Command.REMOVE);
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public FutureResponse put(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP) {
        Message.Type request = protectDomain ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        return this.put(remotePeer, locationKey, domainKey, dataMap, request, protectDomain || signMessage || protectEntry, channelCreator, forceUDP);
    }

    public FutureResponse putIfAbsent(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP) {
        Message.Type request = protectDomain ? Message.Type.REQUEST_4 : Message.Type.REQUEST_3;
        return this.put(remotePeer, locationKey, domainKey, dataMap, request, protectDomain || signMessage || protectEntry, channelCreator, forceUDP);
    }

    public FutureResponse compareAndPut(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, HashData> hashDataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, boolean partialPut, ChannelCreator channelCreator, boolean forceUDP) {
        this.nullCheck(remotePeer, locationKey, domainKey, hashDataMap);
        Message message = protectDomain ? this.createMessage(remotePeer, Message.Command.COMPARE_PUT, partialPut ? Message.Type.REQUEST_4 : Message.Type.REQUEST_2) : this.createMessage(remotePeer, Message.Command.COMPARE_PUT, partialPut ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setHashDataMap(hashDataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendTCP(channelCreator);
        }
        RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendUDP(channelCreator);
    }

    private FutureResponse put(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, Message.Type type, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP) {
        this.nullCheck(remotePeer, locationKey, domainKey, dataMap);
        Message message = this.createMessage(remotePeer, Message.Command.PUT, type);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendTCP(channelCreator);
        }
        RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendUDP(channelCreator);
    }

    public FutureResponse add(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Data> dataSet, boolean protectDomain, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP) {
        Message.Type type = protectDomain ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1;
        this.nullCheck(remotePeer, locationKey, domainKey, dataSet);
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>(dataSet.size());
        for (Data data : dataSet) {
            dataMap.put(data.getHash(), data);
        }
        Message message = this.createMessage(remotePeer, Message.Command.ADD, type);
        if (protectDomain || signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendTCP(channelCreator);
        }
        RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendUDP(channelCreator);
    }

    public FutureResponse get(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, PublicKey protectedDomains, boolean signMessage, boolean digest, ChannelCreator channelCreator, boolean forceUDP) {
        this.nullCheck(remotePeer, locationKey, domainKey);
        Message message = this.createMessage(remotePeer, Message.Command.GET, digest ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        if (protectedDomains != null) {
            message.setPublicKey(protectedDomains);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceUDP) {
            RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
            return request.sendTCP(channelCreator);
        }
        RequestHandlerUDP<FutureResponse> request = new RequestHandlerUDP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendUDP(channelCreator);
    }

    public FutureResponse remove(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, boolean sendBackResults, boolean signMessage, ChannelCreator channelCreator, boolean forceUDP) {
        this.nullCheck(remotePeer, locationKey, domainKey);
        Message message = this.createMessage(remotePeer, Message.Command.REMOVE, sendBackResults ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandlerTCP<FutureResponse> request = new RequestHandlerTCP<FutureResponse>(futureResponse, this.getPeerBean(), this.getConnectionBean(), message);
        return request.sendTCP(channelCreator);
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws IOException {
        if (message.getCommand() != Message.Command.ADD && message.getCommand() != Message.Command.PUT && message.getCommand() != Message.Command.GET && message.getCommand() != Message.Command.REMOVE && message.getCommand() != Message.Command.COMPARE_PUT) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.getPeerBean().getKeyPair());
        }
        switch (message.getCommand()) {
            case ADD: {
                this.nullCheck(message.getKeyKey1(), message.getKeyKey2(), message.getDataMap());
                return this.handleAdd(message, responseMessage, this.isDomainProtected(message));
            }
            case PUT: {
                this.nullCheck(message.getKeyKey1(), message.getKeyKey2(), message.getDataMap());
                return this.handlePut(message, responseMessage, this.isStoreIfAbsent(message), this.isDomainProtected(message));
            }
            case GET: {
                this.nullCheck(message.getKeyKey1(), message.getKeyKey2());
                return this.handleGet(message, responseMessage);
            }
            case REMOVE: {
                this.nullCheck(message.getKeyKey1(), message.getKeyKey2());
                return this.handleRemove(message, responseMessage, message.getType() == Message.Type.REQUEST_2);
            }
            case COMPARE_PUT: {
                this.nullCheck(message.getKeyKey1(), message.getKeyKey2(), message.getHashDataMap());
                return this.handleCompareAndPut(message, responseMessage, this.isPartial(message), this.isDomainProtected(message));
            }
        }
        throw new IllegalArgumentException("Message content is wrong");
    }

    private boolean isDomainProtected(Message message) {
        boolean protectDomain = message.getPublicKey() != null && (message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_4);
        return protectDomain;
    }

    private boolean isStoreIfAbsent(Message message) {
        boolean absent = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return absent;
    }

    private boolean isPartial(Message message) {
        boolean partial = message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4;
        return partial;
    }

    private Message handlePut(Message message, Message responseMessage, boolean putIfAbsent, boolean protectDomain) throws IOException {
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Map<Number160, Data> toStore = message.getDataMap();
        PublicKey publicKey = message.getPublicKey();
        if (this.getPeerBean().getReplicationStorage() != null) {
            this.getPeerBean().getReplicationStorage().updatePeerMapIfCloser(locationKey, message.getSender().getID());
        }
        HashSet<Number160> result = new HashSet<Number160>();
        for (Map.Entry<Number160, Data> entry : toStore.entrySet()) {
            if (this.getPeerBean().getStorage().put(locationKey, domainKey, entry.getKey(), entry.getValue(), publicKey, putIfAbsent, protectDomain)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("put data with key " + locationKey + " on " + this.getPeerBean().getServerPeerAddress());
                }
                result.add(entry.getKey());
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("could not add " + locationKey + " on " + this.getPeerBean().getServerPeerAddress());
            }
            this.getPeerBean().getStorage().put(locationKey, domainKey, entry.getKey(), entry.getValue(), publicKey, putIfAbsent, protectDomain);
        }
        if (result.size() > 0 && this.getPeerBean().getReplicationStorage() != null) {
            this.getPeerBean().getReplicationStorage().checkResponsibility(locationKey);
        }
        if (result.size() == 0 && !putIfAbsent) {
            responseMessage.setType(Message.Type.DENIED);
        } else if (result.size() == 0 && putIfAbsent) {
            responseMessage.setType(Message.Type.OK);
            responseMessage.setKeys(result);
        } else {
            responseMessage.setKeys(result);
            if (result.size() != toStore.size()) {
                responseMessage.setType(Message.Type.PARTIALLY_OK);
            }
        }
        return responseMessage;
    }

    private Message handleAdd(Message message, Message responseMessage, boolean protectDomain) {
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Map<Number160, Data> data = message.getDataMap();
        PublicKey publicKey = message.getPublicKey();
        if (this.getPeerBean().getReplicationStorage() != null) {
            this.getPeerBean().getReplicationStorage().updatePeerMapIfCloser(locationKey, message.getSender().getID());
        }
        HashSet<Number160> result = new HashSet<Number160>();
        for (Map.Entry<Number160, Data> entry : data.entrySet()) {
            if (!this.getPeerBean().getStorage().put(locationKey, domainKey, entry.getKey(), entry.getValue(), publicKey, false, protectDomain)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("add data with key " + locationKey + " on " + this.getPeerBean().getServerPeerAddress());
            }
            result.add(entry.getKey());
        }
        if (result.size() > 0 && this.getPeerBean().getReplicationStorage() != null) {
            this.getPeerBean().getReplicationStorage().checkResponsibility(locationKey);
        }
        responseMessage.setKeys(result);
        return responseMessage;
    }

    private Message handleGet(Message message, Message responseMessage) {
        HashMap<Number480, Data> result;
        boolean digest;
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Collection<Number160> contentKeys = message.getKeys();
        boolean bl = digest = message.getType() == Message.Type.REQUEST_2;
        if (digest) {
            DigestInfo digestInfo = this.getPeerBean().getStorage().digest(locationKey, domainKey, contentKeys);
            responseMessage.setKeys(digestInfo.getKeyDigests());
            return responseMessage;
        }
        if (contentKeys != null) {
            result = new HashMap();
            for (Number160 contentKey : contentKeys) {
                Number480 key = new Number480(locationKey, domainKey, contentKey);
                Data data = this.getPeerBean().getStorage().get(locationKey, domainKey, contentKey);
                if (data == null) continue;
                result.put(key, data);
            }
        } else {
            result = this.getPeerBean().getStorage().get(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE);
        }
        responseMessage.setDataMapConvert(result);
        return responseMessage;
    }

    private Message handleRemove(Message message, Message responseMessage, boolean sendBackResults) {
        Map<Object, Object> result;
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Collection<Number160> contentKeys = message.getKeys();
        PublicKey publicKey = message.getPublicKey();
        if (contentKeys != null) {
            result = new HashMap();
            for (Number160 contentKey : contentKeys) {
                Number480 key = new Number480(locationKey, domainKey, contentKey);
                Data data = this.getPeerBean().getStorage().remove(locationKey, domainKey, contentKey, publicKey);
                if (data == null) continue;
                result.put(key, data);
            }
        } else {
            result = this.getPeerBean().getStorage().remove(locationKey, domainKey, Number160.ZERO, Number160.MAX_VALUE, publicKey);
        }
        if (!sendBackResults) {
            responseMessage.setKeysConvert(result.keySet());
        } else {
            responseMessage.setDataMapConvert(result);
        }
        return responseMessage;
    }

    private Message handleCompareAndPut(Message message, Message responseMessage, boolean partial, boolean protectDomain) {
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Map<Number160, HashData> hashDataMap = message.getHashDataMap();
        PublicKey publicKey = message.getPublicKey();
        Collection<Number160> result = this.getPeerBean().getStorage().compareAndPut(locationKey, domainKey, hashDataMap, publicKey, partial, protectDomain);
        if (logger.isDebugEnabled()) {
            logger.debug("stored " + result.size());
        }
        if (result.size() > 0 && this.getPeerBean().getReplicationStorage() != null) {
            this.getPeerBean().getReplicationStorage().checkResponsibility(locationKey);
        }
        responseMessage.setKeys(result);
        if (result.size() == 0) {
            responseMessage.setType(Message.Type.NOT_FOUND);
        } else if (result.size() != hashDataMap.size()) {
            responseMessage.setType(Message.Type.PARTIALLY_OK);
        }
        return responseMessage;
    }
}

