/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import net.tomp2p.upnp.StateVariable;
import net.tomp2p.upnp.StateVariableResponse;
import net.tomp2p.upnp.UPNPResponseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class StateVariableResponseParser
extends DefaultHandler {
    private static final String SOAP_FAULT_EL = "Fault";
    private StateVariable stateVar;
    private boolean faultResponse = false;
    private UPNPResponseException msgEx;
    private boolean readFaultCode = false;
    private boolean readFaultString = false;
    private boolean readErrorCode = false;
    private boolean readErrorDescription = false;
    private boolean parseStateVar = false;
    private StateVariableResponse result;

    StateVariableResponseParser(StateVariable stateVar) {
        this.stateVar = stateVar;
    }

    UPNPResponseException getUPNPResponseException() {
        return this.msgEx;
    }

    StateVariableResponse getStateVariableResponse() {
        return this.result;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.parseStateVar) {
            String origChars = this.result.stateVariableValue;
            String newChars = new String(ch, start, length);
            this.result.stateVariableValue = origChars == null ? newChars : origChars + newChars;
        } else if (this.readFaultCode) {
            this.msgEx.faultCode = new String(ch, start, length);
            this.readFaultCode = false;
        } else if (this.readFaultString) {
            this.msgEx.faultString = new String(ch, start, length);
            this.readFaultString = false;
        } else if (this.readErrorCode) {
            String code = new String(ch, start, length);
            try {
                this.msgEx.detailErrorCode = Integer.parseInt(code);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this.readErrorCode = false;
        } else if (this.readErrorDescription) {
            this.msgEx.detailErrorDescription = new String(ch, start, length);
            this.readErrorDescription = false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.faultResponse) {
            if (localName.equals("faultcode")) {
                this.readFaultCode = true;
            } else if (localName.equals("faultstring")) {
                this.readFaultString = true;
            } else if (localName.equals("errorCode")) {
                this.readErrorCode = true;
            } else if (localName.equals("errorDescription")) {
                this.readErrorDescription = true;
            }
        } else if (localName.equals(SOAP_FAULT_EL)) {
            this.msgEx = new UPNPResponseException();
            this.faultResponse = true;
        } else if (localName.equals("return") || localName.equals("varName")) {
            this.parseStateVar = true;
            this.result = new StateVariableResponse(this.stateVar);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("return") || localName.equals("varName")) {
            this.parseStateVar = false;
        }
    }
}

