/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.TrackerData;

public class Utils {
    private static final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer loadFile(File file) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream fis = null;
        FileChannel channel = null;
        try {
            fis = new FileInputStream(file);
            channel = fis.getChannel();
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        }
        catch (Throwable throwable) {
            Utils.bestEffortclose(channel, fis);
            throw throwable;
        }
        Utils.bestEffortclose(channel, fis);
        return mappedByteBuffer;
    }

    /*
     * Exception decompiling
     */
    public static Number160 makeSHAHash(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Number160 makeSHAHash(String strInput) {
        byte[] buffer = strInput.getBytes();
        return Utils.makeSHAHash(buffer);
    }

    public static Number160 makeSHAHash(ByteBuffer buffer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(buffer);
            byte[] digest = md.digest();
            return new Number160(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new Number160();
        }
    }

    public static Number160 makeSHAHash(byte[] buffer) {
        return Utils.makeSHAHash(ByteBuffer.wrap(buffer));
    }

    public static Number160 makeSHAHash(byte[] buffer, int offset, int length) {
        return Utils.makeSHAHash(ByteBuffer.wrap(buffer, offset, length));
    }

    public static Number160 createRandomNodeID() {
        byte[] me = new byte[20];
        random.nextBytes(me);
        Number160 id = new Number160(me);
        return id;
    }

    public static byte[] compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] compressedData, int offset, int length) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData, offset, length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] compressedData) {
        return Utils.uncompress(compressedData, 0, compressedData.length);
    }

    public static byte[] encodeJavaObject(Object attachement) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(attachement);
        byte[] data = bos.toByteArray();
        return data;
    }

    public static Object decodeJavaObject(byte[] me, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(me, offset, length);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = ois.readObject();
        return obj;
    }

    public static <K> Collection<K> difference(Collection<K> collection1, Collection<K> result, Collection<K> collection2) {
        for (K item : collection1) {
            if (collection2.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <K> Collection<K> difference(Collection<K> collection1, Collection<K> result, Collection<K> ... collections2) {
        for (K item : collection1) {
            int size = collections2.length;
            for (int i = 0; i < size; ++i) {
                if (collections2[i].contains(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public static void bestEffortclose(Closeable ... closables) {
        for (Closeable closable : closables) {
            if (closable == null) continue;
            try {
                closable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static <K> K pollRandom(SortedSet<K> queueToAsk, Random rnd) {
        int size = queueToAsk.size();
        if (size == 0) {
            return null;
        }
        int index = rnd.nextInt(size);
        ArrayList<K> values = new ArrayList<K>(queueToAsk);
        Object retVal = values.get(index);
        queueToAsk.remove(retVal);
        return (K)retVal;
    }

    public static <K, V> Map.Entry<K, V> pollRandomKey(Map<K, V> queueToAsk, Random rnd) {
        int size = queueToAsk.size();
        if (size == 0) {
            return null;
        }
        ArrayList<K> keys = new ArrayList<K>();
        keys.addAll(queueToAsk.keySet());
        int index = rnd.nextInt(size);
        final Object key = keys.get(index);
        final V value = queueToAsk.remove(key);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                return null;
            }
        };
    }

    public static <K> Collection<K> subtract(Collection<K> a, Collection<K> b) {
        ArrayList<K> list = new ArrayList<K>(a);
        Iterator<K> it = b.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static <K, V> Map<K, V> subtract(Map<K, V> a, Collection<K> b) {
        HashMap<K, V> map = new HashMap<K, V>(a);
        Iterator<K> it = b.iterator();
        while (it.hasNext()) {
            map.remove(it.next());
        }
        return map;
    }

    public static <K, V> Map<K, V> disjunction(Map<K, V> a, Collection<K> b) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : a.entrySet()) {
            if (b.contains(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K> Collection<K> limit(Collection<K> a, int size) {
        ArrayList<K> list = new ArrayList<K>();
        int i = 0;
        Iterator<K> it = a.iterator();
        while (it.hasNext() && i < size) {
            list.add(it.next());
        }
        return list;
    }

    public static <K, V> Map<K, V> limit(Map<K, V> a, int i) {
        HashMap<K, V> map = new HashMap<K, V>(a);
        Iterator<K> it = a.keySet().iterator();
        for (int remove = a.size() - i; it.hasNext() && remove >= 0; --remove) {
            map.remove(it.next());
        }
        return map;
    }

    public static Collection<Number160> convert(Collection<TrackerData> a) {
        ArrayList<Number160> retVal = new ArrayList<Number160>();
        Iterator<TrackerData> it = a.iterator();
        while (it.hasNext()) {
            retVal.add(it.next().getPeerAddress().getID());
        }
        return retVal;
    }

    public static String debugArray(byte[] array, int offset, int length) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            int bi = array[offset + i] & 0xFF;
            sb.append(digits.charAt(bi >> 4));
            sb.append(digits.charAt(bi & 0xF));
        }
        return sb.toString();
    }

    public static String debugArray(byte[] array) {
        return Utils.debugArray(array, 0, array.length);
    }

    public static boolean checkEntryProtection(Map<Number160, Data> dataMap) {
        for (Data data : dataMap.values()) {
            if (!data.isProtectedEntry()) continue;
            return true;
        }
        return false;
    }

    public static void addReleaseListener(BaseFuture baseFuture, final ConnectionReservation connectionReservation, final ChannelCreator cc, final int nr) {
        baseFuture.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

            @Override
            public void operationComplete(BaseFuture future) throws Exception {
                connectionReservation.release(cc, nr);
            }
        });
    }

    public static void addReleaseListenerAll(BaseFuture baseFuture, final ConnectionReservation connectionReservation, final ChannelCreator channelCreator) {
        if (channelCreator == null) {
            throw new IllegalArgumentException("channelCreator cannot be null");
        }
        baseFuture.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<BaseFuture>(){

            @Override
            public void operationComplete(BaseFuture future) throws Exception {
                connectionReservation.release(channelCreator);
            }
        });
    }

    public static Map<Number160, TrackerData> limitRandom(Map<Number160, TrackerData> activePeers, int trackerSize) {
        return activePeers;
    }

    public static <K> K getLast(List<K> list) {
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static Inet4Address fromInteger(int address) {
        return Utils.getInet4Address(Utils.toByteArray(address));
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private static Inet4Address getInet4Address(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("Byte array has invalid length for an IPv4 address");
        }
        try {
            InetAddress ipv4 = InetAddress.getByAddress(bytes);
            if (!(ipv4 instanceof Inet4Address)) {
                throw new UnknownHostException(String.format("'%s' is not an IPv4 address.", ipv4.getHostAddress()));
            }
            return (Inet4Address)ipv4;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(bytes)), e);
        }
    }

    public static File createTempDir() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

