/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.jdbm.BTree;
import org.apache.jdbm.BTreeLazyRecord;
import org.apache.jdbm.DBStore;
import org.apache.jdbm.DataInputOutput;
import org.apache.jdbm.LongPacker;
import org.apache.jdbm.Serializer;
import org.apache.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BTreeNode<K, V>
implements Serializer<BTreeNode<K, V>> {
    private static final boolean DEBUG = false;
    transient BTree<K, V> _btree;
    protected transient long _recid;
    protected boolean _isLeaf;
    protected K[] _keys;
    protected Object[] _values;
    protected long[] _children;
    protected byte _first;
    protected long _previous;
    protected long _next;
    private static final int ALL_NULL = 0;
    private static final int ALL_INTEGERS = 32;
    private static final int ALL_INTEGERS_NEGATIVE = 64;
    private static final int ALL_LONGS = 96;
    private static final int ALL_LONGS_NEGATIVE = 128;
    private static final int ALL_STRINGS = 160;
    private static final int ALL_OTHER = 192;

    public BTree<K, V> getBTree() {
        return this._btree;
    }

    public BTreeNode() {
    }

    BTreeNode(BTree<K, V> btree, BTreeNode<K, V> root, BTreeNode<K, V> overflow) throws IOException {
        this._btree = btree;
        this._isLeaf = false;
        this._first = (byte)30;
        this._keys = new Object[32];
        this._keys[30] = overflow.getLargestKey();
        this._keys[31] = root.getLargestKey();
        this._children = new long[32];
        this._children[30] = overflow._recid;
        this._children[31] = root._recid;
        this._recid = this._btree._db.insert(this, this, false);
    }

    BTreeNode(BTree<K, V> btree, K key, V value) throws IOException {
        this._btree = btree;
        this._isLeaf = true;
        this._first = (byte)30;
        this._keys = new Object[32];
        this._keys[30] = key;
        this._keys[31] = null;
        this._values = new Object[32];
        this._values[30] = value;
        this._values[31] = null;
        this._recid = this._btree._db.insert(this, this, false);
    }

    BTreeNode(BTree<K, V> btree, boolean isLeaf) {
        this._btree = btree;
        this._isLeaf = isLeaf;
        this._first = (byte)16;
        this._keys = new Object[32];
        if (isLeaf) {
            this._values = new Object[32];
        } else {
            this._children = new long[32];
        }
        try {
            this._recid = this._btree._db.insert(this, this, false);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    K getLargestKey() {
        return this._keys[31];
    }

    boolean isEmpty() {
        if (this._isLeaf) {
            return this._first == this._values.length - 1;
        }
        return this._first == this._children.length - 1;
    }

    boolean isFull() {
        return this._first == 0;
    }

    BTree.BTreeTupleBrowser<K, V> find(int height, K key, boolean inclusive) throws IOException {
        byte index = this.findChildren(key, inclusive);
        if (--height == 0) {
            return new Browser(this, index);
        }
        BTreeNode<K, V> child = this.loadNode(this._children[index]);
        return child.find(height, key, inclusive);
    }

    V findValue(int height, K key) throws IOException {
        byte index = this.findChildren(key, true);
        if (--height == 0) {
            K key2 = this._keys[index];
            if (key2 == null || this.compare(key, key2) != 0) {
                return null;
            }
            if (this._values[index] instanceof BTreeLazyRecord) {
                return (V)((BTreeLazyRecord)this._values[index]).get();
            }
            return (V)this._values[index];
        }
        BTreeNode<K, V> child = this.loadNode(this._children[index]);
        return child.findValue(height, key);
    }

    BTree.BTreeTupleBrowser<K, V> findFirst() throws IOException {
        if (this._isLeaf) {
            return new Browser(this, this._first);
        }
        BTreeNode<K, V> child = this.loadNode(this._children[this._first]);
        return child.findFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void delete() throws IOException {
        if (this._isLeaf) {
            if (this._next != 0L) {
                BTreeNode<K, V> nextNode = this.loadNode(this._next);
                if (nextNode._previous != this._recid) throw new Error("Inconsistent data in BTree");
                nextNode._previous = this._previous;
                this._btree._db.update(nextNode._recid, nextNode, nextNode);
            }
            if (this._previous != 0L) {
                BTreeNode<K, V> previousNode = this.loadNode(this._previous);
                if (previousNode._next == this._recid) throw new Error("Inconsistent data in BTree");
                previousNode._next = this._next;
                this._btree._db.update(previousNode._recid, previousNode, previousNode);
            }
        } else {
            int left = this._first;
            int right = 31;
            for (int i = left; i <= right; ++i) {
                BTreeNode<K, V> childNode = this.loadNode(this._children[i]);
                childNode.delete();
            }
        }
        this._btree._db.delete(this._recid);
    }

    InsertResult<K, V> insert(int height, K key, V value, boolean replace) throws IOException {
        long overflow;
        InsertResult result;
        byte index = this.findChildren(key, true);
        if (--height == 0) {
            result = this._btree.insertResultReuse;
            this._btree.insertResultReuse = null;
            if (result == null) {
                result = new InsertResult();
            }
            overflow = -1L;
            if (this.compare(this._keys[index], key) == 0) {
                boolean isLazyRecord = this._values[index] instanceof BTreeLazyRecord;
                result._existing = isLazyRecord ? ((BTreeLazyRecord)this._values[index]).get() : this._values[index];
                if (replace) {
                    if (isLazyRecord) {
                        ((BTreeLazyRecord)this._values[index]).delete();
                    }
                    this._values[index] = value;
                    this._btree._db.update(this._recid, this, this);
                }
                return result;
            }
        } else {
            BTreeNode<K, V> child = this.loadNode(this._children[index]);
            result = child.insert(height, key, value, replace);
            if (result._existing != null) {
                return result;
            }
            if (result._overflow == null) {
                return result;
            }
            key = result._overflow.getLargestKey();
            overflow = result._overflow._recid;
            this._keys[index] = child.getLargestKey();
            result._overflow = null;
        }
        if (!this.isFull()) {
            if (height == 0) {
                BTreeNode.insertEntry(this, index - 1, key, value);
            } else {
                BTreeNode.insertChild(this, index - 1, key, overflow);
            }
            this._btree._db.update(this._recid, this, this);
            return result;
        }
        int half = 16;
        BTreeNode<K, V> newNode = new BTreeNode<K, V>(this._btree, this._isLeaf);
        if (index < 16) {
            if (height == 0) {
                BTreeNode.copyEntries(this, 0, newNode, 16, index);
                BTreeNode.setEntry(newNode, 16 + index, key, value);
                BTreeNode.copyEntries(this, index, newNode, 16 + index + 1, 16 - index - 1);
            } else {
                BTreeNode.copyChildren(this, 0, newNode, 16, index);
                BTreeNode.setChild(newNode, 16 + index, key, overflow);
                BTreeNode.copyChildren(this, index, newNode, 16 + index + 1, 16 - index - 1);
            }
        } else if (height == 0) {
            BTreeNode.copyEntries(this, 0, newNode, 16, 16);
            BTreeNode.copyEntries(this, 16, this, 15, index - 16);
            BTreeNode.setEntry(this, index - 1, key, value);
        } else {
            BTreeNode.copyChildren(this, 0, newNode, 16, 16);
            BTreeNode.copyChildren(this, 16, this, 15, index - 16);
            BTreeNode.setChild(this, index - 1, key, overflow);
        }
        this._first = (byte)15;
        for (int i = 0; i < this._first; ++i) {
            if (height == 0) {
                BTreeNode.setEntry(this, i, null, null);
                continue;
            }
            BTreeNode.setChild(this, i, null, -1L);
        }
        if (this._isLeaf) {
            newNode._previous = this._previous;
            newNode._next = this._recid;
            if (this._previous != 0L) {
                BTreeNode<K, V> previous = this.loadNode(this._previous);
                previous._next = newNode._recid;
                this._btree._db.update(this._previous, previous, this);
            }
            this._previous = newNode._recid;
        }
        this._btree._db.update(this._recid, this, this);
        this._btree._db.update(newNode._recid, newNode, this);
        result._overflow = newNode;
        return result;
    }

    RemoveResult<K, V> remove(int height, K key) throws IOException {
        RemoveResult result;
        byte half = 16;
        byte index = this.findChildren(key, true);
        if (--height == 0) {
            if (this.compare(this._keys[index], key) != 0) {
                throw new IllegalArgumentException("Key not found: " + key);
            }
            result = new RemoveResult();
            if (this._values[index] instanceof BTreeLazyRecord) {
                BTreeLazyRecord r = (BTreeLazyRecord)this._values[index];
                result._value = r.get();
                r.delete();
            } else {
                result._value = this._values[index];
            }
            BTreeNode.removeEntry(this, index);
            this._btree._db.update(this._recid, this, this);
        } else {
            BTreeNode<K, V> child = this.loadNode(this._children[index]);
            result = child.remove(height, key);
            this._keys[index] = child.getLargestKey();
            this._btree._db.update(this._recid, this, this);
            if (result._underflow) {
                if (child._first != half + 1) {
                    throw new IllegalStateException("Error during underflow [1]");
                }
                if (index < this._children.length - 1) {
                    BTreeNode<K, V> brother = this.loadNode(this._children[index + 1]);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first = (byte)(brother._first + steal);
                        child._first = (byte)(child._first - steal);
                        if (child._isLeaf) {
                            BTreeNode.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                            BTreeNode.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        } else {
                            BTreeNode.copyChildren(child, half + 1, child, half + 1 - steal, half - 1);
                            BTreeNode.copyChildren(brother, bfirst, child, 2 * half - steal, steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BTreeNode.setEntry(brother, i, null, null);
                                continue;
                            }
                            BTreeNode.setChild(brother, i, null, -1L);
                        }
                        this._keys[index] = child.getLargestKey();
                        this._btree._db.update(this._recid, this, this);
                        this._btree._db.update(brother._recid, brother, this);
                        this._btree._db.update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [2]");
                        }
                        brother._first = 1;
                        if (child._isLeaf) {
                            BTreeNode.copyEntries(child, half + 1, brother, 1, half - 1);
                        } else {
                            BTreeNode.copyChildren(child, half + 1, brother, 1, half - 1);
                        }
                        this._btree._db.update(brother._recid, brother, this);
                        if (this._isLeaf) {
                            BTreeNode.copyEntries(this, this._first, this, this._first + 1, index - this._first);
                            BTreeNode.setEntry(this, this._first, null, null);
                        } else {
                            BTreeNode.copyChildren(this, this._first, this, this._first + 1, index - this._first);
                            BTreeNode.setChild(this, this._first, null, -1L);
                        }
                        this._first = (byte)(this._first + 1);
                        this._btree._db.update(this._recid, this, this);
                        if (child._previous != 0L) {
                            BTreeNode<K, V> prev = this.loadNode(child._previous);
                            prev._next = child._next;
                            this._btree._db.update(prev._recid, prev, this);
                        }
                        if (child._next != 0L) {
                            BTreeNode<K, V> next = this.loadNode(child._next);
                            next._previous = child._previous;
                            this._btree._db.update(next._recid, next, this);
                        }
                        this._btree._db.delete(child._recid);
                    }
                } else {
                    BTreeNode<K, V> brother = this.loadNode(this._children[index - 1]);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first = (byte)(brother._first + steal);
                        child._first = (byte)(child._first - steal);
                        if (child._isLeaf) {
                            BTreeNode.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BTreeNode.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        } else {
                            BTreeNode.copyChildren(brother, 2 * half - steal, child, half + 1 - steal, steal);
                            BTreeNode.copyChildren(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        }
                        for (int i = bfirst; i < bfirst + steal; ++i) {
                            if (brother._isLeaf) {
                                BTreeNode.setEntry(brother, i, null, null);
                                continue;
                            }
                            BTreeNode.setChild(brother, i, null, -1L);
                        }
                        this._keys[index - 1] = brother.getLargestKey();
                        this._btree._db.update(this._recid, this, this);
                        this._btree._db.update(brother._recid, brother, this);
                        this._btree._db.update(child._recid, child, this);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [3]");
                        }
                        child._first = 1;
                        if (child._isLeaf) {
                            BTreeNode.copyEntries(brother, half, child, 1, half);
                        } else {
                            BTreeNode.copyChildren(brother, half, child, 1, half);
                        }
                        this._btree._db.update(child._recid, child, this);
                        if (this._isLeaf) {
                            BTreeNode.copyEntries(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BTreeNode.setEntry(this, this._first, null, null);
                        } else {
                            BTreeNode.copyChildren(this, this._first, this, this._first + 1, index - 1 - this._first);
                            BTreeNode.setChild(this, this._first, null, -1L);
                        }
                        this._first = (byte)(this._first + 1);
                        this._btree._db.update(this._recid, this, this);
                        if (brother._previous != 0L) {
                            BTreeNode<K, V> prev = this.loadNode(brother._previous);
                            prev._next = brother._next;
                            this._btree._db.update(prev._recid, prev, this);
                        }
                        if (brother._next != 0L) {
                            BTreeNode<K, V> next = this.loadNode(brother._next);
                            next._previous = brother._previous;
                            this._btree._db.update(next._recid, next, this);
                        }
                        this._btree._db.delete(brother._recid);
                    }
                }
            }
        }
        result._underflow = this._first > half;
        return result;
    }

    private byte findChildren(K key, boolean inclusive) {
        int D;
        int left = this._first;
        int right = 31;
        int n = D = inclusive ? 0 : 1;
        do {
            int middle;
            if (this.compare(this._keys[middle = (left + right) / 2], key) < D) {
                left = middle + 1;
                continue;
            }
            right = middle;
        } while (left < right);
        return (byte)right;
    }

    private static <K, V> void insertEntry(BTreeNode<K, V> node, int index, K key, V value) {
        K[] keys = node._keys;
        Object[] values = node._values;
        byte start = node._first;
        int count = index - node._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        node._first = (byte)(node._first - 1);
        keys[index] = key;
        values[index] = value;
    }

    private static <K, V> void insertChild(BTreeNode<K, V> node, int index, K key, long child) {
        K[] keys = node._keys;
        long[] children = node._children;
        byte start = node._first;
        int count = index - node._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(children, start, children, start - 1, count);
        node._first = (byte)(node._first - 1);
        keys[index] = key;
        children[index] = child;
    }

    private static <K, V> void removeEntry(BTreeNode<K, V> node, int index) {
        K[] keys = node._keys;
        Object[] values = node._values;
        byte start = node._first;
        int count = index - node._first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        node._first = (byte)(node._first + 1);
    }

    private static <K, V> void setEntry(BTreeNode<K, V> node, int index, K key, V value) {
        node._keys[index] = key;
        node._values[index] = value;
    }

    private static <K, V> void setChild(BTreeNode<K, V> node, int index, K key, long recid) {
        node._keys[index] = key;
        node._children[index] = recid;
    }

    private static <K, V> void copyEntries(BTreeNode<K, V> source, int indexSource, BTreeNode<K, V> dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._values, indexSource, dest._values, indexDest, count);
    }

    private static <K, V> void copyChildren(BTreeNode<K, V> source, int indexSource, BTreeNode<K, V> dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._children, indexSource, dest._children, indexDest, count);
    }

    private BTreeNode<K, V> loadNode(long recid) throws IOException {
        BTreeNode child = (BTreeNode)this._btree._db.fetch(recid, this);
        child._recid = recid;
        child._btree = this._btree;
        return child;
    }

    private final int compare(K value1, K value2) {
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        if (this._btree._comparator == null) {
            return ((Comparable)value1).compareTo(value2);
        }
        return this._btree._comparator.compare(value1, value2);
    }

    private void dump(int height) {
        int i;
        String prefix = "";
        for (i = 0; i < height; ++i) {
            prefix = prefix + "    ";
        }
        System.out.println(prefix + "-------------------------------------- BTreeNode recid=" + this._recid);
        System.out.println(prefix + "first=" + this._first);
        for (i = 0; i < 32; ++i) {
            if (this._isLeaf) {
                System.out.println(prefix + "BTreeNode [" + i + "] " + this._keys[i] + " " + this._values[i]);
                continue;
            }
            System.out.println(prefix + "BTreeNode [" + i + "] " + this._keys[i] + " " + this._children[i]);
        }
        System.out.println(prefix + "--------------------------------------");
    }

    void dumpRecursive(int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            for (byte i = this._first; i < 32 && this._keys[i] != null; i = (byte)(i + 1)) {
                BTreeNode<K, V> child = this.loadNode(this._children[i]);
                super.dump(level);
                child.dumpRecursive(height, level);
            }
        }
    }

    @Override
    public BTreeNode<K, V> deserialize(DataInput ois2) throws IOException {
        DataInputOutput ois = (DataInputOutput)ois2;
        BTreeNode<K, V> node = new BTreeNode<K, V>();
        switch (ois.readUnsignedByte()) {
            case 162: {
                node._isLeaf = true;
                break;
            }
            case 163: {
                node._isLeaf = false;
                break;
            }
            default: {
                throw new InternalError("wrong BTreeNode header");
            }
        }
        if (node._isLeaf) {
            node._previous = LongPacker.unpackLong(ois);
            node._next = LongPacker.unpackLong(ois);
        }
        node._first = ois.readByte();
        if (!node._isLeaf) {
            node._children = new long[32];
            for (int i = node._first; i < 32; ++i) {
                node._children[i] = LongPacker.unpackLong(ois);
            }
        }
        if (!this._btree.loadValues) {
            return node;
        }
        try {
            node._keys = this.readKeys(ois, node._first);
        }
        catch (ClassNotFoundException except) {
            throw new IOException(except.getMessage());
        }
        if (node._isLeaf) {
            try {
                this.readValues(ois, node);
            }
            catch (ClassNotFoundException except) {
                throw new IOException(except);
            }
        }
        return node;
    }

    @Override
    public void serialize(DataOutput oos, BTreeNode<K, V> obj) throws IOException {
        BTreeNode<K, V> node = obj;
        oos.writeByte(node._isLeaf ? 162 : 163);
        if (node._isLeaf) {
            LongPacker.packLong(oos, node._previous);
            LongPacker.packLong(oos, node._next);
        }
        oos.write(node._first);
        if (!node._isLeaf) {
            for (int i = node._first; i < 32; ++i) {
                LongPacker.packLong(oos, node._children[i]);
            }
        }
        this.writeKeys(oos, node._keys, node._first);
        if (node._isLeaf && this._btree.hasValues()) {
            this.writeValues(oos, node);
        }
    }

    private void readValues(DataInputOutput ois, BTreeNode<K, V> node) throws IOException, ClassNotFoundException {
        node._values = new Object[32];
        if (this._btree.hasValues()) {
            Serializer serializer = this._btree.valueSerializer != null ? this._btree.valueSerializer : this._btree.getRecordManager().defaultSerializer();
            for (int i = node._first; i < 32; ++i) {
                int header = ois.readUnsignedByte();
                if (header == 255) {
                    node._values[i] = null;
                    continue;
                }
                if (header == 254) {
                    long recid = LongPacker.unpackLong(ois);
                    node._values[i] = new BTreeLazyRecord(this._btree._db, recid, serializer);
                    continue;
                }
                node._values[i] = BTreeLazyRecord.fastDeser(ois, serializer, header);
            }
        } else {
            for (int i = node._first; i < 32; ++i) {
                if (node._keys[i] == null) continue;
                node._values[i] = "";
            }
        }
    }

    private void writeValues(DataOutput oos, BTreeNode<K, V> node) throws IOException {
        DataInputOutput output = null;
        Serializer serializer = this._btree.valueSerializer != null ? this._btree.valueSerializer : this._btree.getRecordManager().defaultSerializer();
        for (int i = node._first; i < 32; ++i) {
            if (node._values[i] instanceof BTreeLazyRecord) {
                oos.write(254);
                LongPacker.packLong(oos, ((BTreeLazyRecord)node._values[i]).recid);
                continue;
            }
            if (node._values[i] != null) {
                if (output == null) {
                    output = new DataInputOutput();
                } else {
                    output.reset();
                }
                serializer.serialize(output, node._values[i]);
                if (output.getPos() > 32) {
                    long recid = this._btree._db.insert(output.toByteArray(), BTreeLazyRecord.FAKE_SERIALIZER, true);
                    oos.write(254);
                    LongPacker.packLong(oos, recid);
                    continue;
                }
                oos.write(output.getPos());
                oos.write(output.getBuf(), 0, output.getPos());
                continue;
            }
            oos.write(255);
        }
    }

    private K[] readKeys(DataInput ois, int firstUse) throws IOException, ClassNotFoundException {
        Object[] ret = new Object[32];
        int type = ois.readUnsignedByte();
        if (type == 0) {
            return ret;
        }
        if (type == 32 || type == 64) {
            long first = LongPacker.unpackLong(ois);
            if (type == 64) {
                first = -first;
            }
            ret[firstUse] = (int)first;
            for (int i = firstUse + 1; i < 32; ++i) {
                long v = LongPacker.unpackLong(ois);
                if (v == 0L) continue;
                ret[i] = (int)(v += first);
                first = v;
            }
            return ret;
        }
        if (type == 96 || type == 128) {
            long first = LongPacker.unpackLong(ois);
            if (type == 128) {
                first = -first;
            }
            ret[firstUse] = first;
            for (int i = firstUse + 1; i < 32; ++i) {
                long v = LongPacker.unpackLong(ois);
                if (v == 0L) continue;
                ret[i] = v += first;
                first = v;
            }
            return ret;
        }
        if (type == 160) {
            byte[] previous = null;
            for (int i = firstUse; i < 32; ++i) {
                byte[] b = BTreeNode.leadingValuePackRead(ois, previous, 0);
                if (b == null) continue;
                ret[i] = new String(b);
                previous = b;
            }
            return ret;
        }
        if (type == 192) {
            if (this._btree.keySerializer == null || this._btree.keySerializer == this._btree.getRecordManager().defaultSerializer()) {
                for (int i = firstUse; i < 32; ++i) {
                    ret[i] = this._btree.getRecordManager().defaultSerializer().deserialize(ois);
                }
                return ret;
            }
            Serializer ser = this._btree.keySerializer != null ? this._btree.keySerializer : this._btree.getRecordManager().defaultSerializer();
            DataInputOutput in2 = null;
            byte[] previous = null;
            for (int i = firstUse; i < 32; ++i) {
                byte[] b = BTreeNode.leadingValuePackRead(ois, previous, 0);
                if (b == null) continue;
                if (in2 == null) {
                    in2 = new DataInputOutput();
                }
                in2.reset(b);
                ret[i] = ser.deserialize(in2);
                previous = b;
            }
            return ret;
        }
        throw new InternalError("unknown BTreeNode header type: " + type);
    }

    private void writeKeys(DataOutput oos, K[] keys, int firstUse) throws IOException {
        int i;
        int i2;
        if (keys.length != 32) {
            throw new IllegalArgumentException("wrong keys size");
        }
        boolean allNull = true;
        for (i2 = firstUse; i2 < 32; ++i2) {
            if (keys[i2] == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            oos.write(0);
            return;
        }
        if (!(this._btree._comparator != Utils.COMPARABLE_COMPARATOR && this._btree._comparator != null || this._btree.keySerializer != null && this._btree.keySerializer != this._btree.getRecordManager().defaultSerializer())) {
            boolean allInteger = true;
            for (int i3 = firstUse; i3 < 32; ++i3) {
                if (keys[i3] == null || keys[i3].getClass() == Integer.class) continue;
                allInteger = false;
                break;
            }
            boolean allLong = true;
            for (int i4 = firstUse; i4 < 32; ++i4) {
                if (keys[i4] == null || keys[i4].getClass() == Long.class && (Long)keys[i4] != Long.MIN_VALUE) continue;
                allLong = false;
                break;
            }
            if (allLong) {
                long max = Long.MIN_VALUE;
                long min = Long.MAX_VALUE;
                for (int i5 = firstUse; i5 < 32; ++i5) {
                    if (keys[i5] == null) continue;
                    long v = (Long)keys[i5];
                    if (v > max) {
                        max = v;
                    }
                    if (v >= min) continue;
                    min = v;
                }
                double max2 = max;
                double min2 = min;
                double maxDiff = 9.223372036854776E18;
                if (max2 - min2 > maxDiff / 2.0) {
                    allLong = false;
                }
            }
            if (allLong && allInteger) {
                throw new InternalError();
            }
            if (allLong || allInteger) {
                long first = ((Number)keys[firstUse]).longValue();
                if (allInteger) {
                    if (first > 0L) {
                        oos.write(32);
                    } else {
                        oos.write(64);
                    }
                } else if (allLong) {
                    if (first > 0L) {
                        oos.write(96);
                    } else {
                        oos.write(128);
                    }
                } else {
                    throw new InternalError();
                }
                LongPacker.packLong(oos, Math.abs(first));
                for (int i6 = firstUse + 1; i6 < 32; ++i6) {
                    if (keys[i6] == null) {
                        LongPacker.packLong(oos, 0L);
                        continue;
                    }
                    long v = ((Number)keys[i6]).longValue();
                    if (v <= first) {
                        throw new InternalError("not ordered");
                    }
                    LongPacker.packLong(oos, v - first);
                    first = v;
                }
                return;
            }
            boolean allString = true;
            for (i = firstUse; i < 32; ++i) {
                if (keys[i] == null || keys[i].getClass() == String.class) continue;
                allString = false;
                break;
            }
            if (allString) {
                oos.write(160);
                byte[] previous = null;
                for (int i7 = firstUse; i7 < 32; ++i7) {
                    if (keys[i7] == null) {
                        BTreeNode.leadingValuePackWrite(oos, null, previous, 0);
                        continue;
                    }
                    byte[] b = ((String)keys[i7]).getBytes();
                    BTreeNode.leadingValuePackWrite(oos, b, previous, 0);
                    previous = b;
                }
                return;
            }
        }
        oos.write(192);
        if (this._btree.keySerializer == null || this._btree.keySerializer == this._btree.getRecordManager().defaultSerializer()) {
            for (i2 = firstUse; i2 < 32; ++i2) {
                this._btree.getRecordManager().defaultSerializer().serialize(oos, keys[i2]);
            }
            return;
        }
        Serializer ser = this._btree.keySerializer;
        byte[] previous = null;
        DataInputOutput out3 = new DataInputOutput();
        for (i = firstUse; i < 32; ++i) {
            if (keys[i] == null) {
                BTreeNode.leadingValuePackWrite(oos, null, previous, 0);
                continue;
            }
            out3.reset();
            ser.serialize(out3, keys[i]);
            byte[] b = out3.toByteArray();
            BTreeNode.leadingValuePackWrite(oos, b, previous, 0);
            previous = b;
        }
    }

    public void defrag(DBStore r1, DBStore r2) throws IOException {
        if (this._children != null) {
            for (long child : this._children) {
                if (child == 0L) continue;
                byte[] data = r1.fetchRaw(child);
                r2.forceInsert(child, data);
                Object t = this.deserialize(new DataInputOutput(data));
                ((BTreeNode)t)._btree = this._btree;
                ((BTreeNode)t).defrag(r1, r2);
            }
        }
    }

    void dumpChildNodeRecIDs(List out, int height) throws IOException {
        if (--height > 0) {
            for (byte i = this._first; i < 32; i = (byte)(i + 1)) {
                if (this._children[i] == 0L) continue;
                BTreeNode<K, V> child = this.loadNode(this._children[i]);
                out.add(new Long(child._recid));
                child.dumpChildNodeRecIDs(out, height);
            }
        }
    }

    static byte[] leadingValuePackRead(DataInput in, byte[] previous, int ignoreLeadingCount) throws IOException {
        int len = LongPacker.unpackInt(in) - 1;
        if (len == -1) {
            return null;
        }
        int actualCommon = LongPacker.unpackInt(in);
        byte[] buf = new byte[len];
        if (previous == null) {
            actualCommon = 0;
        }
        if (actualCommon > 0) {
            in.readFully(buf, 0, ignoreLeadingCount);
            System.arraycopy(previous, ignoreLeadingCount, buf, ignoreLeadingCount, actualCommon - ignoreLeadingCount);
        }
        in.readFully(buf, actualCommon, len - actualCommon);
        return buf;
    }

    static void leadingValuePackWrite(DataOutput out, byte[] buf, byte[] previous, int ignoreLeadingCount) throws IOException {
        if (buf == null) {
            LongPacker.packInt(out, 0);
            return;
        }
        int actualCommon = ignoreLeadingCount;
        if (previous != null) {
            int maxCommon;
            int n = maxCommon = buf.length > previous.length ? previous.length : buf.length;
            if (maxCommon > Short.MAX_VALUE) {
                maxCommon = Short.MAX_VALUE;
            }
            while (actualCommon < maxCommon && buf[actualCommon] == previous[actualCommon]) {
                ++actualCommon;
            }
        }
        LongPacker.packInt(out, buf.length + 1);
        LongPacker.packInt(out, actualCommon);
        out.write(buf, 0, ignoreLeadingCount);
        out.write(buf, actualCommon, buf.length - actualCommon);
    }

    BTreeNode<K, V> loadLastChildNode() throws IOException {
        return this.loadNode(this._children[31]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Browser<K, V>
    implements BTree.BTreeTupleBrowser<K, V> {
        private BTreeNode<K, V> _node;
        private byte _index;
        private int expectedModCount;

        Browser(BTreeNode<K, V> node, byte index) {
            this._node = node;
            this._index = index;
            this.expectedModCount = node._btree.modCount;
        }

        @Override
        public boolean getNext(BTree.BTreeTuple<K, V> tuple) throws IOException {
            if (this.expectedModCount != this._node._btree.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this._node == null) {
                return false;
            }
            if (this._index < 32) {
                if (this._node._keys[this._index] == null) {
                    return false;
                }
            } else if (this._node._next != 0L) {
                this._node = ((BTreeNode)this._node).loadNode(this._node._next);
                this._index = this._node._first;
            }
            tuple.key = this._node._keys[this._index];
            tuple.value = this._node._values[this._index] instanceof BTreeLazyRecord ? ((BTreeLazyRecord)this._node._values[this._index]).get() : this._node._values[this._index];
            this._index = (byte)(this._index + 1);
            return true;
        }

        @Override
        public boolean getPrevious(BTree.BTreeTuple<K, V> tuple) throws IOException {
            if (this.expectedModCount != this._node._btree.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this._node == null) {
                throw new InternalError();
            }
            if (this._index == this._node._first) {
                if (this._node._previous != 0L) {
                    this._node = ((BTreeNode)this._node).loadNode(this._node._previous);
                    this._index = (byte)32;
                } else {
                    return false;
                }
            }
            this._index = (byte)(this._index - 1);
            tuple.key = this._node._keys[this._index];
            tuple.value = this._node._values[this._index] instanceof BTreeLazyRecord ? ((BTreeLazyRecord)this._node._values[this._index]).get() : this._node._values[this._index];
            return true;
        }

        @Override
        public void remove(K key) throws IOException {
            if (this.expectedModCount != this._node._btree.modCount) {
                throw new ConcurrentModificationException();
            }
            this._node._btree.remove(key);
            ++this.expectedModCount;
            BTree.BTreeTupleBrowser<Object, Object> b = this._node._btree.browse(key, true);
            if (b.getNext(new BTree.BTreeTuple<Object, Object>(null, null))) {
                Browser b2 = (Browser)b;
                this._node = b2._node;
                this._index = b2._index;
            } else {
                this._node = null;
                this._index = (byte)-1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RemoveResult<K, V> {
        boolean _underflow;
        V _value;

        RemoveResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class InsertResult<K, V> {
        BTreeNode<K, V> _overflow;
        V _existing;

        InsertResult() {
        }
    }
}

