/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.apache.jdbm.BTreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    final BTreeMap<E, Object> map;

    BTreeSet(BTreeMap<E, Object> map) {
        this.map = map;
    }

    @Override
    public boolean add(E object) {
        return this.map.put(object, "") == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.map.comparator();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public E lower(E e) {
        return this.map.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.map.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.map.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.map.higherKey(e);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> e = this.map.pollFirstEntry();
        return e != null ? (E)e.getKey() : null;
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> e = this.map.pollLastEntry();
        return e != null ? (E)e.getKey() : null;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<Map.Entry<E, Object>> iter = this.map.entrySet().iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                Map.Entry e = (Map.Entry)iter.next();
                return e != null ? (Object)e.getKey() : null;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.map.descendingKeySet();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.map.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.map.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive).navigableKeySet();
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return this.map.headMap((Object)toElement, inclusive).navigableKeySet();
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.map.tailMap((Object)fromElement, inclusive).navigableKeySet();
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public E first() {
        return this.map.firstKey();
    }

    @Override
    public E last() {
        return this.map.lastKey();
    }

    @Override
    public SortedSet<E> subSet(E start, E end) {
        int compare;
        Comparator<E> c = this.map.comparator();
        int n = compare = c == null ? ((Comparable)start).compareTo(end) : c.compare(start, end);
        if (compare <= 0) {
            return new BTreeSet<E>((BTreeMap)this.map.subMap((Object)start, true, (Object)end, false));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public SortedSet<E> headSet(E end) {
        Comparator<E> c = this.map.comparator();
        if (c == null) {
            ((Comparable)end).compareTo(end);
        } else {
            c.compare(end, end);
        }
        return new BTreeSet<E>((BTreeMap)this.map.headMap((Object)end, false));
    }

    @Override
    public SortedSet<E> tailSet(E start) {
        Comparator<E> c = this.map.comparator();
        if (c == null) {
            ((Comparable)start).compareTo(start);
        } else {
            c.compare(start, start);
        }
        return new BTreeSet<E>((BTreeMap)this.map.tailMap((Object)start, true));
    }
}

