/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.jdbm.BTree;
import org.apache.jdbm.BTreeMap;
import org.apache.jdbm.BTreeSet;
import org.apache.jdbm.DB;
import org.apache.jdbm.HTree;
import org.apache.jdbm.HTreeDirectory;
import org.apache.jdbm.HTreeSet;
import org.apache.jdbm.LinkedList2;
import org.apache.jdbm.LongPacker;
import org.apache.jdbm.SerialClassInfo;
import org.apache.jdbm.Serialization;
import org.apache.jdbm.Serializer;
import org.apache.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DBAbstract
implements DB {
    static final byte NAME_DIRECTORY_ROOT = 0;
    static final byte STORE_VERSION_NUMBER_ROOT = 1;
    static final byte SERIAL_CLASS_INFO_RECID_ROOT = 2;
    private final Map<String, WeakReference<Object>> collections = new HashMap<String, WeakReference<Object>>();
    final Serializer<Serialization> defaultSerializationSerializer = new Serializer<Serialization>(){

        @Override
        public void serialize(DataOutput out, Serialization obj) throws IOException {
            LongPacker.packLong(out, obj.serialClassInfoRecid);
            SerialClassInfo.serializer.serialize(out, obj.registered);
        }

        @Override
        public Serialization deserialize(DataInput in) throws IOException, ClassNotFoundException {
            long recid = LongPacker.unpackLong(in);
            ArrayList<SerialClassInfo.ClassInfo> classes = SerialClassInfo.serializer.deserialize(in);
            return new Serialization(DBAbstract.this, recid, classes);
        }
    };
    ShutdownCloseThread shutdownCloseThread = null;

    DBAbstract() {
    }

    abstract <A> long insert(A var1, Serializer<A> var2, boolean var3) throws IOException;

    abstract void delete(long var1) throws IOException;

    abstract <A> void update(long var1, A var3, Serializer<A> var4) throws IOException;

    abstract <A> A fetch(long var1, Serializer<A> var3) throws IOException;

    abstract <A> A fetch(long var1, Serializer<A> var3, boolean var4) throws IOException;

    public long insert(Object obj) throws IOException {
        return this.insert(obj, this.defaultSerializer(), false);
    }

    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, this.defaultSerializer());
    }

    public synchronized <A> A fetch(long recid) throws IOException {
        return this.fetch(recid, this.defaultSerializer());
    }

    @Override
    public synchronized <K, V> ConcurrentMap<K, V> getHashMap(String name) {
        Object o = this.getCollectionInstance(name);
        if (o != null) {
            return (ConcurrentMap)o;
        }
        try {
            long recid = this.getNamedObject(name);
            if (recid == 0L) {
                return null;
            }
            HTree tree = (HTree)this.fetch(recid);
            tree.setPersistenceContext(this);
            if (!tree.hasValues()) {
                throw new ClassCastException("HashSet is not HashMap");
            }
            this.collections.put(name, new WeakReference<HTree>(tree));
            return tree;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K, V> ConcurrentMap<K, V> createHashMap(String name) {
        return this.createHashMap(name, null, null);
    }

    @Override
    public synchronized <K, V> ConcurrentMap<K, V> createHashMap(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        try {
            this.assertNameNotExist(name);
            HTree<K, V> tree = new HTree<K, V>(this, keySerializer, valueSerializer, true);
            long recid = this.insert(tree);
            this.setNamedObject(name, recid);
            this.collections.put(name, new WeakReference<HTree<K, V>>(tree));
            return tree;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> Set<K> getHashSet(String name) {
        Object o = this.getCollectionInstance(name);
        if (o != null) {
            return (Set)o;
        }
        try {
            long recid = this.getNamedObject(name);
            if (recid == 0L) {
                return null;
            }
            HTree tree = (HTree)this.fetch(recid);
            tree.setPersistenceContext(this);
            if (tree.hasValues()) {
                throw new ClassCastException("HashMap is not HashSet");
            }
            HTreeSet ret = new HTreeSet(tree);
            this.collections.put(name, new WeakReference(ret));
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> Set<K> createHashSet(String name) {
        return this.createHashSet(name, null);
    }

    @Override
    public synchronized <K> Set<K> createHashSet(String name, Serializer<K> keySerializer) {
        try {
            this.assertNameNotExist(name);
            HTree tree = new HTree(this, keySerializer, null, false);
            long recid = this.insert(tree);
            this.setNamedObject(name, recid);
            HTreeSet ret = new HTreeSet(tree);
            this.collections.put(name, new WeakReference(ret));
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K, V> ConcurrentNavigableMap<K, V> getTreeMap(String name) {
        Object o = this.getCollectionInstance(name);
        if (o != null) {
            return (ConcurrentNavigableMap)o;
        }
        try {
            long recid = this.getNamedObject(name);
            if (recid == 0L) {
                return null;
            }
            BTree t = BTree.load(this, recid);
            if (!t.hasValues()) {
                throw new ClassCastException("TreeSet is not TreeMap");
            }
            BTreeMap ret = new BTreeMap(t, false);
            this.collections.put(name, new WeakReference(ret));
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public synchronized <K extends Comparable, V> ConcurrentNavigableMap<K, V> createTreeMap(String name) {
        return this.createTreeMap(name, null, null, null);
    }

    @Override
    public synchronized <K, V> ConcurrentNavigableMap<K, V> createTreeMap(String name, Comparator<K> keyComparator, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        try {
            this.assertNameNotExist(name);
            BTree<K, V> tree = BTree.createInstance(this, keyComparator, keySerializer, valueSerializer, true);
            this.setNamedObject(name, tree.getRecid());
            BTreeMap<K, V> ret = new BTreeMap<K, V>(tree, false);
            this.collections.put(name, new WeakReference<BTreeMap<K, V>>(ret));
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> NavigableSet<K> getTreeSet(String name) {
        Object o = this.getCollectionInstance(name);
        if (o != null) {
            return (NavigableSet)o;
        }
        try {
            long recid = this.getNamedObject(name);
            if (recid == 0L) {
                return null;
            }
            BTree t = BTree.load(this, recid);
            if (t.hasValues()) {
                throw new ClassCastException("TreeMap is not TreeSet");
            }
            BTreeSet ret = new BTreeSet(new BTreeMap(t, false));
            this.collections.put(name, new WeakReference(ret));
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> NavigableSet<K> createTreeSet(String name) {
        return this.createTreeSet(name, null, null);
    }

    @Override
    public synchronized <K> NavigableSet<K> createTreeSet(String name, Comparator<K> keyComparator, Serializer<K> keySerializer) {
        try {
            this.assertNameNotExist(name);
            BTree tree = BTree.createInstance(this, keyComparator, keySerializer, null, false);
            this.setNamedObject(name, tree.getRecid());
            BTreeSet<K> ret = new BTreeSet<K>(new BTreeMap(tree, false));
            this.collections.put(name, new WeakReference<BTreeSet<K>>(ret));
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> List<K> createLinkedList(String name) {
        return this.createLinkedList(name, null);
    }

    @Override
    public synchronized <K> List<K> createLinkedList(String name, Serializer<K> serializer) {
        try {
            this.assertNameNotExist(name);
            LinkedList2<K> list = new LinkedList2<K>(this, serializer);
            long recid = this.insert(list);
            this.setNamedObject(name, recid);
            this.collections.put(name, new WeakReference<LinkedList2<K>>(list));
            return list;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> List<K> getLinkedList(String name) {
        Object o = this.getCollectionInstance(name);
        if (o != null) {
            return (List)o;
        }
        try {
            long recid = this.getNamedObject(name);
            if (recid == 0L) {
                return null;
            }
            LinkedList2 list = (LinkedList2)this.fetch(recid);
            list.setPersistenceContext(this);
            this.collections.put(name, new WeakReference<LinkedList2>(list));
            return list;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private synchronized Object getCollectionInstance(String name) {
        WeakReference<Object> ref = this.collections.get(name);
        if (ref == null) {
            return null;
        }
        Object o = ref.get();
        if (o != null) {
            return o;
        }
        this.collections.remove(name);
        return null;
    }

    private void assertNameNotExist(String name) throws IOException {
        if (this.getNamedObject(name) != 0L) {
            throw new IllegalArgumentException("Object with name '" + name + "' already exists");
        }
    }

    protected long getNamedObject(String name) throws IOException {
        long nameDirectory_recid = this.getRoot((byte)0);
        if (nameDirectory_recid == 0L) {
            return 0L;
        }
        HTree m = (HTree)this.fetch(nameDirectory_recid);
        Long res = (Long)m.get(name);
        if (res == null) {
            return 0L;
        }
        return res;
    }

    protected void setNamedObject(String name, long recid) throws IOException {
        long nameDirectory_recid = this.getRoot((byte)0);
        HTree<String, Long> m = null;
        if (nameDirectory_recid == 0L) {
            m = new HTree<String, Long>(this, null, null, true);
            nameDirectory_recid = this.insert(m);
            this.setRoot((byte)0, nameDirectory_recid);
        } else {
            m = (HTree<String, Long>)this.fetch(nameDirectory_recid);
        }
        m.put(name, recid);
    }

    @Override
    public Map<String, Object> getCollections() {
        try {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            long nameDirectory_recid = this.getRoot((byte)0);
            if (nameDirectory_recid == 0L) {
                return ret;
            }
            HTree m = (HTree)this.fetch(nameDirectory_recid);
            for (Map.Entry e : m.entrySet()) {
                Object o = this.fetch((Long)e.getValue());
                if (o instanceof BTree) {
                    o = ((BTree)o).hasValues ? this.getTreeMap((String)e.getKey()) : this.getTreeSet((String)e.getKey());
                } else if (o instanceof HTree) {
                    o = ((HTree)o).hasValues ? this.getHashMap((String)e.getKey()) : this.getHashSet((String)e.getKey());
                }
                ret.put((String)e.getKey(), o);
            }
            return Collections.unmodifiableMap(ret);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void deleteCollection(String name) {
        try {
            long nameDirectory_recid = this.getRoot((byte)0);
            if (nameDirectory_recid == 0L) {
                throw new IOException("Collection not found");
            }
            HTree dir = (HTree)this.fetch(nameDirectory_recid);
            Long recid = (Long)dir.get(name);
            if (recid == null) {
                throw new IOException("Collection not found");
            }
            Object o = this.fetch(recid);
            if (o instanceof LinkedList2) {
                LinkedList2 l = (LinkedList2)o;
                l.clear();
                this.delete(l.rootRecid);
            } else if (o instanceof BTree) {
                ((BTree)o).clear();
            } else if (o instanceof HTree) {
                HTree t = (HTree)o;
                t.clear();
                HTreeDirectory n = (HTreeDirectory)this.fetch(t.rootRecid, t.SERIALIZER);
                n.deleteAllChildren();
                this.delete(t.rootRecid);
            } else {
                throw new InternalError("unknown collection type: " + (o == null ? null : o.getClass()));
            }
            this.delete(recid);
            this.collections.remove(name);
            dir.remove(name);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public synchronized Serializer defaultSerializer() {
        try {
            long serialClassInfoRecid = this.getRoot((byte)2);
            if (serialClassInfoRecid == 0L) {
                serialClassInfoRecid = this.insert(null, Utils.NULL_SERIALIZER, false);
                Serialization ser = new Serialization(this, serialClassInfoRecid, new ArrayList<SerialClassInfo.ClassInfo>());
                this.update(serialClassInfoRecid, ser, this.defaultSerializationSerializer);
                this.setRoot((byte)2, serialClassInfoRecid);
                return ser;
            }
            return this.fetch(serialClassInfoRecid, this.defaultSerializationSerializer);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected final void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("db was closed");
        }
    }

    protected abstract void setRoot(byte var1, long var2);

    protected abstract long getRoot(byte var1);

    @Override
    public long collectionSize(Object collection) {
        if (collection instanceof BTreeMap) {
            BTreeMap t = (BTreeMap)collection;
            if (t.fromKey != null || t.toKey != null) {
                throw new IllegalArgumentException("collectionSize does not work on BTree submap");
            }
            return t.tree._entries;
        }
        if (collection instanceof HTree) {
            return ((HTree)collection).getRoot().size;
        }
        if (collection instanceof HTreeSet) {
            return this.collectionSize(((HTreeSet)collection).map);
        }
        if (collection instanceof BTreeSet) {
            return this.collectionSize(((BTreeSet)collection).map);
        }
        if (collection instanceof LinkedList2) {
            return ((LinkedList2)collection).getRoot().size;
        }
        throw new IllegalArgumentException("Not JDBM collection");
    }

    void addShutdownHook() {
        if (this.shutdownCloseThread != null) {
            this.shutdownCloseThread = new ShutdownCloseThread();
            Runtime.getRuntime().addShutdownHook(this.shutdownCloseThread);
        }
    }

    @Override
    public void close() {
        if (this.shutdownCloseThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownCloseThread);
            this.shutdownCloseThread.dbToClose = null;
            this.shutdownCloseThread = null;
        }
    }

    private static class ShutdownCloseThread
    extends Thread {
        DBAbstract dbToClose = null;

        ShutdownCloseThread() {
            super("JDBM shutdown");
        }

        public void run() {
            if (this.dbToClose != null && !this.dbToClose.isClosed()) {
                this.dbToClose.shutdownCloseThread = null;
                this.dbToClose.close();
            }
        }
    }
}

