/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import org.apache.jdbm.DBCache;
import org.apache.jdbm.LongHashMap;
import org.apache.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCacheRef
extends DBCache {
    private static final boolean debug = false;
    protected LongHashMap _softHash;
    protected ReferenceQueue<ReferenceCacheEntry> _refQueue;
    protected Thread _softRefThread;
    protected static AtomicInteger threadCounter = new AtomicInteger(0);
    protected int insertCounter = 0;
    private final boolean _autoClearReferenceCacheOnLowMem;
    private final byte _cacheType;

    public DBCacheRef(String filename, boolean readonly, boolean transactionDisabled, Cipher cipherIn, Cipher cipherOut, boolean useRandomAccessFile, boolean deleteFilesAfterClose, byte cacheType, boolean cacheAutoClearOnLowMem, boolean lockingDisabled) {
        super(filename, readonly, transactionDisabled, cipherIn, cipherOut, useRandomAccessFile, deleteFilesAfterClose, lockingDisabled);
        this._cacheType = cacheType;
        this._autoClearReferenceCacheOnLowMem = cacheAutoClearOnLowMem;
        this._softHash = new LongHashMap();
        this._refQueue = new ReferenceQueue();
        this._softRefThread = new Thread((Runnable)new SoftRunnable(this, this._refQueue), "JDBM Soft Cache Disposer " + threadCounter.incrementAndGet());
        this._softRefThread.setDaemon(true);
        this._softRefThread.start();
    }

    void clearCacheIfLowOnMem() {
        this.insertCounter = 0;
        if (!this._autoClearReferenceCacheOnLowMem) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        long max = r.maxMemory();
        if (max == Long.MAX_VALUE) {
            return;
        }
        double free = r.freeMemory();
        double total = r.totalMemory();
        if ((free += (double)max - total) < 1.0E7 || free * 4.0 < (double)max) {
            this.clearCache();
        }
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer, boolean disableCache) throws IOException {
        if (disableCache) {
            return super.fetch(recid, serializer, disableCache);
        }
        return this.fetch(recid, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkNotClosed();
        super.delete(recid);
        LongHashMap longHashMap = this._hashDirties;
        synchronized (longHashMap) {
            this._hashDirties.remove(recid);
        }
        longHashMap = this._softHash;
        synchronized (longHashMap) {
            Object e = this._softHash.remove(recid);
            if (e != null && e instanceof ReferenceCacheEntry) {
                ((ReferenceCacheEntry)e).clear();
            }
        }
        if (this.needsAutoCommit()) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> void update(long recid, A obj, Serializer<A> serializer) throws IOException {
        Object e;
        this.checkNotClosed();
        LongHashMap longHashMap = this._softHash;
        synchronized (longHashMap) {
            e = this._softHash.remove(recid);
            if (e != null && e instanceof ReferenceCacheEntry) {
                ((ReferenceCacheEntry)e).clear();
            }
        }
        longHashMap = this._hashDirties;
        synchronized (longHashMap) {
            e = new DBCache.DirtyCacheEntry();
            ((DBCache.DirtyCacheEntry)e)._recid = recid;
            ((DBCache.DirtyCacheEntry)e)._obj = obj;
            ((DBCache.DirtyCacheEntry)e)._serializer = serializer;
            this._hashDirties.put(recid, e);
        }
        if (this.needsAutoCommit()) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer) throws IOException {
        this.checkNotClosed();
        LongHashMap longHashMap = this._softHash;
        synchronized (longHashMap) {
            Object e = this._softHash.get(recid);
            if (e != null) {
                if (e instanceof ReferenceCacheEntry) {
                    e = ((ReferenceCacheEntry)e).get();
                }
                if (e != null) {
                    return (A)e;
                }
            }
        }
        longHashMap = this._hashDirties;
        synchronized (longHashMap) {
            DBCache.DirtyCacheEntry e2 = (DBCache.DirtyCacheEntry)this._hashDirties.get(recid);
            if (e2 != null) {
                return (A)e2._obj;
            }
        }
        A value = super.fetch(recid, serializer);
        if (this.needsAutoCommit()) {
            this.commit();
        }
        LongHashMap longHashMap2 = this._softHash;
        synchronized (longHashMap2) {
            if (this._cacheType == 4) {
                this._softHash.put(recid, new SoftCacheEntry(recid, value, this._refQueue));
            } else if (this._cacheType == 3) {
                this._softHash.put(recid, new WeakCacheEntry(recid, value, this._refQueue));
            } else {
                this._softHash.put(recid, value);
            }
        }
        return value;
    }

    @Override
    public synchronized void close() {
        this.checkNotClosed();
        this.updateCacheEntries();
        super.close();
        this._softHash = null;
        this._softRefThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() {
        this.checkNotClosed();
        LongHashMap longHashMap = this._softHash;
        synchronized (longHashMap) {
            Iterator iter = this._softHash.valuesIterator();
            while (iter.hasNext()) {
                ReferenceCacheEntry e = (ReferenceCacheEntry)iter.next();
                e.clear();
            }
            this._softHash.clear();
        }
        super.rollback();
    }

    protected boolean isCacheEntryDirty(DBCache.DirtyCacheEntry entry) {
        return this._hashDirties.get(entry._recid) != null;
    }

    protected void setCacheEntryDirty(DBCache.DirtyCacheEntry entry, boolean dirty) {
        if (dirty) {
            this._hashDirties.put(entry._recid, entry);
        } else {
            this._hashDirties.remove(entry._recid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        LongHashMap longHashMap = this._softHash;
        synchronized (longHashMap) {
            if (this._cacheType != 5) {
                Iterator iter = this._softHash.valuesIterator();
                while (iter.hasNext()) {
                    ReferenceCacheEntry e = (ReferenceCacheEntry)iter.next();
                    e.clear();
                }
            }
            this._softHash.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SoftRunnable
    implements Runnable {
        private ReferenceQueue<ReferenceCacheEntry> entryQueue;
        private WeakReference<DBCacheRef> db2;

        public SoftRunnable(DBCacheRef db, ReferenceQueue<ReferenceCacheEntry> entryQueue) {
            this.db2 = new WeakReference<DBCacheRef>(db);
            this.entryQueue = entryQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        ReferenceCacheEntry e = (ReferenceCacheEntry)((Object)this.entryQueue.remove(10000L));
                        DBCacheRef db = (DBCacheRef)this.db2.get();
                        if (db == null) {
                            return;
                        }
                        if (e != null) {
                            LongHashMap longHashMap = db._softHash;
                            synchronized (longHashMap) {
                                boolean counter = false;
                                while (e != null) {
                                    db._softHash.remove(e.getRecid());
                                    e = (SoftCacheEntry)this.entryQueue.poll();
                                }
                                continue block6;
                            }
                        }
                        db.clearCacheIfLowOnMem();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static final class WeakCacheEntry
    extends WeakReference
    implements ReferenceCacheEntry {
        protected final long _recid;

        public long getRecid() {
            return this._recid;
        }

        WeakCacheEntry(long recid, Object obj, ReferenceQueue queue) {
            super(obj, queue);
            this._recid = recid;
        }
    }

    static final class SoftCacheEntry
    extends SoftReference
    implements ReferenceCacheEntry {
        protected final long _recid;

        public long getRecid() {
            return this._recid;
        }

        SoftCacheEntry(long recid, Object obj, ReferenceQueue queue) {
            super(obj, queue);
            this._recid = recid;
        }
    }

    static interface ReferenceCacheEntry {
        public long getRecid();

        public void clear();

        public Object get();
    }
}

