/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import org.apache.jdbm.BTree;
import org.apache.jdbm.DBAbstract;
import org.apache.jdbm.DataInputOutput;
import org.apache.jdbm.HTree;
import org.apache.jdbm.LinkedList2;
import org.apache.jdbm.LogicalRowIdManager;
import org.apache.jdbm.LongHashMap;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.PageIo;
import org.apache.jdbm.PageManager;
import org.apache.jdbm.PhysicalRowIdManager;
import org.apache.jdbm.RecordHeader;
import org.apache.jdbm.Serializer;
import org.apache.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBStore
extends DBAbstract {
    static final long STORE_FORMAT_VERSION = 1L;
    private PageFile _file;
    private PageManager _pageman;
    private PhysicalRowIdManager _physMgr;
    private final boolean readonly;
    final boolean transactionsDisabled;
    private final boolean deleteFilesAfterClose;
    private static final int AUTOCOMMIT_AFTER_N_PAGES = 5120;
    boolean commitInProgress = false;
    private Cipher cipherOut;
    private Cipher cipherIn;
    private boolean useRandomAccessFile;
    private boolean lockingDisabled;
    private LogicalRowIdManager _logicMgr;
    public static final boolean DEBUG = false;
    static final long PREALOCATE_PHYS_RECID = -32768L;
    static final Object PREALOCATE_OBJ = new Object();
    private final DataInputOutput buffer = new DataInputOutput();
    private boolean bufferInUse = false;
    private final String _filename;
    private static int COMPRESS_RECID_PAGE_SHIFT = Integer.MIN_VALUE;
    private static final long COMPRESS_RECID_OFFSET_MASK;

    void checkCanWrite() {
        if (this.readonly) {
            throw new UnsupportedOperationException("Could not write, store is opened as read-only");
        }
    }

    public DBStore(String filename, boolean readonly, boolean transactionDisabled, boolean lockingDisabled) throws IOException {
        this(filename, readonly, transactionDisabled, null, null, false, false, false);
    }

    public DBStore(String filename, boolean readonly, boolean transactionDisabled, Cipher cipherIn, Cipher cipherOut, boolean useRandomAccessFile, boolean deleteFilesAfterClose, boolean lockingDisabled) {
        this._filename = filename;
        this.readonly = readonly;
        this.transactionsDisabled = transactionDisabled;
        this.cipherIn = cipherIn;
        this.cipherOut = cipherOut;
        this.useRandomAccessFile = useRandomAccessFile;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.lockingDisabled = lockingDisabled;
        this.reopen();
    }

    private void reopen() {
        try {
            this._file = new PageFile(this._filename, this.readonly, this.transactionsDisabled, this.cipherIn, this.cipherOut, this.useRandomAccessFile, this.lockingDisabled);
            this._pageman = new PageManager(this._file);
            this._physMgr = new PhysicalRowIdManager(this._file, this._pageman);
            this._logicMgr = new LogicalRowIdManager(this._file, this._pageman);
            long versionNumber = this.getRoot((byte)1);
            if (versionNumber > 1L) {
                throw new IOException("Unsupported version of store. Please update JDBM. Minimal supported ver:1, store ver:" + versionNumber);
            }
            if (!this.readonly) {
                this.setRoot((byte)1, 1L);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized void close() {
        this.checkNotClosed();
        try {
            super.close();
            this._pageman.close();
            this._file.close();
            if (this.deleteFilesAfterClose) {
                this._file.storage.deleteAllFiles();
            }
            this._pageman = null;
            this._file = null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this._pageman == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> long insert(A obj, Serializer<A> serializer, boolean disableCache) throws IOException {
        this.checkNotClosed();
        this.checkCanWrite();
        if (this.needsAutoCommit()) {
            this.commit();
        }
        if (this.bufferInUse) {
            DataInputOutput buffer2 = new DataInputOutput();
            return this.insert2(obj, serializer, buffer2);
        }
        try {
            this.bufferInUse = true;
            long l = this.insert2(obj, serializer, this.buffer);
            return l;
        }
        finally {
            this.bufferInUse = false;
        }
    }

    boolean needsAutoCommit() {
        return this.transactionsDisabled && !this.commitInProgress && this._file.getDirtyPageCount() >= 5120;
    }

    private <A> long insert2(A obj, Serializer<A> serializer, DataInputOutput buf) throws IOException {
        long physRowId;
        buf.reset();
        if (obj == PREALOCATE_OBJ) {
            physRowId = -32768L;
        } else {
            serializer.serialize(buf, obj);
            if (buf.getPos() > 0x7F7FFF) {
                throw new IllegalArgumentException("Too big record. JDBM only supports record size up to: 8355839 bytes. Record size was: " + buf.getPos());
            }
            physRowId = this._physMgr.insert(buf.getBuf(), 0, buf.getPos());
        }
        long recid = this._logicMgr.insert(physRowId);
        return DBStore.compressRecid(recid);
    }

    @Override
    public synchronized void delete(long logRowId) throws IOException {
        this.checkNotClosed();
        this.checkCanWrite();
        if (logRowId <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + logRowId);
        }
        if (this.needsAutoCommit()) {
            this.commit();
        }
        logRowId = DBStore.decompressRecid(logRowId);
        long physRowId = this._logicMgr.fetch(logRowId);
        this._logicMgr.delete(logRowId);
        if (physRowId != -32768L) {
            this._physMgr.free(physRowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> void update(long recid, A obj, Serializer<A> serializer) throws IOException {
        this.checkNotClosed();
        this.checkCanWrite();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        if (this.needsAutoCommit()) {
            this.commit();
        }
        if (this.bufferInUse) {
            DataInputOutput buffer2 = new DataInputOutput();
            this.update2(recid, obj, serializer, buffer2);
            return;
        }
        try {
            this.bufferInUse = true;
            this.update2(recid, obj, serializer, this.buffer);
        }
        finally {
            this.bufferInUse = false;
        }
    }

    private <A> void update2(long logRecid, A obj, Serializer<A> serializer, DataInputOutput buf) throws IOException {
        long physRecid = this._logicMgr.fetch(logRecid = DBStore.decompressRecid(logRecid));
        if (physRecid == 0L) {
            throw new IOException("Can not update, recid does not exist: " + logRecid);
        }
        buf.reset();
        serializer.serialize(buf, obj);
        long newRecid = physRecid != -32768L ? this._physMgr.update(physRecid, buf.getBuf(), 0, buf.getPos()) : this._physMgr.insert(buf.getBuf(), 0, buf.getPos());
        this._logicMgr.update(logRecid, newRecid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer) throws IOException {
        this.checkNotClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        if (this.bufferInUse) {
            DataInputOutput buffer2 = new DataInputOutput();
            return this.fetch2(recid, serializer, buffer2);
        }
        try {
            this.bufferInUse = true;
            A a = this.fetch2(recid, serializer, this.buffer);
            return a;
        }
        finally {
            this.bufferInUse = false;
        }
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer, boolean disableCache) throws IOException {
        return this.fetch(recid, serializer);
    }

    private <A> A fetch2(long recid, Serializer<A> serializer, DataInputOutput buf) throws IOException {
        recid = DBStore.decompressRecid(recid);
        buf.reset();
        long physLocation = this._logicMgr.fetch(recid);
        if (physLocation == 0L) {
            return null;
        }
        if (physLocation == -32768L) {
            throw new InternalError("cache should prevent this!");
        }
        this._physMgr.fetch(buf, physLocation);
        buf.resetForReading();
        try {
            return serializer.deserialize(buf);
        }
        catch (ClassNotFoundException e) {
            throw new IOError(e);
        }
    }

    byte[] fetchRaw(long recid) throws IOException {
        long physLocation = this._logicMgr.fetch(recid = DBStore.decompressRecid(recid));
        if (physLocation == 0L) {
            return null;
        }
        DataInputOutput i = new DataInputOutput();
        this._physMgr.fetch(i, physLocation);
        return i.toByteArray();
    }

    @Override
    public synchronized long getRoot(byte id) {
        this.checkNotClosed();
        return this._pageman.getFileHeader().fileHeaderGetRoot(id);
    }

    @Override
    public synchronized void setRoot(byte id, long rowid) {
        this.checkNotClosed();
        this.checkCanWrite();
        this._pageman.getFileHeader().fileHeaderSetRoot(id, rowid);
    }

    @Override
    public synchronized void commit() {
        try {
            this.commitInProgress = true;
            this.checkNotClosed();
            this.checkCanWrite();
            this._physMgr.commit();
            this._logicMgr.commit();
            this._pageman.commit();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.commitInProgress = false;
        }
    }

    @Override
    public synchronized void rollback() {
        if (this.transactionsDisabled) {
            throw new IllegalAccessError("Transactions are disabled, can not rollback");
        }
        try {
            this.checkNotClosed();
            this._physMgr.rollback();
            this._logicMgr.rollback();
            this._pageman.rollback();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void copyToZip(String zipFile) {
        try {
            String file;
            PageIo page;
            String zip = zipFile;
            String zip2 = "db";
            ZipOutputStream z = new ZipOutputStream(new FileOutputStream(zip));
            String file2 = zip2 + 0;
            z.putNextEntry(new ZipEntry(file2));
            z.write(Utils.encrypt(this.cipherIn, this._pageman.getHeaderBufData()));
            z.closeEntry();
            long pageid = this._pageman.getFirst((short)2);
            while (pageid != 0L) {
                page = this._file.get(pageid);
                file = zip2 + pageid;
                z.putNextEntry(new ZipEntry(file));
                z.write(Utils.encrypt(this.cipherIn, page.getData()));
                z.closeEntry();
                this._file.release(page);
                pageid = this._pageman.getNext(pageid);
            }
            pageid = this._pageman.getFirst((short)3);
            while (pageid != 0L) {
                page = this._file.get(pageid);
                file = zip2 + pageid;
                z.putNextEntry(new ZipEntry(file));
                z.write(Utils.encrypt(this.cipherIn, page.getData()));
                z.closeEntry();
                this._file.release(page);
                pageid = this._pageman.getNext(pageid);
            }
            pageid = this._pageman.getFirst((short)1);
            while (pageid != 0L) {
                page = this._file.get(pageid);
                file = zip2 + pageid;
                z.putNextEntry(new ZipEntry(file));
                z.write(Utils.encrypt(this.cipherIn, page.getData()));
                z.closeEntry();
                this._file.release(page);
                pageid = this._pageman.getNext(pageid);
            }
            pageid = this._pageman.getFirst((short)4);
            while (pageid != 0L) {
                page = this._file.get(pageid);
                file = zip2 + pageid;
                z.putNextEntry(new ZipEntry(file));
                z.write(Utils.encrypt(this.cipherIn, page.getData()));
                z.closeEntry();
                this._file.release(page);
                pageid = this._pageman.getNext(pageid);
            }
            pageid = this._pageman.getFirst((short)5);
            while (pageid != 0L) {
                page = this._file.get(pageid);
                file = zip2 + pageid;
                z.putNextEntry(new ZipEntry(file));
                z.write(Utils.encrypt(this.cipherIn, page.getData()));
                z.closeEntry();
                this._file.release(page);
                pageid = this._pageman.getNext(pageid);
            }
            z.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized void clearCache() {
    }

    private long statisticsCountPages(short pageType) throws IOException {
        long pageCounter = 0L;
        long pageid = this._pageman.getFirst(pageType);
        while (pageid != 0L) {
            ++pageCounter;
            pageid = this._pageman.getNext(pageid);
        }
        return pageCounter;
    }

    @Override
    public synchronized String calculateStatistics() {
        this.checkNotClosed();
        try {
            StringBuilder b = new StringBuilder();
            b.append("PAGES:\n");
            long total = 0L;
            long pages = this.statisticsCountPages((short)1);
            total += pages;
            b.append("  " + pages + " used pages with size " + Utils.formatSpaceUsage(pages * 4096L) + "\n");
            pages = this.statisticsCountPages((short)2);
            total += pages;
            b.append("  " + pages + " record translation pages with size " + Utils.formatSpaceUsage(pages * 4096L) + "\n");
            pages = this.statisticsCountPages((short)0);
            total += pages;
            b.append("  " + pages + " free (unused) pages with size " + Utils.formatSpaceUsage(pages * 4096L) + "\n");
            pages = this.statisticsCountPages((short)4);
            total += pages;
            b.append("  " + pages + " free (phys) pages with size " + Utils.formatSpaceUsage(pages * 4096L) + "\n");
            pages = this.statisticsCountPages((short)3);
            b.append("  " + pages + " free (logical) pages with size " + Utils.formatSpaceUsage(pages * 4096L) + "\n");
            b.append("  Total number of pages is " + (total += pages) + " with size " + Utils.formatSpaceUsage(total * 4096L) + "\n");
            b.append("RECORDS:\n");
            long recordCount = 0L;
            long freeRecordCount = 0L;
            long maximalRecordSize = 0L;
            long maximalAvailSizeDiff = 0L;
            long totalRecordSize = 0L;
            long totalAvailDiff = 0L;
            long pageid = this._pageman.getFirst((short)2);
            while (pageid != 0L) {
                PageIo io = this._file.get(pageid);
                int i = 0;
                while (true) {
                    if (i >= 680) break;
                    int pos = 14 + i * 6;
                    long physLoc = io.pageHeaderGetLocation((short)pos);
                    if (physLoc == 0L) {
                        ++freeRecordCount;
                    } else if (physLoc != -32768L) {
                        ++recordCount;
                        PageIo page = this._file.get(physLoc >>> 12);
                        short physOffset = (short)(physLoc & 0xFFFL);
                        int availSize = RecordHeader.getAvailableSize(page, physOffset);
                        int currentSize = RecordHeader.getCurrentSize(page, physOffset);
                        this._file.release(page);
                        maximalAvailSizeDiff = Math.max(maximalAvailSizeDiff, (long)(availSize - currentSize));
                        maximalRecordSize = Math.max(maximalRecordSize, (long)currentSize);
                        totalAvailDiff += (long)(availSize - currentSize);
                        totalRecordSize += (long)currentSize;
                    }
                    ++i;
                }
                this._file.release(io);
                pageid = this._pageman.getNext(pageid);
            }
            b.append("  Contains " + recordCount + " records and " + freeRecordCount + " free slots.\n");
            b.append("  Total space occupied by data is " + Utils.formatSpaceUsage(totalRecordSize) + "\n");
            b.append("  Average data size in record is " + Utils.formatSpaceUsage(Math.round(1.0 * (double)totalRecordSize / (double)recordCount)) + "\n");
            b.append("  Maximal data size in record is " + Utils.formatSpaceUsage(maximalRecordSize) + "\n");
            b.append("  Space wasted in record fragmentation is " + Utils.formatSpaceUsage(totalAvailDiff) + "\n");
            b.append("  Maximal space wasted in single record fragmentation is " + Utils.formatSpaceUsage(maximalAvailSizeDiff) + "\n");
            return b.toString();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized void defrag(boolean sortCollections) {
        try {
            File f2d;
            File f2t;
            File f1t;
            String f1;
            String[] exts;
            this.checkNotClosed();
            this.checkCanWrite();
            this.commit();
            String filename2 = this._filename + "_defrag" + System.currentTimeMillis();
            String filename1 = this._filename;
            DBStore db2 = new DBStore(filename2, false, true, this.cipherIn, this.cipherOut, false, false, false);
            LongHashMap<String> logicalPages = new LongHashMap<String>();
            long minpageid = 0L;
            long pageid = this._pageman.getFirst((short)2);
            while (pageid != 0L) {
                minpageid = Math.min(minpageid, pageid);
                logicalPages.put(pageid, "");
                pageid = this._pageman.getNext(pageid);
            }
            long pageCounter = 0L;
            long pageid2 = db2._pageman.allocate((short)2);
            while (pageid2 >= minpageid) {
                if (++pageCounter % 1000L == 0L) {
                    db2.commit();
                }
                pageid2 = db2._pageman.allocate((short)2);
            }
            logicalPages = null;
            if (sortCollections) {
                long nameRecid = this.getRoot((byte)0);
                TreeSet recids = new TreeSet();
                if (nameRecid != 0L) {
                    HTree m = (HTree)this.fetch(nameRecid);
                    recids.addAll(m.values());
                }
                for (Long namedRecid : recids) {
                    Object obj = this.fetch(namedRecid);
                    if (obj instanceof LinkedList) {
                        LinkedList2.defrag(namedRecid, this, db2);
                        continue;
                    }
                    if (obj instanceof HTree) {
                        HTree.defrag(namedRecid, this, db2);
                        continue;
                    }
                    if (!(obj instanceof BTree)) continue;
                    BTree.defrag(namedRecid, this, db2);
                }
            }
            long pageid3 = this._pageman.getFirst((short)2);
            while (pageid3 != 0L) {
                PageIo io = this._file.get(pageid3);
                int i = 0;
                while (true) {
                    long physRowId;
                    if (i >= 680) break;
                    int pos = 14 + i * 6;
                    if (pos > Short.MAX_VALUE) {
                        throw new Error();
                    }
                    long logicalRowId = (-pageid3 << 12) + (long)pos;
                    if ((db2._pageman.getLast((short)2) > pageid3 || db2._logicMgr.fetch(logicalRowId) == 0L) && (physRowId = io.pageHeaderGetLocation((short)pos)) != 0L) {
                        if (physRowId == -32768L) {
                            db2._logicMgr.forceInsert(logicalRowId, physRowId);
                        } else {
                            DataInputOutput b = new DataInputOutput();
                            this._physMgr.fetch(b, physRowId);
                            byte[] bb = b.toByteArray();
                            long physLoc = db2._physMgr.insert(bb, 0, bb.length);
                            db2._logicMgr.forceInsert(logicalRowId, physLoc);
                        }
                    }
                    ++i;
                }
                this._file.release(io);
                db2.commit();
                pageid3 = this._pageman.getNext(pageid3);
            }
            for (byte b = 0; b < 16; b = (byte)(b + 1)) {
                db2.setRoot(b, this.getRoot(b));
            }
            db2.close();
            this._pageman.close();
            this._file.close();
            ArrayList<File> filesToDelete = new ArrayList<File>();
            for (String ext : exts = new String[]{".i", ".d"}) {
                File f1d;
                f1 = filename1 + ext;
                String f2 = filename2 + "_OLD" + ext;
                f1t = new File(f1 + ".t");
                f2t = new File(f2 + ".t");
                f1t.renameTo(f2t);
                filesToDelete.add(f2t);
                int i = 0;
                while ((f1d = new File(f1 + "." + i)).exists()) {
                    f2d = new File(f2 + "." + i);
                    f1d.renameTo(f2d);
                    filesToDelete.add(f2d);
                    ++i;
                }
            }
            for (String ext : exts) {
                File f1d;
                f1 = filename2 + ext;
                String f2 = filename1 + ext;
                f1t = new File(f1 + ".t");
                f2t = new File(f2 + ".t");
                f1t.renameTo(f2t);
                int i = 0;
                while ((f1d = new File(f1 + "." + i)).exists()) {
                    f2d = new File(f2 + "." + i);
                    f1d.renameTo(f2d);
                    ++i;
                }
            }
            for (File d : filesToDelete) {
                d.delete();
            }
            this.reopen();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    void forceInsert(long logicalRowId, byte[] data) throws IOException {
        logicalRowId = DBStore.decompressRecid(logicalRowId);
        if (this.needsAutoCommit()) {
            this.commit();
        }
        long physLoc = this._physMgr.insert(data, 0, data.length);
        this._logicMgr.forceInsert(logicalRowId, physLoc);
    }

    long countRecords() throws IOException {
        long counter = 0L;
        long page = this._pageman.getFirst((short)2);
        while (page != 0L) {
            PageIo io = this._file.get(page);
            int i = 0;
            while (true) {
                if (i >= 680) break;
                int pos = 14 + i * 6;
                if (pos > Short.MAX_VALUE) {
                    throw new Error();
                }
                long physRowId = io.pageHeaderGetLocation((short)pos);
                if (physRowId != 0L) {
                    ++counter;
                }
                ++i;
            }
            this._file.release(io);
            page = this._pageman.getNext(page);
        }
        return counter;
    }

    static long compressRecid(long recid) {
        long page = recid >>> 12;
        short offset = (short)(recid & 0xFFFL);
        if ((offset = (short)(offset - 14)) % 6 != 0) {
            throw new InternalError("recid not dividable 6");
        }
        long slot = offset / 6;
        return (page << COMPRESS_RECID_PAGE_SHIFT) + slot;
    }

    static long decompressRecid(long recid) {
        long page = recid >>> COMPRESS_RECID_PAGE_SHIFT;
        short offset = (short)((recid & COMPRESS_RECID_OFFSET_MASK) * 6L + 14L);
        return (page << 12) + (long)offset;
    }

    static {
        int shift = 1;
        while (1 << shift < 680) {
            ++shift;
        }
        COMPRESS_RECID_PAGE_SHIFT = shift;
        COMPRESS_RECID_OFFSET_MASK = -1L >>> 64 - COMPRESS_RECID_PAGE_SHIFT;
    }
}

