/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jdbm.DBAbstract;
import org.apache.jdbm.DBStore;
import org.apache.jdbm.DataInputOutput;
import org.apache.jdbm.HTreeBucket;
import org.apache.jdbm.HTreeDirectory;
import org.apache.jdbm.LongPacker;
import org.apache.jdbm.RecordListener;
import org.apache.jdbm.Serialization;
import org.apache.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTree<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    final Serializer SERIALIZER = new Serializer<Object>(){

        @Override
        public Object deserialize(DataInput ds2) throws IOException {
            DataInputOutput ds = (DataInputOutput)ds2;
            try {
                int i = ds.readUnsignedByte();
                if (i == 164) {
                    HTreeBucket ret = new HTreeBucket(HTree.this);
                    if (HTree.this.loadValues) {
                        ret.readExternal(ds);
                    }
                    if (HTree.this.loadValues && ds.available() != 0) {
                        throw new InternalError("bytes left: " + ds.available());
                    }
                    return ret;
                }
                if (i == 165) {
                    HTreeDirectory ret = new HTreeDirectory(HTree.this);
                    ret.readExternal(ds);
                    if (HTree.this.loadValues && ds.available() != 0) {
                        throw new InternalError("bytes left: " + ds.available());
                    }
                    return ret;
                }
                throw new InternalError("Wrong HTree header: " + i);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            if (obj instanceof HTreeBucket) {
                out.write(164);
                HTreeBucket b = (HTreeBucket)obj;
                b.writeExternal(out);
            } else {
                out.write(165);
                HTreeDirectory n = (HTreeDirectory)obj;
                n.writeExternal(out);
            }
        }
    };
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected RecordListener[] recordListeners = new RecordListener[0];
    protected Serializer<K> keySerializer;
    protected Serializer<V> valueSerializer;
    protected boolean readonly = false;
    final long rootRecid;
    DBAbstract db;
    boolean hasValues = true;
    int modCount;
    private boolean loadValues = true;
    AtomicReference<DataInputOutput> writeBufferCache = new AtomicReference();
    private Set<Map.Entry<K, V>> _entrySet = new AbstractSet<Map.Entry<K, V>>(){

        protected Map.Entry<K, V> newEntry(K k, V v) {
            return new AbstractMap.SimpleEntry<K, V>(k, v){
                private static final long serialVersionUID = 978651696969194154L;

                @Override
                public V setValue(V arg0) {
                    HTree.this.put(this.getKey(), arg0);
                    return super.setValue(arg0);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Map.Entry<K, V> e) {
            if (HTree.this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            if (e.getKey() == null) {
                throw new NullPointerException("Can not add null key");
            }
            HTree.this.lock.writeLock().lock();
            try {
                if (e.getValue().equals(HTree.this.get(e.getKey()))) {
                    boolean bl = false;
                    return bl;
                }
                HTree.this.put(e.getKey(), e.getValue());
                boolean bl = true;
                return bl;
            }
            finally {
                HTree.this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && (e = (Map.Entry)o).getKey() != null && HTree.this.get(e.getKey()) != null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            try {
                final Iterator br = HTree.this.keys();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return br.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = br.next();
                        return this.newEntry(k, HTree.this.get(k));
                    }

                    @Override
                    public void remove() {
                        if (HTree.this.readonly) {
                            throw new UnsupportedOperationException("readonly");
                        }
                        br.remove();
                    }
                };
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (HTree.this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (e.getKey() == null || e.getValue() == null) {
                    return false;
                }
                HTree.this.lock.writeLock().lock();
                try {
                    Object v = HTree.this.get(e.getKey());
                    if (v == null || !e.getValue().equals(v)) {
                        boolean bl = false;
                        return bl;
                    }
                    HTree.this.remove(e.getKey());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    HTree.this.lock.writeLock().unlock();
                }
            }
            return false;
        }

        @Override
        public int size() {
            HTree.this.lock.readLock().lock();
            try {
                int counter = 0;
                Iterator it = HTree.this.keys();
                while (it.hasNext()) {
                    it.next();
                    ++counter;
                }
                int n = counter;
                return n;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                HTree.this.lock.readLock().unlock();
            }
        }
    };

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public HTree(DBAbstract db, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean hasValues) throws IOException {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.db = db;
        this.hasValues = hasValues;
        HTreeDirectory root = new HTreeDirectory(this, 0);
        root.setPersistenceContext(0L);
        this.rootRecid = db.insert(root, this.SERIALIZER, false);
    }

    public HTree(DBAbstract db, long rootRecid, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean hasValues) throws IOException {
        this.db = db;
        this.rootRecid = rootRecid;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.hasValues = hasValues;
    }

    void setPersistenceContext(DBAbstract db) {
        this.db = db;
    }

    @Override
    public V put(K key, V value) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        this.lock.writeLock().lock();
        try {
            if (key == null || value == null) {
                throw new NullPointerException("Null key or value");
            }
            Object oldVal = this.getRoot().put(key, value);
            if (oldVal == null) {
                ++this.modCount;
                HTreeDirectory<K, V> root = this.getRoot();
                ++root.size;
                this.db.update(this.rootRecid, root, this.SERIALIZER);
                for (RecordListener r : this.recordListeners) {
                    r.recordInserted(key, value);
                }
            } else {
                for (RecordListener r : this.recordListeners) {
                    r.recordUpdated(key, oldVal, value);
                }
            }
            Object object = oldVal;
            return (V)object;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            V v = this.getRoot().get(key);
            return v;
        }
        catch (ClassCastException e) {
            V v = null;
            return v;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public V remove(Object key) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        this.lock.writeLock().lock();
        try {
            if (key == null) {
                V v = null;
                return v;
            }
            Object val = this.getRoot().remove(key);
            ++this.modCount;
            if (val != null) {
                HTreeDirectory<K, V> root = this.getRoot();
                --root.size;
                this.db.update(this.rootRecid, root, this.SERIALIZER);
                for (RecordListener r : this.recordListeners) {
                    r.recordRemoved(key, val);
                }
            }
            Object object = val;
            return (V)object;
        }
        catch (ClassCastException e) {
            V v = null;
            return v;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        V v = this.get(key);
        return v != null;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            Iterator<K> keyIter = this.keys();
            while (keyIter.hasNext()) {
                keyIter.next();
                keyIter.remove();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<K> keys() throws IOException {
        this.lock.readLock().lock();
        try {
            Iterator<K> iterator = this.getRoot().keys();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DBAbstract getRecordManager() {
        return this.db;
    }

    public void addRecordListener(RecordListener<K, V> listener) {
        this.recordListeners = Arrays.copyOf(this.recordListeners, this.recordListeners.length + 1);
        this.recordListeners[this.recordListeners.length - 1] = listener;
    }

    public void removeRecordListener(RecordListener<K, V> listener) {
        List<RecordListener> l = Arrays.asList(this.recordListeners);
        l.remove(listener);
        this.recordListeners = l.toArray(new RecordListener[1]);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    HTreeDirectory<K, V> getRoot() {
        try {
            HTreeDirectory root = (HTreeDirectory)this.db.fetch(this.rootRecid, this.SERIALIZER);
            root.setPersistenceContext(this.rootRecid);
            return root;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static HTree deserialize(DataInput is, Serialization ser) throws IOException, ClassNotFoundException {
        long rootRecid = LongPacker.unpackLong(is);
        boolean hasValues = is.readBoolean();
        Serializer keySerializer = (Serializer)ser.deserialize(is);
        Serializer valueSerializer = (Serializer)ser.deserialize(is);
        return new HTree(ser.db, rootRecid, keySerializer, valueSerializer, hasValues);
    }

    void serialize(DataOutput out) throws IOException {
        LongPacker.packLong(out, this.rootRecid);
        out.writeBoolean(this.hasValues);
        this.db.defaultSerializer().serialize(out, this.keySerializer);
        this.db.defaultSerializer().serialize(out, this.valueSerializer);
    }

    static void defrag(Long recid, DBStore r1, DBStore r2) throws IOException {
        try {
            byte[] data = r1.fetchRaw(recid);
            r2.forceInsert(recid, data);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            HTree t = (HTree)r1.defaultSerializer().deserialize(in);
            t.db = r1;
            t.loadValues = false;
            HTreeDirectory d = t.getRoot();
            if (d != null) {
                r2.forceInsert(t.rootRecid, r1.fetchRaw(t.rootRecid));
                d.defrag(r1, r2);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOError(e);
        }
    }

    @Override
    public int size() {
        return (int)this.getRoot().size;
    }

    public boolean hasValues() {
        return this.hasValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.lock.writeLock().lock();
        try {
            if (!this.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = this.get(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.lock.writeLock().lock();
        try {
            if (this.containsKey(key) && this.get(key).equals(value)) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.lock.writeLock().lock();
        try {
            if (this.containsKey(key) && this.get(key).equals(oldValue)) {
                this.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.lock.writeLock().lock();
        try {
            if (this.containsKey(key)) {
                V v = this.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

