/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.IOException;
import java.util.Arrays;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.PageIo;
import org.apache.jdbm.PageManager;

final class LogicalRowIdManager {
    private final PageFile file;
    private final PageManager pageman;
    static final short ELEMS_PER_PAGE = 680;
    private long[] freeRecordsInTransRowid = new long[4];
    private int freeRecordsInTransSize = 0;
    static final int OFFSET_FREE_COUNT = 14;
    static final int FREE_HEADER_SIZE = 16;
    static final int FREE_RECORDS_PER_PAGE = 680;

    LogicalRowIdManager(PageFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
    }

    long insert(long physloc) throws IOException {
        long retval = this.getFreeSlot();
        if (retval == 0L) {
            long firstPage = this.pageman.allocate((short)2);
            int curOffset = 14;
            for (int i = 0; i < 680; ++i) {
                this.putFreeSlot((-firstPage << 12) + (long)curOffset);
                curOffset = (short)(curOffset + 6);
            }
            retval = this.getFreeSlot();
            if (retval == 0L) {
                throw new Error("couldn't obtain free translation");
            }
        }
        this.update(retval, physloc);
        return retval;
    }

    void forceInsert(long logicalRowId, long physLoc) throws IOException {
        if (this.fetch(logicalRowId) != 0L) {
            throw new Error("can not forceInsert, record already exists: " + logicalRowId);
        }
        this.update(logicalRowId, physLoc);
    }

    void delete(long logicalrowid) throws IOException {
        long pageId = -(logicalrowid >>> 12);
        PageIo xlatPage = this.file.get(pageId);
        xlatPage.pageHeaderSetLocation((short)(logicalrowid & 0xFFFL), 0L);
        this.file.release(pageId, true);
        this.putFreeSlot(logicalrowid);
    }

    void update(long logicalrowid, long physloc) throws IOException {
        long pageId = -(logicalrowid >>> 12);
        PageIo xlatPage = this.file.get(pageId);
        xlatPage.pageHeaderSetLocation((short)(logicalrowid & 0xFFFL), physloc);
        this.file.release(pageId, true);
    }

    long fetch(long logicalrowid) throws IOException {
        long pageId = -(logicalrowid >>> 12);
        long last = this.pageman.getLast((short)2);
        if (last - 1L > pageId) {
            return 0L;
        }
        short offset = (short)(logicalrowid & 0xFFFL);
        PageIo xlatPage = this.file.get(pageId);
        long ret = xlatPage.pageHeaderGetLocation(offset);
        this.file.release(pageId, false);
        return ret;
    }

    void commit() throws IOException {
        if (this.freeRecordsInTransSize == 0) {
            return;
        }
        long freeRecPageId = this.pageman.getLast((short)3);
        if (freeRecPageId == 0L) {
            freeRecPageId = this.pageman.allocate((short)3);
        }
        PageIo freeRecPage = this.file.get(freeRecPageId);
        for (int rowPos = 0; rowPos < this.freeRecordsInTransSize; ++rowPos) {
            short count = freeRecPage.readShort(14);
            if (count == 680) {
                this.file.release(freeRecPage);
                freeRecPageId = this.pageman.allocate((short)3);
                freeRecPage = this.file.get(freeRecPageId);
                freeRecPage.writeShort(680, (short)0);
                count = 0;
            }
            int offset = count * 6 + 16;
            freeRecPage.writeSixByteLong(offset, this.freeRecordsInTransRowid[rowPos]);
            count = (short)(count + 1);
            freeRecPage.writeShort(14, count);
        }
        this.file.release(freeRecPage);
        this.clearFreeRecidsInTransaction();
    }

    private void clearFreeRecidsInTransaction() {
        if (this.freeRecordsInTransRowid.length > 128) {
            this.freeRecordsInTransRowid = new long[4];
        }
        this.freeRecordsInTransSize = 0;
    }

    void rollback() throws IOException {
        this.clearFreeRecidsInTransaction();
    }

    long getFreeSlot() throws IOException {
        if (this.freeRecordsInTransSize != 0) {
            return this.freeRecordsInTransRowid[--this.freeRecordsInTransSize];
        }
        long logicFreePageId = this.pageman.getLast((short)3);
        if (logicFreePageId == 0L) {
            return 0L;
        }
        PageIo logicFreePage = this.file.get(logicFreePageId);
        short recCount = logicFreePage.readShort(14);
        if (recCount <= 0) {
            throw new InternalError();
        }
        int offset = (recCount - 1) * 6 + 16;
        long ret = logicFreePage.readSixByteLong(offset);
        if ((recCount = (short)(recCount - 1)) > 0) {
            logicFreePage.writeSixByteLong(offset, 0L);
            logicFreePage.writeShort(14, recCount);
            this.file.release(logicFreePage);
        } else {
            this.file.release(logicFreePage);
            this.pageman.free((short)3, logicFreePageId);
        }
        return ret;
    }

    void putFreeSlot(long rowid) throws IOException {
        if (this.freeRecordsInTransSize == this.freeRecordsInTransRowid.length) {
            this.freeRecordsInTransRowid = Arrays.copyOf(this.freeRecordsInTransRowid, this.freeRecordsInTransRowid.length * 4);
        }
        this.freeRecordsInTransRowid[this.freeRecordsInTransSize] = rowid;
        ++this.freeRecordsInTransSize;
    }
}

