/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongHashMap<V>
implements Serializable {
    private static final long serialVersionUID = 362499999763181265L;
    private int elementCount;
    private Entry<V>[] elementData;
    private final float loadFactor;
    private int threshold;
    private int defaultSize = 16;
    private transient Entry<V> reuseAfterDelete = null;

    private Entry<V>[] newElementArray(int s) {
        return new Entry[s];
    }

    public LongHashMap() {
        this(16);
    }

    public LongHashMap(int capacity) {
        this.defaultSize = capacity;
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
        }
        if (this.elementData.length > 1024 && this.elementData.length > this.defaultSize) {
            this.elementData = new Entry[this.defaultSize];
        } else {
            Arrays.fill(this.elementData, null);
        }
        this.computeMaxSize();
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public V get(long key) {
        int hash = LongHashMap.powerHash(key);
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> m = this.elementData[index];
        while (m != null) {
            if (key == m.key) {
                return m.value;
            }
            m = m.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public V put(long key, V value) {
        int hash = LongHashMap.powerHash(key);
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> entry = this.elementData[index];
        while (entry != null && key != entry.key) {
            entry = entry.next;
        }
        if (entry == null) {
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = this.createHashedEntry(key, index);
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    Entry<V> createHashedEntry(long key, int index) {
        Entry<V> entry = this.reuseAfterDelete;
        if (entry == null) {
            entry = new Entry(key);
        } else {
            this.reuseAfterDelete = null;
            entry.key = key;
            entry.value = null;
        }
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    void rehash(int capacity) {
        int length = capacity == 0 ? 1 : capacity << 1;
        Entry<V>[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry<V> entry = this.elementData[i];
            while (entry != null) {
                int index = (LongHashMap.powerHash(entry.key) & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    public V remove(long key) {
        Entry<V> entry = this.removeEntry(key);
        if (entry == null) {
            return null;
        }
        Object ret = entry.value;
        entry.value = null;
        entry.key = Long.MIN_VALUE;
        this.reuseAfterDelete = entry;
        return ret;
    }

    Entry<V> removeEntry(long key) {
        Entry<V> last = null;
        int hash = LongHashMap.powerHash(key);
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<V> entry = this.elementData[index];
        while (entry != null) {
            if (key == entry.key) {
                if (last == null) {
                    this.elementData[index] = entry.next;
                } else {
                    last.next = entry.next;
                }
                --this.elementCount;
                return entry;
            }
            last = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.elementCount;
    }

    public Iterator<V> valuesIterator() {
        return new HashMapIterator(this);
    }

    private static final int powerHash(long key) {
        int h = (int)(key ^ key >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashMapIterator<V>
    implements Iterator<V> {
        private int position = 0;
        boolean canRemove = false;
        Entry<V> entry;
        Entry<V> lastEntry;
        final LongHashMap<V> associatedMap;

        HashMapIterator(LongHashMap<V> hm) {
            this.associatedMap = hm;
        }

        @Override
        public boolean hasNext() {
            int newPosition;
            if (this.entry != null) {
                return true;
            }
            Entry[] elementData = ((LongHashMap)this.associatedMap).elementData;
            int length = elementData.length;
            boolean result = false;
            for (newPosition = this.position; newPosition < length; ++newPosition) {
                if (elementData[newPosition] == null) {
                    continue;
                }
                result = true;
                break;
            }
            this.position = newPosition;
            return result;
        }

        @Override
        public V next() {
            Entry result;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entry _entry = this.entry;
            if (_entry == null) {
                result = this.lastEntry = ((LongHashMap)this.associatedMap).elementData[this.position++];
                this.entry = this.lastEntry.next;
            } else {
                if (this.lastEntry.next != _entry) {
                    this.lastEntry = this.lastEntry.next;
                }
                result = _entry;
                this.entry = _entry.next;
            }
            this.canRemove = true;
            return result.value;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.canRemove = false;
            if (this.lastEntry.next == this.entry) {
                while (((LongHashMap)this.associatedMap).elementData[--this.position] == null) {
                }
                ((LongHashMap)this.associatedMap).elementData[this.position] = ((LongHashMap)this.associatedMap).elementData[this.position].next;
                this.entry = null;
            } else {
                this.lastEntry.next = this.entry;
            }
            if (this.lastEntry != null) {
                Entry<V> reuse = this.lastEntry;
                this.lastEntry = null;
                reuse.key = Long.MIN_VALUE;
                reuse.value = null;
                ((LongHashMap)this.associatedMap).reuseAfterDelete = reuse;
            }
            ((LongHashMap)this.associatedMap).elementCount--;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry<V>
    implements Serializable {
        private static final long serialVersionUID = 362445231113181265L;
        Entry<V> next;
        V value;
        long key;

        Entry(long theKey) {
            this.key = theKey;
            this.value = null;
        }
    }
}

