/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class LongPacker {
    public static void packLong(DataOutput os, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            os.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        os.write((byte)value);
    }

    public static long unpackLong(DataInput is) throws IOException {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = is.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed long.");
    }

    public static void packInt(DataOutput os, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: v=" + value);
        }
        while ((value & 0xFFFFFF80) != 0) {
            os.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        os.write((byte)value);
    }

    public static int unpackInt(DataInput is) throws IOException {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = is.readUnsignedByte();
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new Error("Malformed integer.");
    }
}

