/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import javax.crypto.Cipher;
import org.apache.jdbm.DBMaker;
import org.apache.jdbm.LongHashMap;
import org.apache.jdbm.PageIo;
import org.apache.jdbm.PageTransactionManager;
import org.apache.jdbm.Storage;
import org.apache.jdbm.StorageDisk;
import org.apache.jdbm.StorageDiskMapped;
import org.apache.jdbm.StorageMemory;
import org.apache.jdbm.StorageZip;
import org.apache.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PageFile {
    final PageTransactionManager txnMgr;
    private final LongHashMap<PageIo> inUse = new LongHashMap();
    private final LongHashMap<PageIo> dirty = new LongHashMap();
    private final LongHashMap<PageIo> inTxn = new LongHashMap();
    final boolean transactionsDisabled;
    static final byte[] CLEAN_DATA = new byte[4096];
    final Storage storage;
    private Cipher cipherOut;
    private Cipher cipherIn;

    PageFile(String fileName, boolean readonly, boolean transactionsDisabled, Cipher cipherIn, Cipher cipherOut, boolean useRandomAccessFile, boolean lockingDisabled) throws IOException {
        this.cipherIn = cipherIn;
        this.cipherOut = cipherOut;
        this.transactionsDisabled = transactionsDisabled;
        this.storage = fileName == null ? new StorageMemory(transactionsDisabled) : (DBMaker.isZipFileLocation(fileName) != null ? new StorageZip(DBMaker.isZipFileLocation(fileName)) : (useRandomAccessFile ? new StorageDisk(fileName, readonly, lockingDisabled) : new StorageDiskMapped(fileName, readonly, transactionsDisabled, lockingDisabled)));
        if (this.storage.isReadonly() && !readonly) {
            throw new IllegalArgumentException("This type of storage is readonly, you should call readonly() on DBMaker");
        }
        this.txnMgr = !readonly && !transactionsDisabled ? new PageTransactionManager(this, this.storage, cipherIn, cipherOut) : null;
    }

    public PageFile(String filename) throws IOException {
        this(filename, false, false, null, null, false, false);
    }

    PageIo get(long pageId) throws IOException {
        PageIo node = this.inTxn.get(pageId);
        if (node != null) {
            this.inTxn.remove(pageId);
            this.inUse.put(pageId, node);
            return node;
        }
        node = this.dirty.get(pageId);
        if (node != null) {
            this.dirty.remove(pageId);
            this.inUse.put(pageId, node);
            return node;
        }
        if (this.inUse.get(pageId) != null) {
            throw new Error("double get for page " + pageId);
        }
        if (this.cipherOut == null) {
            node = new PageIo(pageId, this.storage.read(pageId));
        } else {
            byte[] bb;
            ByteBuffer b = this.storage.read(pageId);
            if (b.hasArray()) {
                bb = b.array();
            } else {
                bb = new byte[4096];
                b.position(0);
                b.get(bb, 0, 4096);
            }
            if (!Utils.allZeros(bb)) {
                try {
                    bb = this.cipherOut.doFinal(bb);
                    node = new PageIo(pageId, ByteBuffer.wrap(bb));
                }
                catch (Exception e) {
                    throw new IOError(e);
                }
            } else {
                node = new PageIo(pageId, ByteBuffer.wrap(CLEAN_DATA).asReadOnlyBuffer());
            }
        }
        this.inUse.put(pageId, node);
        node.setClean();
        return node;
    }

    void release(long pageId, boolean isDirty) throws IOException {
        PageIo page = this.inUse.remove(pageId);
        if (!page.isDirty() && isDirty) {
            page.setDirty();
        }
        if (page.isDirty()) {
            this.dirty.put(pageId, page);
        } else if (!this.transactionsDisabled && page.isInTransaction()) {
            this.inTxn.put(pageId, page);
        }
    }

    void release(PageIo page) throws IOException {
        long key = page.getPageId();
        this.inUse.remove(key);
        if (page.isDirty()) {
            this.dirty.put(key, page);
        } else if (!this.transactionsDisabled && page.isInTransaction()) {
            this.inTxn.put(key, page);
        }
    }

    void discard(PageIo page) {
        long key = page.getPageId();
        this.inUse.remove(key);
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.valuesIterator());
            throw new Error("in use list not empty at commit time (" + this.inUse.size() + ")");
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.start();
        }
        long[] pageIds = new long[this.dirty.size()];
        int c = 0;
        Iterator<PageIo> i = this.dirty.valuesIterator();
        while (i.hasNext()) {
            pageIds[c] = i.next().getPageId();
            ++c;
        }
        Arrays.sort(pageIds);
        for (long pageId : pageIds) {
            PageIo node = this.dirty.get(pageId);
            if (this.transactionsDisabled) {
                if (this.cipherIn != null) {
                    this.storage.write(node.getPageId(), ByteBuffer.wrap(Utils.encrypt(this.cipherIn, node.getData())));
                } else {
                    this.storage.write(node.getPageId(), node.getData());
                }
                node.setClean();
                continue;
            }
            this.txnMgr.add(node);
            this.inTxn.put(node.getPageId(), node);
        }
        this.dirty.clear();
        if (!this.transactionsDisabled) {
            this.txnMgr.commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.valuesIterator());
            throw new Error("in use list not empty at rollback time (" + this.inUse.size() + ")");
        }
        this.dirty.clear();
        this.txnMgr.synchronizeLogFromDisk();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.valuesIterator());
            throw new Error("in txn list not empty at rollback time (" + this.inTxn.size() + ")");
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        if (!this.transactionsDisabled && this.txnMgr != null) {
            this.txnMgr.shutdown();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.valuesIterator());
            throw new Error("In transaction not empty");
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty pages at close time");
            this.showList(this.dirty.valuesIterator());
            throw new Error("Dirty pages at close time");
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse pages at close time");
            this.showList(this.inUse.valuesIterator());
            throw new Error("inUse pages  at close time");
        }
        this.storage.sync();
        this.storage.forceClose();
    }

    void forceClose() throws IOException {
        if (!this.transactionsDisabled) {
            this.txnMgr.forceClose();
        }
        this.storage.forceClose();
    }

    private void showList(Iterator<PageIo> i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    void synch(PageIo node) throws IOException {
        ByteBuffer data = node.getData();
        if (data != null) {
            if (this.cipherIn != null) {
                this.storage.write(node.getPageId(), ByteBuffer.wrap(Utils.encrypt(this.cipherIn, data)));
            } else {
                this.storage.write(node.getPageId(), data);
            }
        }
    }

    void releaseFromTransaction(PageIo node) throws IOException {
        this.inTxn.remove(node.getPageId());
    }

    void sync() throws IOException {
        this.storage.sync();
    }

    public int getDirtyPageCount() {
        return this.dirty.size();
    }

    public void deleteAllFiles() throws IOException {
        this.storage.deleteAllFiles();
    }
}

