/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import org.apache.jdbm.Utils;

final class PageIo {
    private long pageId;
    private ByteBuffer data;
    private boolean dirty = false;
    private int transactionCount = 0;

    public PageIo() {
    }

    PageIo(long pageId, byte[] data) {
        this.pageId = pageId;
        this.data = ByteBuffer.wrap(data);
    }

    public PageIo(long pageId, ByteBuffer data) {
        this.pageId = pageId;
        this.data = data;
    }

    void ensureHeapBuffer() {
        if (this.data.isDirect()) {
            byte[] bb = new byte[4096];
            this.data.get(bb, 0, 4096);
            this.data = ByteBuffer.wrap(bb);
            if (this.data.isReadOnly()) {
                throw new InternalError();
            }
        }
    }

    ByteBuffer getData() {
        return this.data;
    }

    long getPageId() {
        return this.pageId;
    }

    void setDirty() {
        this.dirty = true;
        if (this.data.isReadOnly()) {
            byte[] buf = new byte[4096];
            this.data.get(buf, 0, 4096);
            this.data = ByteBuffer.wrap(buf);
        }
    }

    void setClean() {
        this.dirty = false;
    }

    boolean isDirty() {
        return this.dirty;
    }

    boolean isInTransaction() {
        return this.transactionCount != 0;
    }

    void incrementTransactionCount() {
        ++this.transactionCount;
    }

    void decrementTransactionCount() {
        --this.transactionCount;
        if (this.transactionCount < 0) {
            throw new Error("transaction count on page " + this.getPageId() + " below zero!");
        }
    }

    public byte readByte(int pos) {
        return this.data.get(pos);
    }

    public void writeByte(int pos, byte value) {
        this.setDirty();
        this.data.put(pos, value);
    }

    public short readShort(int pos) {
        return this.data.getShort(pos);
    }

    public void writeShort(int pos, short value) {
        this.setDirty();
        this.data.putShort(pos, value);
    }

    public int readInt(int pos) {
        return this.data.getInt(pos);
    }

    public void writeInt(int pos, int value) {
        this.setDirty();
        this.data.putInt(pos, value);
    }

    public long readLong(int pos) {
        return this.data.getLong(pos);
    }

    public void writeLong(int pos, long value) {
        this.setDirty();
        this.data.putLong(pos, value);
    }

    public long readSixByteLong(int pos) {
        long ret = (long)(this.data.get(pos + 0) & 0x7F) << 40 | (long)(this.data.get(pos + 1) & 0xFF) << 32 | (long)(this.data.get(pos + 2) & 0xFF) << 24 | (long)(this.data.get(pos + 3) & 0xFF) << 16 | (long)(this.data.get(pos + 4) & 0xFF) << 8 | (long)(this.data.get(pos + 5) & 0xFF) << 0;
        if ((this.data.get(pos + 0) & 0x80) != 0) {
            return -ret;
        }
        return ret;
    }

    public void writeSixByteLong(int pos, long value) {
        int negativeBit = 0;
        if (value < 0L) {
            value = -value;
            negativeBit = 128;
        }
        this.setDirty();
        this.data.put(pos + 0, (byte)(0x7FL & value >> 40 | (long)negativeBit));
        this.data.put(pos + 1, (byte)(0xFFL & value >> 32));
        this.data.put(pos + 2, (byte)(0xFFL & value >> 24));
        this.data.put(pos + 3, (byte)(0xFFL & value >> 16));
        this.data.put(pos + 4, (byte)(0xFFL & value >> 8));
        this.data.put(pos + 5, (byte)(0xFFL & value >> 0));
    }

    public String toString() {
        return "PageIo(" + this.pageId + "," + this.dirty + ")";
    }

    public void readExternal(DataInputStream in, Cipher cipherOut) throws IOException {
        this.pageId = in.readLong();
        byte[] data2 = new byte[4096];
        in.readFully(data2);
        if (cipherOut == null || Utils.allZeros(data2)) {
            this.data = ByteBuffer.wrap(data2);
        } else {
            try {
                this.data = ByteBuffer.wrap(cipherOut.doFinal(data2));
            }
            catch (Exception e) {
                throw new IOError(e);
            }
        }
    }

    public void writeExternal(DataOutput out, Cipher cipherIn) throws IOException {
        out.writeLong(this.pageId);
        out.write(Utils.encrypt(cipherIn, this.data.array()));
    }

    public byte[] getByteArray() {
        if (this.data.hasArray()) {
            return this.data.array();
        }
        byte[] d = new byte[4096];
        this.data.rewind();
        this.data.get(d, 0, 4096);
        return d;
    }

    public void writeByteArray(byte[] buf, int srcOffset, int offset, int length) {
        this.setDirty();
        this.data.rewind();
        this.data.position(offset);
        this.data.put(buf, srcOffset, length);
    }

    public void fileHeaderCheckHead(boolean isNew) {
        if (isNew) {
            this.writeShort(0, (short)4944);
        } else {
            short magic = this.readShort(0);
            if (magic != 4944) {
                throw new Error("CRITICAL: file header magic not OK " + magic);
            }
        }
    }

    long fileHeaderGetFirstOf(int list) {
        return this.readLong(this.fileHeaderOffsetOfFirst(list));
    }

    void fileHeaderSetFirstOf(int list, long value) {
        this.writeLong(this.fileHeaderOffsetOfFirst(list), value);
    }

    long fileHeaderGetLastOf(int list) {
        return this.readLong(this.fileHeaderOffsetOfLast(list));
    }

    void fileHeaderSetLastOf(int list, long value) {
        this.writeLong(this.fileHeaderOffsetOfLast(list), value);
    }

    private short fileHeaderOffsetOfFirst(int list) {
        return (short)(2 + 16 * list);
    }

    private short fileHeaderOffsetOfLast(int list) {
        return (short)(this.fileHeaderOffsetOfFirst(list) + 8);
    }

    long fileHeaderGetRoot(int root) {
        short offset = (short)(98 + root * 8);
        return this.readLong(offset);
    }

    void fileHeaderSetRoot(int root, long rowid) {
        short offset = (short)(98 + root * 8);
        this.writeLong(offset, rowid);
    }

    boolean pageHeaderMagicOk() {
        short magic = this.pageHeaderGetMagic();
        return magic >= 4945 && magic <= 4950;
    }

    protected void pageHeaderParanoiaMagicOk() {
        if (!this.pageHeaderMagicOk()) {
            throw new Error("CRITICAL: page header magic not OK " + this.pageHeaderGetMagic());
        }
    }

    short pageHeaderGetMagic() {
        return this.readShort(0);
    }

    long pageHeaderGetNext() {
        this.pageHeaderParanoiaMagicOk();
        return this.readSixByteLong(2);
    }

    void pageHeaderSetNext(long next) {
        this.pageHeaderParanoiaMagicOk();
        this.writeSixByteLong(2, next);
    }

    long pageHeaderGetPrev() {
        this.pageHeaderParanoiaMagicOk();
        return this.readSixByteLong(8);
    }

    void pageHeaderSetPrev(long prev) {
        this.pageHeaderParanoiaMagicOk();
        this.writeSixByteLong(8, prev);
    }

    void pageHeaderSetType(short type) {
        this.writeShort(0, (short)(4945 + type));
    }

    long pageHeaderGetLocation(short pos) {
        return this.readSixByteLong(pos + 0);
    }

    void pageHeaderSetLocation(short pos, long value) {
        this.writeSixByteLong(pos + 0, value);
    }

    short dataPageGetFirst() {
        return this.readShort(14);
    }

    void dataPageSetFirst(short value) {
        this.pageHeaderParanoiaMagicOk();
        if (value > 0 && value < 16) {
            throw new Error("DataPage.setFirst: offset " + value + " too small");
        }
        this.writeShort(14, value);
    }
}

