/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.PageIo;

final class PageManager {
    final PageFile file;
    private PageIo headerBuf;

    PageManager(PageFile file) throws IOException {
        this.file = file;
        this.headerBuf = file.get(0L);
        this.headerBuf.ensureHeapBuffer();
        this.headerBuf.fileHeaderCheckHead(this.headerBuf.readShort(0) == 0);
    }

    long allocate(short type) throws IOException {
        if (type == 0) {
            throw new Error("allocate of free page?");
        }
        long retval = this.headerBuf.fileHeaderGetFirstOf(0);
        boolean isNew = false;
        if (type != 2) {
            if (retval != 0L) {
                this.headerBuf.fileHeaderSetFirstOf(0, this.getNext(retval));
            } else {
                retval = this.headerBuf.fileHeaderGetLastOf(0);
                if (retval == 0L) {
                    retval = 1L;
                }
                this.headerBuf.fileHeaderSetLastOf(0, retval + 1L);
                isNew = true;
            }
        } else {
            retval = this.headerBuf.fileHeaderGetLastOf(2) - 1L;
            isNew = true;
        }
        PageIo pageHdr = this.file.get(retval);
        if (isNew) {
            pageHdr.pageHeaderSetType(type);
        } else if (!pageHdr.pageHeaderMagicOk()) {
            throw new Error("CRITICAL: page header magic for page " + pageHdr.getPageId() + " not OK " + pageHdr.pageHeaderGetMagic());
        }
        long oldLast = this.headerBuf.fileHeaderGetLastOf(type);
        pageHdr.writeByteArray(PageFile.CLEAN_DATA, 0, 0, 4096);
        pageHdr.pageHeaderSetType(type);
        pageHdr.pageHeaderSetPrev(oldLast);
        pageHdr.pageHeaderSetNext(0L);
        if (oldLast == 0L) {
            this.headerBuf.fileHeaderSetFirstOf(type, retval);
        }
        this.headerBuf.fileHeaderSetLastOf(type, retval);
        this.file.release(retval, true);
        if (oldLast != 0L) {
            pageHdr = this.file.get(oldLast);
            pageHdr.pageHeaderSetNext(retval);
            this.file.release(oldLast, true);
        }
        return retval;
    }

    void free(short type, long recid) throws IOException {
        if (type == 0) {
            throw new Error("free free page?");
        }
        if (type == 2) {
            throw new Error("Translation page can not be dealocated");
        }
        if (recid == 0L) {
            throw new Error("free header page?");
        }
        PageIo pageHdr = this.file.get(recid);
        long prev = pageHdr.pageHeaderGetPrev();
        long next = pageHdr.pageHeaderGetNext();
        pageHdr.pageHeaderSetType((short)0);
        pageHdr.pageHeaderSetNext(this.headerBuf.fileHeaderGetFirstOf(0));
        pageHdr.pageHeaderSetPrev(0L);
        this.headerBuf.fileHeaderSetFirstOf(0, recid);
        this.file.release(recid, true);
        if (prev != 0L) {
            pageHdr = this.file.get(prev);
            pageHdr.pageHeaderSetNext(next);
            this.file.release(prev, true);
        } else {
            this.headerBuf.fileHeaderSetFirstOf(type, next);
        }
        if (next != 0L) {
            pageHdr = this.file.get(next);
            pageHdr.pageHeaderSetPrev(prev);
            this.file.release(next, true);
        } else {
            this.headerBuf.fileHeaderSetLastOf(type, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNext(long page) throws IOException {
        try {
            long l = this.file.get(page).pageHeaderGetNext();
            return l;
        }
        finally {
            this.file.release(page, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPrev(long page) throws IOException {
        try {
            long l = this.file.get(page).pageHeaderGetPrev();
            return l;
        }
        finally {
            this.file.release(page, false);
        }
    }

    long getFirst(short type) throws IOException {
        return this.headerBuf.fileHeaderGetFirstOf(type);
    }

    long getLast(short type) throws IOException {
        return this.headerBuf.fileHeaderGetLastOf(type);
    }

    void commit() throws IOException {
        this.file.release(this.headerBuf);
        this.file.commit();
        this.headerBuf = this.file.get(0L);
        this.headerBuf.ensureHeapBuffer();
        this.headerBuf.fileHeaderCheckHead(this.headerBuf.readShort(0) == 0);
    }

    void rollback() throws IOException {
        this.file.discard(this.headerBuf);
        this.file.rollback();
        this.headerBuf = this.file.get(0L);
        this.headerBuf.ensureHeapBuffer();
        this.headerBuf.fileHeaderCheckHead(this.headerBuf.readShort(0) == 0);
    }

    void close() throws IOException {
        this.file.release(this.headerBuf);
        this.file.commit();
        this.headerBuf = null;
    }

    ByteBuffer getHeaderBufData() {
        return this.headerBuf.getData();
    }

    public PageIo getFileHeader() {
        return this.headerBuf;
    }
}

