/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.crypto.Cipher;
import org.apache.jdbm.LongPacker;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.PageIo;
import org.apache.jdbm.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PageTransactionManager {
    private PageFile owner;
    private DataOutputStream oos;
    private ArrayList<PageIo> txn = new ArrayList();
    private int curTxn = -1;
    private Storage storage;
    private Cipher cipherIn;
    private Cipher cipherOut;
    private static final Comparator<PageIo> PAGE_IO_COMPARTOR = new Comparator<PageIo>(){

        @Override
        public int compare(PageIo page1, PageIo page2) {
            if (page1.getPageId() == page2.getPageId()) {
                return 0;
            }
            if (page1.getPageId() < page2.getPageId()) {
                return -1;
            }
            return 1;
        }
    };

    PageTransactionManager(PageFile owner, Storage storage, Cipher cipherIn, Cipher cipherOut) throws IOException {
        this.owner = owner;
        this.storage = storage;
        this.cipherIn = cipherIn;
        this.cipherOut = cipherOut;
        this.recover();
        this.open();
    }

    public void synchronizeLog() throws IOException {
        this.synchronizeLogFromMemory();
    }

    private void synchronizeLogFromMemory() throws IOException {
        this.close();
        TreeSet<PageIo> pageList = new TreeSet<PageIo>(PAGE_IO_COMPARTOR);
        int numPages = 0;
        int writtenPages = 0;
        if (this.txn != null) {
            for (PageIo page : this.txn) {
                if (pageList.contains(page)) {
                    page.decrementTransactionCount();
                } else {
                    ++writtenPages;
                    boolean result = pageList.add(page);
                }
                ++numPages;
            }
            this.txn = null;
        }
        this.synchronizePages(pageList, true);
        this.owner.sync();
        this.open();
    }

    private void open() throws IOException {
        this.oos = this.storage.openTransactionLog();
        this.oos.writeShort(4960);
        this.oos.flush();
        this.curTxn = -1;
    }

    private void recover() throws IOException {
        DataInputStream ois = this.storage.readTransactionLog();
        if (ois == null) {
            return;
        }
        while (true) {
            ArrayList<PageIo> pages = null;
            try {
                int size = LongPacker.unpackInt(ois);
                pages = new ArrayList<PageIo>(size);
                for (int i = 0; i < size; ++i) {
                    PageIo b = new PageIo();
                    b.readExternal(ois, this.cipherOut);
                    pages.add(b);
                }
            }
            catch (IOException e) {
                break;
            }
            this.synchronizePages(pages, false);
        }
        this.owner.sync();
        ois.close();
        this.storage.deleteTransactionLog();
    }

    private void synchronizePages(Iterable<PageIo> pages, boolean fromCore) throws IOException {
        for (PageIo cur : pages) {
            this.owner.synch(cur);
            if (!fromCore) continue;
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur);
        }
    }

    private void setClean(ArrayList<PageIo> pages) throws IOException {
        for (PageIo cur : pages) {
            cur.setClean();
        }
    }

    private void discardPages(ArrayList<PageIo> pages) throws IOException {
        for (PageIo cur : pages) {
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur);
        }
    }

    void start() throws IOException {
        ++this.curTxn;
        if (this.curTxn == 1) {
            this.synchronizeLogFromMemory();
            this.curTxn = 0;
        }
        this.txn = new ArrayList();
    }

    void add(PageIo page) throws IOException {
        page.incrementTransactionCount();
        this.txn.add(page);
    }

    void commit() throws IOException {
        LongPacker.packInt(this.oos, this.txn.size());
        for (PageIo page : this.txn) {
            page.writeExternal(this.oos, this.cipherIn);
        }
        this.sync();
        this.setClean(this.txn);
    }

    private void sync() throws IOException {
        this.oos.flush();
    }

    void shutdown() throws IOException {
        this.synchronizeLogFromMemory();
        this.close();
    }

    private void close() throws IOException {
        this.sync();
        this.oos.close();
        this.oos = null;
    }

    void forceClose() throws IOException {
        this.oos.close();
        this.oos = null;
    }

    void synchronizeLogFromDisk() throws IOException {
        this.close();
        if (this.txn != null) {
            this.discardPages(this.txn);
            this.txn = null;
        }
        this.recover();
        this.open();
    }
}

