/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.IOException;
import java.util.Arrays;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.PageIo;
import org.apache.jdbm.PageManager;

final class PhysicalFreeRowIdManager {
    static final int MAX_REC_SIZE = 8192;
    static final int ROOT_HEADER_SIZE = 14;
    static final int SLOT_PAGE_HEADER_SIZE = 22;
    static final int OFFSET_SLOT_PAGE_REC_COUNT = 14;
    static final int SLOT_PAGE_REC_NUM = 679;
    static final int OFFSET_SLOT_PAGE_NEXT = 16;
    static final int MAX_RECIDS_PER_PAGE = 679;
    static final int ROOT_SLOT_SIZE = 13;
    protected final PageFile file;
    protected final PageManager pageman;
    private long[] inTrans = new long[8];
    private int inTransSize = 0;

    PhysicalFreeRowIdManager(PageFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
    }

    long getFreeRecord(int size) throws IOException {
        int rootPageOffset;
        if (size >= 8192) {
            return 0L;
        }
        PageIo root = this.getRootPage();
        long slotPageId = root.readSixByteLong(rootPageOffset = PhysicalFreeRowIdManager.sizeToRootOffset(size + 13));
        if (slotPageId == 0L) {
            this.file.release(root);
            return 0L;
        }
        PageIo slotPage = this.file.get(slotPageId);
        if (slotPage.readShort(0) != 4949) {
            throw new InternalError();
        }
        short recidCount = slotPage.readShort(14);
        if (recidCount <= 0) {
            throw new InternalError();
        }
        int offset = (recidCount - 1) * 6 + 22;
        long recid = slotPage.readSixByteLong(offset);
        if ((recidCount = (short)(recidCount - 1)) > 0) {
            slotPage.writeSixByteLong(offset, 0L);
            slotPage.writeShort(14, recidCount);
            this.file.release(root);
            this.file.release(slotPage);
        } else {
            long prevSlotPageId = slotPage.readSixByteLong(16);
            root.writeSixByteLong(rootPageOffset, prevSlotPageId);
            this.file.release(root);
            this.file.release(slotPage);
            this.pageman.free((short)4, slotPageId);
        }
        return recid;
    }

    static final int sizeToRootOffset(int size) {
        return 14 + 6 * (size / 13);
    }

    void putFreeRecord(long rowid, int size) throws IOException {
        if (this.inTransSize == this.inTrans.length) {
            this.inTrans = Arrays.copyOf(this.inTrans, this.inTrans.length * 2);
        }
        this.inTrans[this.inTransSize] = rowid + ((long)size << 48);
        ++this.inTransSize;
    }

    public void commit() throws IOException {
        if (this.inTransSize == 0) {
            return;
        }
        Arrays.sort(this.inTrans, 0, this.inTransSize - 1);
        PageIo root = this.getRootPage();
        PageIo slotPage = null;
        for (int rowIdPos = 0; rowIdPos < this.inTransSize; ++rowIdPos) {
            int size = (int)(this.inTrans[rowIdPos] >>> 48);
            long rowid = this.inTrans[rowIdPos] & 0xFFFFFFFFFFFFL;
            int rootPageOffset = PhysicalFreeRowIdManager.sizeToRootOffset(size);
            long slotPageId = root.readSixByteLong(rootPageOffset);
            if (slotPageId == 0L) {
                if (slotPage != null) {
                    this.file.release(slotPage);
                }
                slotPageId = this.pageman.allocate((short)4);
                root.writeSixByteLong(rootPageOffset, slotPageId);
            }
            if (slotPage == null || slotPage.getPageId() != slotPageId) {
                if (slotPage != null) {
                    this.file.release(slotPage);
                }
                slotPage = this.file.get(slotPageId);
            }
            if (slotPage.readShort(0) != 4949) {
                throw new InternalError();
            }
            short recidCount = slotPage.readShort(14);
            if (recidCount == 679) {
                this.file.release(slotPage);
                long newSlotPageId = this.pageman.allocate((short)4);
                slotPage = this.file.get(newSlotPageId);
                slotPage.writeSixByteLong(16, slotPageId);
                slotPage.writeShort(14, (short)0);
                recidCount = 0;
                slotPageId = newSlotPageId;
                root.writeSixByteLong(rootPageOffset, newSlotPageId);
            }
            slotPage.writeSixByteLong(recidCount * 6 + 22, rowid);
            recidCount = (short)(recidCount + 1);
            slotPage.writeShort(14, recidCount);
        }
        if (slotPage != null) {
            this.file.release(slotPage);
        }
        this.file.release(root);
        this.clearFreeInTrans();
    }

    public void rollback() {
        this.clearFreeInTrans();
    }

    private void clearFreeInTrans() {
        if (this.inTrans.length > 128) {
            this.inTrans = new long[8];
        }
        this.inTransSize = 0;
    }

    final PageIo getRootPage() throws IOException {
        long pageId = this.pageman.getFirst((short)5);
        if (pageId == 0L) {
            pageId = this.pageman.allocate((short)5);
        }
        return this.file.get(pageId);
    }
}

