/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.IOException;
import org.apache.jdbm.DataInputOutput;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.PageIo;
import org.apache.jdbm.PageManager;
import org.apache.jdbm.PhysicalFreeRowIdManager;
import org.apache.jdbm.RecordHeader;

final class PhysicalRowIdManager {
    private final PageFile file;
    private final PageManager pageman;
    final PhysicalFreeRowIdManager freeman;
    private static final short DATA_PER_PAGE = 4080;
    private long cachedLastAllocatedRecordPage = Long.MIN_VALUE;
    private short cachedLastAllocatedRecordOffset = Short.MIN_VALUE;

    PhysicalRowIdManager(PageFile file, PageManager pageManager) throws IOException {
        this.file = file;
        this.pageman = pageManager;
        this.freeman = new PhysicalFreeRowIdManager(file, pageManager);
    }

    long insert(byte[] data, int start, int length) throws IOException {
        if (length < 1) {
            throw new IllegalArgumentException("Length is <1");
        }
        if (start < 0) {
            throw new IllegalArgumentException("negative start");
        }
        long retval = this.alloc(length);
        this.write(retval, data, start, length);
        return retval;
    }

    long update(long rowid, byte[] data, int start, int length) throws IOException {
        short head;
        PageIo page = this.file.get(rowid >>> 12);
        int availSize = RecordHeader.getAvailableSize(page, head = (short)(rowid & 0xFFFL));
        if (length > availSize || availSize - length > 254) {
            this.file.release(page);
            this.free(rowid);
            rowid = this.alloc(length);
        } else {
            this.file.release(page);
        }
        this.write(rowid, data, start, length);
        return rowid;
    }

    void fetch(DataInputOutput out, long rowid) throws IOException {
        short head;
        long current = rowid >>> 12;
        PageIo page = this.file.get(current);
        int size = RecordHeader.getCurrentSize(page, head = (short)(rowid & 0xFFFL));
        if (size == 0) {
            this.file.release(current, false);
            return;
        }
        int leftToRead = size;
        int dataOffset = head + 3;
        while (leftToRead > 0) {
            int toCopy = 4096 - dataOffset;
            if (leftToRead < toCopy) {
                toCopy = leftToRead;
            }
            out.writeFromByteBuffer(page.getData(), dataOffset, toCopy);
            this.file.release(page);
            if ((leftToRead -= toCopy) <= 0) continue;
            current = this.pageman.getNext(current);
            page = this.file.get(current);
            dataOffset = 16;
        }
    }

    private long alloc(int size) throws IOException {
        long retval = this.freeman.getFreeRecord(size = RecordHeader.roundAvailableSize(size));
        if (retval == 0L) {
            retval = this.allocNew(size, this.pageman.getLast((short)1));
        }
        return retval;
    }

    private long allocNew(int size, long start) throws IOException {
        PageIo curPage;
        if (start == 0L || this.cachedLastAllocatedRecordPage == start && this.cachedLastAllocatedRecordOffset == 4096) {
            start = this.pageman.allocate((short)1);
            curPage = this.file.get(start);
            curPage.dataPageSetFirst((short)16);
            this.cachedLastAllocatedRecordOffset = (short)16;
            this.cachedLastAllocatedRecordPage = curPage.getPageId();
            RecordHeader.setAvailableSize(curPage, (short)16, 0);
            RecordHeader.setCurrentSize(curPage, (short)16, 0);
        } else {
            curPage = this.file.get(start);
        }
        short pos = curPage.dataPageGetFirst();
        if (pos == 0) {
            this.file.release(curPage);
            return this.allocNew(size, 0L);
        }
        short hdr = pos;
        if (this.cachedLastAllocatedRecordPage != curPage.getPageId()) {
            int availSize = RecordHeader.getAvailableSize(curPage, hdr);
            while (availSize != 0 && pos < 4096) {
                if ((pos = (short)(pos + (availSize + 3))) == 4096) {
                    this.file.release(curPage);
                    return this.allocNew(size, 0L);
                }
                hdr = pos;
                availSize = RecordHeader.getAvailableSize(curPage, hdr);
            }
        } else {
            hdr = this.cachedLastAllocatedRecordOffset;
            pos = this.cachedLastAllocatedRecordOffset;
        }
        if (pos == 3) {
            this.file.release(curPage);
        }
        if (hdr > 4080) {
            this.file.release(curPage);
            return this.allocNew(size, 0L);
        }
        long retval = (start << 12) + (long)pos;
        int freeHere = 4096 - pos - 3;
        if (freeHere < size) {
            int neededLeft;
            int lastSize = (size - freeHere) % 4080;
            if (size < 4080 && 4080 - lastSize < 19) {
                size += 4080 - lastSize;
                size = RecordHeader.roundAvailableSize(size);
            }
            RecordHeader.setAvailableSize(curPage, hdr, size);
            this.file.release(start, true);
            for (neededLeft = size - freeHere; neededLeft >= 4080; neededLeft -= 4080) {
                start = this.pageman.allocate((short)1);
                curPage = this.file.get(start);
                curPage.dataPageSetFirst((short)0);
                this.file.release(start, true);
            }
            if (neededLeft > 0) {
                start = this.pageman.allocate((short)1);
                curPage = this.file.get(start);
                curPage.dataPageSetFirst((short)(16 + neededLeft));
                this.file.release(start, true);
                this.cachedLastAllocatedRecordOffset = (short)(16 + neededLeft);
                this.cachedLastAllocatedRecordPage = curPage.getPageId();
            }
        } else {
            if (freeHere - size <= 19) {
                size = freeHere;
            }
            RecordHeader.setAvailableSize(curPage, hdr, size);
            this.file.release(start, true);
            this.cachedLastAllocatedRecordOffset = (short)(hdr + 3 + size);
            this.cachedLastAllocatedRecordPage = curPage.getPageId();
        }
        return retval;
    }

    void free(long id) throws IOException {
        long curPageId = id >>> 12;
        PageIo curPage = this.file.get(curPageId);
        short offset = (short)(id & 0xFFFL);
        RecordHeader.setCurrentSize(curPage, offset, 0);
        int size = RecordHeader.getAvailableSize(curPage, offset);
        if (offset + 3 + size > 8176) {
            int numOfPagesToSkip = (size - (4096 - (offset - 3))) / 4080;
            RecordHeader.setAvailableSize(curPage, offset, size -= numOfPagesToSkip * 4080);
            long nextPage = curPage.pageHeaderGetNext();
            this.file.release(curPage);
            for (int i = 0; i < numOfPagesToSkip; ++i) {
                PageIo page = this.file.get(nextPage);
                long nextPage2 = page.pageHeaderGetNext();
                this.file.release(page);
                this.pageman.free((short)1, nextPage);
                nextPage = nextPage2;
            }
        } else {
            this.file.release(curPage);
        }
        this.freeman.putFreeRecord(id, size);
    }

    private void write(long rowid, byte[] data, int start, int length) throws IOException {
        long current = rowid >>> 12;
        PageIo page = this.file.get(current);
        short hdr = (short)(rowid & 0xFFFL);
        RecordHeader.setCurrentSize(page, hdr, length);
        if (length == 0) {
            this.file.release(current, true);
            return;
        }
        int offsetInBuffer = start;
        int leftToWrite = length;
        int dataOffset = hdr + 3;
        while (leftToWrite > 0) {
            int toCopy = 4096 - dataOffset;
            if (leftToWrite < toCopy) {
                toCopy = leftToWrite;
            }
            page.writeByteArray(data, offsetInBuffer, dataOffset, toCopy);
            offsetInBuffer += toCopy;
            this.file.release(current, true);
            if ((leftToWrite -= toCopy) <= 0) continue;
            current = this.pageman.getNext(current);
            page = this.file.get(current);
            dataOffset = 16;
        }
    }

    void rollback() throws IOException {
        this.cachedLastAllocatedRecordPage = Long.MIN_VALUE;
        this.cachedLastAllocatedRecordOffset = Short.MIN_VALUE;
        this.freeman.rollback();
    }

    void commit() throws IOException {
        this.freeman.commit();
    }
}

