/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jdbm.DBAbstract;
import org.apache.jdbm.DataInputOutput;
import org.apache.jdbm.LongPacker;
import org.apache.jdbm.Serialization;
import org.apache.jdbm.Serializer;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SerialClassInfo {
    static final Serializer<ArrayList<ClassInfo>> serializer = new Serializer<ArrayList<ClassInfo>>(){

        @Override
        public void serialize(DataOutput out, ArrayList<ClassInfo> obj) throws IOException {
            LongPacker.packInt(out, obj.size());
            for (ClassInfo ci : obj) {
                out.writeUTF(ci.getName());
                out.writeBoolean(ci.isEnum);
                out.writeBoolean(ci.isExternalizable);
                if (ci.isExternalizable) continue;
                LongPacker.packInt(out, ci.fields.size());
                for (FieldInfo fi : ci.fields) {
                    out.writeUTF(fi.getName());
                    out.writeBoolean(fi.isPrimitive());
                    out.writeUTF(fi.getType());
                }
            }
        }

        @Override
        public ArrayList<ClassInfo> deserialize(DataInput in) throws IOException, ClassNotFoundException {
            int size = LongPacker.unpackInt(in);
            ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>(size);
            for (int i = 0; i < size; ++i) {
                String className = in.readUTF();
                boolean isEnum = in.readBoolean();
                boolean isExternalizable = in.readBoolean();
                int fieldsNum = isExternalizable ? 0 : LongPacker.unpackInt(in);
                FieldInfo[] fields = new FieldInfo[fieldsNum];
                for (int j = 0; j < fieldsNum; ++j) {
                    fields[j] = new FieldInfo(in.readUTF(), in.readBoolean(), in.readUTF(), Class.forName(className));
                }
                ret.add(new ClassInfo(className, fields, isEnum, isExternalizable));
            }
            return ret;
        }
    };
    long serialClassInfoRecid;
    ArrayList<ClassInfo> registered;
    Map<Class, Integer> class2classId = new HashMap<Class, Integer>();
    Map<Integer, Class> classId2class = new HashMap<Integer, Class>();
    final DBAbstract db;
    private static ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
    private static Map<Class, Constructor> class2constuctor = new HashMap<Class, Constructor>();

    public SerialClassInfo(DBAbstract db, long serialClassInfoRecid, ArrayList<ClassInfo> registered) {
        this.db = db;
        this.serialClassInfoRecid = serialClassInfoRecid;
        this.registered = registered;
    }

    public void registerClass(Class clazz) throws IOException {
        if (clazz != Object.class) {
            this.assertClassSerializable(clazz);
        }
        if (this.containsClass(clazz)) {
            return;
        }
        ObjectStreamField[] streamFields = this.getFields(clazz);
        FieldInfo[] fields = new FieldInfo[streamFields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField sf = streamFields[i];
            fields[i] = new FieldInfo(sf, clazz);
        }
        ClassInfo i = new ClassInfo(clazz.getName(), fields, clazz.isEnum(), Externalizable.class.isAssignableFrom(clazz));
        this.class2classId.put(clazz, this.registered.size());
        this.classId2class.put(this.registered.size(), clazz);
        this.registered.add(i);
        if (this.db != null) {
            this.db.update(this.serialClassInfoRecid, (Serialization)this, this.db.defaultSerializationSerializer);
        }
    }

    private ObjectStreamField[] getFields(Class clazz) {
        ObjectStreamField[] fields = null;
        ClassInfo classInfo = null;
        Integer classId = this.class2classId.get(clazz);
        if (classId != null) {
            classInfo = this.registered.get(classId);
            fields = classInfo.getObjectStreamFields();
        }
        if (fields == null) {
            ObjectStreamClass streamClass = ObjectStreamClass.lookup(clazz);
            Serialization.FastArrayList<ObjectStreamField> fieldsList = new Serialization.FastArrayList<ObjectStreamField>();
            while (streamClass != null) {
                for (ObjectStreamField f : streamClass.getFields()) {
                    fieldsList.add(f);
                }
                clazz = clazz.getSuperclass();
                streamClass = ObjectStreamClass.lookup(clazz);
            }
            fields = new ObjectStreamField[fieldsList.size()];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = (ObjectStreamField)fieldsList.get(i);
            }
            if (classInfo != null) {
                classInfo.setObjectStreamFields(fields);
            }
        }
        return fields;
    }

    private void assertClassSerializable(Class clazz) throws NotSerializableException, InvalidClassException {
        if (this.containsClass(clazz)) {
            return;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
    }

    public Object getFieldValue(String fieldName, Object object) {
        try {
            this.registerClass(object.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClassInfo classInfo = this.registered.get(this.class2classId.get(object.getClass()));
        return this.getFieldValue(classInfo.getField(fieldName), object);
    }

    public Object getFieldValue(FieldInfo fieldInfo, Object object) {
        Object fieldAccessor = fieldInfo.getter;
        try {
            if (fieldAccessor instanceof Method) {
                Method m = (Method)fieldAccessor;
                return m.invoke(object, new Object[0]);
            }
            Field f = (Field)fieldAccessor;
            return f.get(object);
        }
        catch (Exception e) {
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.getName());
        }
    }

    public void setFieldValue(String fieldName, Object object, Object value) {
        try {
            this.registerClass(object.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClassInfo classInfo = this.registered.get(this.class2classId.get(object.getClass()));
        this.setFieldValue(classInfo.getField(fieldName), object, value);
    }

    public void setFieldValue(FieldInfo fieldInfo, Object object, Object value) {
        Object fieldAccessor = fieldInfo.setter;
        try {
            if (fieldAccessor instanceof Method) {
                Method m = (Method)fieldAccessor;
                m.invoke(object, value);
            } else {
                Field f = (Field)fieldAccessor;
                f.set(object, value);
            }
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.getName());
        }
    }

    public boolean containsClass(Class clazz) {
        return this.class2classId.get(clazz) != null;
    }

    public int getClassId(Class clazz) {
        Integer classId = this.class2classId.get(clazz);
        if (classId != null) {
            return classId;
        }
        throw new Error("Class is not registered: " + clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(DataOutput out, Object obj, Serialization.FastArrayList objectStack) throws IOException {
        this.registerClass(obj.getClass());
        int classId = this.getClassId(obj.getClass());
        LongPacker.packInt(out, classId);
        ClassInfo classInfo = this.registered.get(classId);
        if (classInfo.isExternalizable) {
            Externalizable o = (Externalizable)obj;
            DataInputOutput out2 = (DataInputOutput)out;
            try {
                out2.serializer = this;
                out2.objectStack = objectStack;
                o.writeExternal(out2);
            }
            finally {
                out2.serializer = null;
                out2.objectStack = null;
            }
            return;
        }
        if (classInfo.isEnum) {
            int ordinal = ((Enum)obj).ordinal();
            LongPacker.packInt(out, ordinal);
        }
        ObjectStreamField[] fields = this.getFields(obj.getClass());
        LongPacker.packInt(out, fields.length);
        for (ObjectStreamField f : fields) {
            int fieldId = classInfo.getFieldId(f.getName());
            if (fieldId == -1) {
                fieldId = classInfo.addFieldInfo(new FieldInfo(f, obj.getClass()));
                this.db.update(this.serialClassInfoRecid, (Serialization)this, this.db.defaultSerializationSerializer);
            }
            LongPacker.packInt(out, fieldId);
            Object fieldValue = this.getFieldValue(classInfo.getField(fieldId), obj);
            this.serialize(out, fieldValue, objectStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(DataInput in, Serialization.FastArrayList objectStack) throws IOException {
        try {
            Object o;
            int classId = LongPacker.unpackInt(in);
            ClassInfo classInfo = this.registered.get(classId);
            Class<?> clazz = this.classId2class.get(classId);
            if (clazz == null) {
                clazz = Class.forName(classInfo.getName());
            }
            this.assertClassSerializable(clazz);
            if (classInfo.isEnum) {
                int ordinal = LongPacker.unpackInt(in);
                o = clazz.getEnumConstants()[ordinal];
            } else {
                o = SerialClassInfo.createInstance(clazz, Object.class);
            }
            objectStack.add(o);
            if (classInfo.isExternalizable) {
                Externalizable oo = (Externalizable)o;
                DataInputOutput in2 = (DataInputOutput)in;
                try {
                    in2.serializer = this;
                    in2.objectStack = objectStack;
                    oo.readExternal(in2);
                }
                finally {
                    in2.serializer = null;
                    in2.objectStack = null;
                }
            } else {
                int fieldCount = LongPacker.unpackInt(in);
                for (int i = 0; i < fieldCount; ++i) {
                    int fieldId = LongPacker.unpackInt(in);
                    FieldInfo f = classInfo.getField(fieldId);
                    Object fieldValue = this.deserialize(in, objectStack);
                    this.setFieldValue(f, o, fieldValue);
                }
            }
            return o;
        }
        catch (Exception e) {
            throw new Error("Could not instanciate class", e);
        }
    }

    private static <T> T createInstance(Class<T> clazz, Class<? super T> parent) {
        try {
            Constructor<?> intConstr = class2constuctor.get(clazz);
            if (intConstr == null) {
                Constructor<? super T> objDef = parent.getDeclaredConstructor(new Class[0]);
                intConstr = rf.newConstructorForSerialization(clazz, objDef);
                class2constuctor.put(clazz, intConstr);
            }
            return clazz.cast(intConstr.newInstance(new Object[0]));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    protected abstract Object deserialize(DataInput var1, Serialization.FastArrayList var2) throws IOException, ClassNotFoundException;

    protected abstract void serialize(DataOutput var1, Object var2, Serialization.FastArrayList var3) throws IOException;

    static class FieldInfo {
        private final String name;
        private final boolean primitive;
        private final String type;
        private Class typeClass;
        private final Class clazz;
        private Object setter;
        private int setterIndex;
        private Object getter;
        private int getterIndex;

        public FieldInfo(String name, boolean primitive, String type, Class clazz) {
            this.name = name;
            this.primitive = primitive;
            this.type = type;
            this.clazz = clazz;
            try {
                this.typeClass = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                this.typeClass = null;
            }
            this.initSetter();
            this.initGetter();
        }

        private void initSetter() {
            String setterName = "set" + this.firstCharCap(this.name);
            String fieldSetterName = this.clazz.getName() + "#" + setterName;
            for (Class aClazz = this.clazz; aClazz != Object.class; aClazz = aClazz.getSuperclass()) {
                try {
                    Method m = aClazz.getMethod(setterName, this.typeClass);
                    if (m != null) {
                        this.setter = m;
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field f = aClazz.getDeclaredField(this.name);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    this.setter = f;
                    return;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }

        private void initGetter() {
            String getterName = "get" + this.firstCharCap(this.name);
            String fieldSetterName = this.clazz.getName() + "#" + getterName;
            for (Class aClazz = this.clazz; aClazz != Object.class; aClazz = aClazz.getSuperclass()) {
                try {
                    Method m = aClazz.getMethod(getterName, new Class[0]);
                    if (m != null) {
                        this.getter = m;
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field f = aClazz.getDeclaredField(this.name);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    this.getter = f;
                    return;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }

        public FieldInfo(ObjectStreamField sf, Class clazz) {
            this(sf.getName(), sf.isPrimitive(), sf.getType().getName(), clazz);
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public String getType() {
            return this.type;
        }

        private String firstCharCap(String s) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
    }

    static class ClassInfo {
        private final String name;
        private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
        private final Map<String, FieldInfo> name2fieldInfo = new HashMap<String, FieldInfo>();
        private final Map<String, Integer> name2fieldId = new HashMap<String, Integer>();
        private ObjectStreamField[] objectStreamFields;
        final boolean isEnum;
        final boolean isExternalizable;

        ClassInfo(String name, FieldInfo[] fields, boolean isEnum, boolean isExternalizable) {
            this.name = name;
            this.isEnum = isEnum;
            this.isExternalizable = isExternalizable;
            for (FieldInfo f : fields) {
                this.name2fieldId.put(f.getName(), this.fields.size());
                this.fields.add(f);
                this.name2fieldInfo.put(f.getName(), f);
            }
        }

        public String getName() {
            return this.name;
        }

        public FieldInfo[] getFields() {
            return (FieldInfo[])this.fields.toArray();
        }

        public FieldInfo getField(String name) {
            return this.name2fieldInfo.get(name);
        }

        public int getFieldId(String name) {
            Integer fieldId = this.name2fieldId.get(name);
            if (fieldId != null) {
                return fieldId;
            }
            return -1;
        }

        public FieldInfo getField(int serialId) {
            return this.fields.get(serialId);
        }

        public int addFieldInfo(FieldInfo field) {
            this.name2fieldId.put(field.getName(), this.fields.size());
            this.name2fieldInfo.put(field.getName(), field);
            this.fields.add(field);
            return this.fields.size() - 1;
        }

        public ObjectStreamField[] getObjectStreamFields() {
            return this.objectStreamFields;
        }

        public void setObjectStreamFields(ObjectStreamField[] objectStreamFields) {
            this.objectStreamFields = objectStreamFields;
        }
    }
}

