/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.apache.jdbm.PageFile;
import org.apache.jdbm.Storage;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

class StorageDiskMapped
implements Storage {
    static final String IDR = ".i";
    static final String DBR = ".d";
    static final long PAGES_PER_FILE = 262144L;
    private ArrayList<FileChannel> channels = new ArrayList();
    private ArrayList<FileChannel> channelsTranslation = new ArrayList();
    private IdentityHashMap<FileChannel, MappedByteBuffer> buffers = new IdentityHashMap();
    private String fileName;
    private boolean transactionsDisabled;
    private boolean readonly;
    private boolean lockingDisabled;

    public StorageDiskMapped(String fileName, boolean readonly, boolean transactionsDisabled, boolean lockingDisabled) throws IOException {
        this.fileName = fileName;
        this.transactionsDisabled = transactionsDisabled;
        this.readonly = readonly;
        this.lockingDisabled = lockingDisabled;
        try {
            if (!lockingDisabled) {
                this.getChannel(0L).lock();
            }
        }
        catch (IOException e) {
            throw new IOException("Could not lock DB file: " + fileName, e);
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Could not lock DB file: " + fileName, e);
        }
    }

    private FileChannel getChannel(long pageNumber) throws IOException {
        int fileNumber = (int)(Math.abs(pageNumber) / 262144L);
        ArrayList<FileChannel> c = pageNumber >= 0L ? this.channels : this.channelsTranslation;
        for (int i = c.size(); i <= fileNumber; ++i) {
            c.add(null);
        }
        FileChannel ret = (FileChannel)c.get(fileNumber);
        if (ret == null) {
            String name = StorageDiskMapped.makeFileName(this.fileName, pageNumber, fileNumber);
            ret = new RandomAccessFile(name, "rw").getChannel();
            c.set(fileNumber, ret);
            this.buffers.put(ret, ret.map(FileChannel.MapMode.READ_WRITE, 0L, ret.size()));
        }
        return ret;
    }

    static String makeFileName(String fileName, long pageNumber, int fileNumber) {
        return fileName + (pageNumber >= 0L ? DBR : IDR) + "." + fileNumber;
    }

    public void write(long pageNumber, ByteBuffer data) throws IOException {
        if (this.transactionsDisabled && data.isDirect()) {
            return;
        }
        FileChannel f = this.getChannel(pageNumber);
        int offsetInFile = (int)(Math.abs(pageNumber) % 262144L * 4096L);
        MappedByteBuffer b = this.buffers.get(f);
        if (b.limit() <= offsetInFile) {
            int increment = Math.min(0x400000, offsetInFile / 10);
            increment -= increment % 4096;
            long newFileSize = offsetInFile + 4096 + increment;
            newFileSize = Math.min(0x40000000L, newFileSize);
            f.position(newFileSize - 1L);
            f.write(ByteBuffer.allocate(1));
            this.unmapBuffer(b);
            b = f.map(FileChannel.MapMode.READ_WRITE, 0L, newFileSize);
            this.buffers.put(f, b);
        }
        b.position(offsetInFile);
        data.rewind();
        b.put(data);
    }

    private void unmapBuffer(MappedByteBuffer b) {
        Cleaner cleaner;
        if (b != null && (cleaner = ((DirectBuffer)((Object)b)).cleaner()) != null) {
            cleaner.clean();
        }
    }

    public ByteBuffer read(long pageNumber) throws IOException {
        FileChannel f = this.getChannel(pageNumber);
        int offsetInFile = (int)(Math.abs(pageNumber) % 262144L * 4096L);
        MappedByteBuffer b = this.buffers.get(f);
        if (b == null) {
            b = f.map(FileChannel.MapMode.READ_WRITE, 0L, f.size());
        }
        if (b.limit() <= offsetInFile) {
            return ByteBuffer.wrap(PageFile.CLEAN_DATA).asReadOnlyBuffer();
        }
        b.position(offsetInFile);
        ByteBuffer ret = b.slice();
        ret.limit(4096);
        if (!this.transactionsDisabled || this.readonly) {
            ret = ret.asReadOnlyBuffer();
        }
        return ret;
    }

    public void forceClose() throws IOException {
        for (FileChannel f : this.channels) {
            if (f == null) continue;
            f.close();
            this.unmapBuffer(this.buffers.get(f));
        }
        for (FileChannel f : this.channelsTranslation) {
            if (f == null) continue;
            f.close();
            this.unmapBuffer(this.buffers.get(f));
        }
        this.channels = null;
        this.channelsTranslation = null;
        this.buffers = null;
    }

    public void sync() throws IOException {
        for (MappedByteBuffer b : this.buffers.values()) {
            b.force();
        }
    }

    public DataOutputStream openTransactionLog() throws IOException {
        String logName = this.fileName + ".t";
        final FileOutputStream fileOut = new FileOutputStream(logName);
        return new DataOutputStream(new BufferedOutputStream(fileOut)){

            public void flush() throws IOException {
                super.flush();
                fileOut.flush();
                fileOut.getFD().sync();
            }
        };
    }

    public void deleteAllFiles() throws IOException {
        this.deleteTransactionLog();
        StorageDiskMapped.deleteFiles(this.fileName);
    }

    static void deleteFiles(String fileName) {
        String name;
        File f;
        boolean exists;
        int i = 0;
        while (true) {
            if ((exists = (f = new File(name = StorageDiskMapped.makeFileName(fileName, 1L, i))).exists()) && !f.delete()) {
                f.deleteOnExit();
            }
            if (!exists) break;
            ++i;
        }
        i = 0;
        while (true) {
            if ((exists = (f = new File(name = StorageDiskMapped.makeFileName(fileName, -1L, i))).exists()) && !f.delete()) {
                f.deleteOnExit();
            }
            if (!exists) break;
            ++i;
        }
    }

    public DataInputStream readTransactionLog() {
        File logFile = new File(this.fileName + ".t");
        if (!logFile.exists()) {
            return null;
        }
        if (logFile.length() == 0L) {
            logFile.delete();
            return null;
        }
        DataInputStream ois = null;
        try {
            ois = new DataInputStream(new BufferedInputStream(new FileInputStream(logFile)));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            if (ois.readShort() != 4960) {
                throw new Error("Bad magic on log file");
            }
        }
        catch (IOException e) {
            logFile.delete();
            return null;
        }
        return ois;
    }

    public void deleteTransactionLog() {
        File logFile = new File(this.fileName + ".t");
        if (logFile.exists()) {
            logFile.delete();
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }
}

