/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.crypto.Cipher;
import org.apache.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    static final String EMPTY_STRING = "";
    static final Comparator COMPARABLE_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    static final Serializer<Object> NULL_SERIALIZER = new Serializer<Object>(){

        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            out.writeByte(11);
        }

        @Override
        public Object deserialize(DataInput in) throws IOException, ClassNotFoundException {
            in.readByte();
            return null;
        }
    };

    Utils() {
    }

    public static byte[] encrypt(Cipher cipherIn, ByteBuffer b) {
        if (cipherIn == null && b.hasArray()) {
            return b.array();
        }
        byte[] bb = new byte[4096];
        b.rewind();
        b.get(bb, 0, 4096);
        return Utils.encrypt(cipherIn, bb);
    }

    public static byte[] encrypt(Cipher cipherIn, byte[] b) {
        if (cipherIn == null) {
            return b;
        }
        try {
            return cipherIn.doFinal(b);
        }
        catch (Exception e) {
            throw new IOError(e);
        }
    }

    static String formatSpaceUsage(long size) {
        if ((double)size < 10000.0) {
            return size + "B";
        }
        if ((double)size < 1.0E7) {
            return EMPTY_STRING + Math.round(1.0 * (double)size / 1024.0) + "KB";
        }
        if ((double)size < 1.0E10) {
            return EMPTY_STRING + Math.round(1.0 * (double)size / 1000000.0) + "MB";
        }
        return EMPTY_STRING + Math.round(1.0 * (double)size / 1.0E9) + "GB";
    }

    static boolean allZeros(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 0) continue;
            return false;
        }
        return true;
    }

    static <E> E max(E e1, E e2, Comparator comp) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (comp == null) {
            comp = COMPARABLE_COMPARATOR;
        }
        return comp.compare(e1, e2) < 0 ? e2 : e1;
    }

    static <E> E min(E e1, E e2, Comparator comp) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (comp == null) {
            comp = COMPARABLE_COMPARATOR;
        }
        return comp.compare(e1, e2) > 0 ? e2 : e1;
    }
}

