/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.DefaultReservation;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.Reservation;
import net.tomp2p.connection.Scheduler;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.p2p.ConnectionConfiguration;
import net.tomp2p.p2p.Statistics;
import org.jboss.netty.channel.ChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionReservation {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionReservation.class);
    private final Semaphore semaphoreCreating;
    private final Semaphore semaphoreOpen;
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final MessageLogger messageLoggerFilter;
    private final int maxPermitsCreating;
    private final int maxPermitsOpen;
    private final Statistics statistics;
    private final Map<ChannelCreator, Semaphore> activeChannelCreators = new HashMap<ChannelCreator, Semaphore>();
    private final Map<ChannelCreator, StackTraceElement[]> debug = new ConcurrentHashMap<ChannelCreator, StackTraceElement[]>();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Scheduler scheduler;
    private volatile Reservation reservation = new DefaultReservation();

    public ConnectionReservation(ChannelFactory tcpClientChannelFactory, ChannelFactory udpChannelFactory, ConnectionConfiguration configuration, MessageLogger messageLoggerFilter, Statistics statistics, Scheduler scheduler) {
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpChannelFactory;
        this.maxPermitsCreating = configuration.getMaxCreating();
        this.maxPermitsOpen = configuration.getMaxOpenConnection();
        this.semaphoreCreating = new Semaphore(this.maxPermitsCreating);
        this.semaphoreOpen = new Semaphore(this.maxPermitsOpen);
        this.messageLoggerFilter = messageLoggerFilter;
        this.statistics = statistics;
        this.scheduler = scheduler;
    }

    public FutureChannelCreator reserve(int permits) {
        return this.reserve(permits, false, "default");
    }

    public FutureChannelCreator reserve(int permits, String name) {
        return this.reserve(permits, false, name);
    }

    public FutureChannelCreator reserve(int permits, boolean keepAliveAndReuse) {
        return this.reserve(permits, keepAliveAndReuse, "default");
    }

    public FutureChannelCreator reserve(final int permits, final boolean keepAliveAndReuse, final String name) {
        final FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        this.getReservation().runDeadLockProof(this.scheduler, new FutureRunnable(){

            @Override
            public void run() {
                ChannelCreator channelCreator = ConnectionReservation.this.reserve0(permits, keepAliveAndReuse, name);
                if (channelCreator != null) {
                    futureChannelCreator.reserved(channelCreator);
                } else {
                    futureChannelCreator.setFailed("could not reserve connection, most likely we shutdown");
                }
            }

            @Override
            public void failed(String reason) {
                futureChannelCreator.setFailed(reason);
            }
        });
        return futureChannelCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelCreator reserve0(int permits, boolean keepAliveAndReuse, String name) {
        if (this.counter.incrementAndGet() < 0) {
            logger.warn("Cannot acquire " + permits + " connections, shutting down");
            return null;
        }
        try {
            this.getReservation().prepareDeadLockCheck();
            boolean acquired = this.getReservation().acquire(keepAliveAndReuse ? this.semaphoreOpen : this.semaphoreCreating, permits);
            if (acquired) {
                ChannelCreator channelCreator = new ChannelCreator(permits, this.statistics, this.messageLoggerFilter, this.tcpClientChannelFactory, this.udpChannelFactory, keepAliveAndReuse, name, Thread.currentThread().getId(), this.scheduler);
                if (logger.isDebugEnabled()) {
                    logger.debug("created channels for Thread " + Thread.currentThread().getName() + "/" + Thread.currentThread().getId());
                    this.debug.put(channelCreator, Thread.currentThread().getStackTrace());
                }
                Object object = this.activeChannelCreators;
                synchronized (object) {
                    this.activeChannelCreators.put(channelCreator, keepAliveAndReuse ? this.semaphoreOpen : this.semaphoreCreating);
                }
                object = channelCreator;
                return object;
            }
            logger.warn("Cannot acquire " + permits + " connections");
            ChannelCreator channelCreator = null;
            return channelCreator;
        }
        finally {
            this.counter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ChannelCreator channelCreator, int permits) {
        Semaphore semaphore;
        boolean hasNoPermits;
        Object object = this.activeChannelCreators;
        synchronized (object) {
            hasNoPermits = channelCreator.release(permits);
            if (hasNoPermits) {
                semaphore = this.activeChannelCreators.remove(channelCreator);
                this.activeChannelCreators.notifyAll();
            } else {
                semaphore = this.activeChannelCreators.get(channelCreator);
            }
        }
        semaphore.release(permits);
        object = semaphore;
        synchronized (object) {
            semaphore.notifyAll();
        }
        if (hasNoPermits) {
            this.getReservation().removeDeadLockCheck(channelCreator.getCreatorThread());
            if (logger.isDebugEnabled()) {
                logger.debug("full release (" + permits + "), we can remove the channelcreator from the list " + semaphore.availablePermits() + ", which was created from thread: " + channelCreator.getCreatorThread() + " / " + channelCreator.getName());
                this.debug.remove(channelCreator);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("partial release (" + permits + "), we cannot remove the channelcreator from the list " + semaphore.availablePermits() + ", which was created from thread: " + channelCreator.getCreatorThread());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("released " + channelCreator.getPermits() + ", in total we have " + this.maxPermitsCreating + "/" + this.maxPermitsOpen + ", now we have " + semaphore.availablePermits());
        }
    }

    public void release(ChannelCreator channelCreator) {
        this.release(channelCreator, channelCreator.getPermits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<ChannelCreator> allCreators;
        this.scheduler.shutdown();
        if (logger.isDebugEnabled()) {
            logger.debug("Shutdown");
        }
        this.getReservation().shutdown();
        while (this.counter.compareAndSet(0, Integer.MIN_VALUE)) {
            Semaphore semaphore = this.semaphoreCreating;
            synchronized (semaphore) {
                this.semaphoreCreating.notifyAll();
            }
            semaphore = this.semaphoreOpen;
            synchronized (semaphore) {
                this.semaphoreOpen.notifyAll();
            }
        }
        Map<ChannelCreator, Semaphore> map = this.activeChannelCreators;
        synchronized (map) {
            allCreators = new ArrayList<ChannelCreator>(this.activeChannelCreators.size());
            allCreators.addAll(this.activeChannelCreators.keySet());
        }
        for (ChannelCreator channelCreator : allCreators) {
            channelCreator.shutdown();
        }
        map = this.activeChannelCreators;
        synchronized (map) {
            while (this.activeChannelCreators.size() != 0) {
                try {
                    this.activeChannelCreators.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.semaphoreCreating.acquireUninterruptibly(this.maxPermitsCreating);
        this.semaphoreOpen.acquireUninterruptibly(this.maxPermitsOpen);
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }
}

