/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import net.tomp2p.connection.Bindings;

public class DiscoverNetworks {
    public static String discoverInterfaces(Bindings bindings) throws IOException {
        StringBuilder sb = new StringBuilder("Discover status: ");
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface networkInterface = e.nextElement();
            if (bindings.isAllInterfaces()) {
                sb.append(" ++").append(networkInterface.getName());
                sb.append(DiscoverNetworks.discoverNetwork(networkInterface, bindings)).append(",");
                continue;
            }
            if (bindings.containsInterface(networkInterface.getName())) {
                sb.append(" +").append(networkInterface.getName());
                sb.append(DiscoverNetworks.discoverNetwork(networkInterface, bindings)).append(",");
                continue;
            }
            sb.append(" -").append(networkInterface.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append(".").toString();
    }

    public static String discoverNetwork(NetworkInterface networkInterface, Bindings bindings) {
        StringBuilder sb = new StringBuilder("( ");
        for (InterfaceAddress iface : networkInterface.getInterfaceAddresses()) {
            InetAddress inet = iface.getAddress();
            if (iface.getBroadcast() != null && !bindings.getBroadcastAddresses().contains(iface.getBroadcast())) {
                bindings.addBroadcastAddress(iface.getBroadcast());
            }
            if (bindings.getFoundAddresses().contains(inet) || !bindings.isAllAddresses() && !bindings.getAddresses().contains(inet)) continue;
            if (inet instanceof Inet4Address && bindings.isIPv4()) {
                sb.append(inet).append(",");
                bindings.addFoundAddress(inet);
                continue;
            }
            if (!(inet instanceof Inet6Address) || !bindings.isIPv6()) continue;
            sb.append(inet).append(",");
            bindings.addFoundAddress(inet);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append(")").toString();
    }
}

