/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.utils.Timings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFutureImpl<K extends BaseFuture>
implements BaseFuture {
    private static final Logger logger = LoggerFactory.getLogger(BaseFutureImpl.class);
    private final List<BaseFutureListener<? extends BaseFuture>> listeners = new ArrayList<BaseFutureListener<? extends BaseFuture>>(1);
    private final List<Cancellable> cancellables = new ArrayList<Cancellable>(1);
    private final CountDownLatch listenersFinished = new CountDownLatch(1);
    protected final Object lock;
    protected boolean completed = false;
    protected BaseFuture.FutureType type = BaseFuture.FutureType.INIT;
    protected String reason = "unknown";
    private K self;

    protected void self(K self) {
        this.self = self;
    }

    public BaseFutureImpl() {
        this.lock = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.checkDeadlock();
            while (!this.completed) {
                this.lock.wait();
            }
            return this.self;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K awaitUninterruptibly() {
        Object object = this.lock;
        synchronized (object) {
            this.checkDeadlock();
            while (!this.completed) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.self;
        }
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(timeoutMillis, true);
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("This should never ever happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutMillis, boolean interrupt) throws InterruptedException {
        long startTime = timeoutMillis <= 0L ? 0L : Timings.currentTimeMillis();
        long waitTime = timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return this.completed;
            }
            if (waitTime <= 0L) {
                return this.completed;
            }
            this.checkDeadlock();
            do {
                block8: {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        if (!interrupt) break block8;
                        throw e;
                    }
                }
                if (!this.completed) continue;
                return true;
            } while ((waitTime = timeoutMillis - (Timings.currentTimeMillis() - startTime)) > 0L);
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuccess() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed && this.type == BaseFuture.FutureType.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed && this.type != BaseFuture.FutureType.OK;
        }
    }

    public K setFailed(BaseFuture origin) {
        return this.setFailed(origin.getFailedReason());
    }

    public K setFailed(String reason, BaseFuture origin) {
        StringBuilder sb = new StringBuilder(reason);
        return this.setFailed(sb.append(" <-> ").append(origin.getFailedReason()).toString());
    }

    public K setFailed(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return this.setFailed(stringWriter.toString());
    }

    public K setFailed(String reason, Throwable t) {
        StringBuilder sb = new StringBuilder(reason);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return this.setFailed(sb.append(" <-> ").append(stringWriter.toString()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K setFailed(String reason) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return this.self;
            }
            if (logger.isWarnEnabled()) {
                logger.warn("set failed reason: " + reason);
            }
            this.reason = reason;
            this.type = BaseFuture.FutureType.FAILED;
        }
        this.notifyListerenrs();
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailedReason() {
        StringBuffer sb = new StringBuffer("BaseFuture Status=(isComplete:");
        Object object = this.lock;
        synchronized (object) {
            sb.append(this.completed);
            sb.append(", reason:");
            sb.append(this.reason);
            sb.append(", type:");
            sb.append((Object)this.type);
            sb.append(")");
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture.FutureType getType() {
        Object object = this.lock;
        synchronized (object) {
            return this.type;
        }
    }

    protected boolean setCompletedAndNotify() {
        if (!this.completed) {
            this.completed = true;
            this.lock.notifyAll();
            return true;
        }
        return false;
    }

    public K awaitListeners() throws InterruptedException {
        this.listenersFinished.await();
        return this.self;
    }

    public K addListener(BaseFutureListener<? extends BaseFuture> listener) {
        return this.addListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K addListener(BaseFutureListener<? extends BaseFuture> listener, boolean last) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                notifyNow = true;
            } else if (last) {
                this.listeners.add(listener);
            } else {
                this.listeners.add(0, listener);
            }
        }
        if (notifyNow) {
            this.callOperationComplete(listener);
        }
        return this.self;
    }

    private void callOperationComplete(BaseFutureListener listener) {
        try {
            listener.operationComplete(this);
        }
        catch (Exception e) {
            try {
                listener.exceptionCaught(e);
            }
            catch (Exception e1) {
                if (logger.isErrorEnabled()) {
                    logger.error("Unexcpected exception in exceptionCaught()", (Throwable)e1);
                }
                e1.printStackTrace();
            }
        }
    }

    private void checkDeadlock() {
        String currentName = Thread.currentThread().getName();
        if (currentName.startsWith("Netty thread (non-blocking)/ ")) {
            throw new IllegalStateException("await*() in Netty I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    protected void notifyListerenrs() {
        for (BaseFutureListener<? extends BaseFuture> listener : this.listeners) {
            this.callOperationComplete(listener);
        }
        this.listenersFinished.countDown();
        this.listeners.clear();
    }

    private void notifyCancelation() {
        for (Cancellable cancellable : this.cancellables) {
            cancellable.cancel();
        }
        this.cancellables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture removeListener(BaseFutureListener<? extends BaseFuture> listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.listeners.remove(listener);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture addCancellation(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.cancellables.add(cancellable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture removeCancellation(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.cancellables.remove(cancellable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.type = BaseFuture.FutureType.CANCEL;
            this.reason = "canceled";
        }
        this.notifyCancelation();
        this.notifyListerenrs();
    }
}

