/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;

public class FutureRouting
extends BaseFutureImpl<FutureRouting> {
    private NavigableSet<PeerAddress> potentialHits;
    private SortedMap<PeerAddress, DigestInfo> directHits;
    private SortedSet<PeerAddress> routingPath;

    public FutureRouting() {
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeighbors(SortedMap<PeerAddress, DigestInfo> directHits, NavigableSet<PeerAddress> potentialHits, SortedSet<PeerAddress> routingPath, boolean isBootstrap, boolean isRoutingToOther) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.potentialHits = potentialHits;
            this.directHits = directHits;
            this.routingPath = routingPath;
            this.type = isBootstrap && isRoutingToOther ? (potentialHits.size() <= 1 && directHits.size() == 0 ? BaseFuture.FutureType.FAILED : BaseFuture.FutureType.OK) : BaseFuture.FutureType.OK;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableSet<PeerAddress> getPotentialHits() {
        Object object = this.lock;
        synchronized (object) {
            return this.potentialHits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableSet<PeerAddress> getDirectHits() {
        Object object = this.lock;
        synchronized (object) {
            if (this.directHits == null) {
                return null;
            }
            Set<PeerAddress> tmp = this.directHits.keySet();
            if (tmp instanceof NavigableSet) {
                return (NavigableSet)this.directHits.keySet();
            }
            TreeSet<PeerAddress> tmp2 = new TreeSet<PeerAddress>(this.directHits.comparator());
            tmp2.addAll(tmp);
            return tmp2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<PeerAddress, DigestInfo> getDirectHitsDigest() {
        Object object = this.lock;
        synchronized (object) {
            return this.directHits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<PeerAddress> getRoutingPath() {
        Object object = this.lock;
        synchronized (object) {
            return this.routingPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailedReason() {
        Object object = this.lock;
        synchronized (object) {
            return "FutureRouting -> complete:" + this.completed + ", type:" + this.type.toString() + ", direct:" + this.directHits.size() + ", neighbors:" + this.potentialHits.size();
        }
    }
}

